;---------------------------------------------------------------------------
;BINARY.ASM - Hugh Noland
;
;Prints out binary representation of decimal input from keyboard,
;which cannot exceed 4,294,967,295.
;---------------------------------------------------------------------------

cseg   segment
assume cs:cseg, ds:cseg
org 100h
.386

begin: jmp main

msg       db     10,13,"Enter number: $"
crlf      db     10,13,"$"
buf       db     13,?,11 dup(?)
ten       dd     10

main:
   mov dx,offset msg             ;call for input
   mov ah,9                      ;
   int 21h                       ;

   mov dx,offset buf
   call read_str                 ;Dos read-string function.  Input will
                                 ;be stored as string in buf
   mov dx,offset crlf            ;
   int 21h                       ;print carriage return, line feed

   mov si,offset buf
   inc si
   mov cl,[si]                   ;get string length in cx
   mov ch,0                      ;
   jcxz exit                     ;exit if no input
   dec cx                        ;dec cx so as not to multiply last
                                 ;digit by 10
   inc si                        ;ds:si==>first digit
   xor edx,edx
   xor eax,eax
   jcxz mm2
mm1:
   xor ebx,ebx
   mov bl,[si]                   ;get digit
   inc si
   sub bl,30h                    ;convert ASCII to decimal
   add eax,ebx                   ;add to previous result
   mul ten                       ;multiply sum by 10
   loop mm1
mm2:
   xor ebx,ebx
   mov bl,[si]                   ;get last digit
   sub bl,30h
   add eax,ebx                   ;add to previous result
   mov ebx,eax
   call convert                  ;call routine convert to binary and print

exit:
   mov ax,4c00h
   int 21h


;---------------------------------------------------------------------------
;Reads string input from keyboard and echoes character to screen.
;On entry ds:dx points to storage buffer.  User stores size of buffer
;in first byte of buffer.  The string length is returned in second
;byte of buffer.  String storage begins at third byte.
;Backspace may be used for editing during input.  Input is terminated
;by pressing enter, which is read into the string.  Therefore effective
;length of string = length indicated in first byte minus 1.  Length of buffer
;should equal length of string + 3 (first 2 bytes must be accomodated).
;---------------------------------------------------------------------------
read_str   proc
   push ax
   mov ah,0ah
   int 21h
   pop ax
   ret
read_str   endp

;---------------------------------------------------------------------------
;Prints number in EBX in binary
;---------------------------------------------------------------------------
convert   proc
   mov cx,33                     ;CX will count # of binary digits
b1:                              ;after discarding leading
   dec cl                        ;binary 0's
b2:                              ;
   rcl ebx,1                     ;
   jnc b1                        ;

   pushf                         ;preserve flags
   mov ax,cx                     ;
   push cx                       ;get remainder when # of digits is
   mov cx,4                      ;divided by 4
   xor dx,dx                     ;
   div cx                        ;
   pop cx                        ;
   mov si,dx                     ;and store in SI
   popf                          ;restore flags

   mov ah,2                      ;print using Dos function 2
b3:
   mov dl,0
   adc dl,30h
   cmp si,0                      ;when SI = 0, print a space
   jne b4                        ;
   push dx                       ;save DX
   mov dl,' '                    ;
   int 21h                       ;
   pop dx                        ;restore DX
   mov si,4                      ;after first group of digits
                                 ;print in groups of 4
b4:
   int 21h
   dec si
   rcl ebx,1
   loop b3
   ret
convert   endp

cseg   ends
end   begin
