 ;=============FONT.ASM=================
 ; Ease-C-Read.
 ; Program to make [], (), and {} characters taller on EGA/VGA screen.
 ; Public domain by Mike Dodd.  August 9, 1991.

 CSEG SEGMENT
 ASSUME CS:CSEG
 ORG 100h              ; .COM

 VERY_TALL   equ  1    ; 0 makes shorter characters
 BYTES_CHAR  equ  14   ; Number of bytes per character

 ;--------------------------------
 ; This macro loads BP with the offset of the new data, DX with the
 ; character to change, and calls INT 10h to store the bit map.
 ;--------------------------------

 FIX MACRO pointer, character
   mov  bp, offset pointer
   xor  dh, dh
   mov  dl, character
   int  10h
 endm

 ;-----------------------------------
 ; These registers remain the same through the Int 10h calls, so we
 ; don't have to reinitialize them for each character.
 ;------------------------------------

newchars PROC near
 push   cs
 pop    es                  ; ES = data table segment
 mov    cx, 1               ; CX = character count
 mov    bx, BYTES_CHAR SHL 8; BH = bytes/character, BL = 0
 mov    ax, 1100h           ; INT 10h, function 11, subfunction 0
 FIX left_bracket, '['
 FIX right_bracket, ']'
 FIX left_paren, '('
 FIX right_paren, ')'
 FIX left_brace, '{'
 FIX right_brace, '}'
 mov    ah, 09h
 mov    dx, offset install_msg
 int    21h
 mov    ax, 4C00h
 int    21h                 ; Terminate the program
newchars  ENDP

install_msg:
 db     'Braces have been fixed. --> (), {}, []', 0Dh, 0Ah, '$'

 ;-----------------------------
 ; Data for the new characters.  Each character contains 14 bytes.
 ; Two versions are given -- tall and very tall.
 ;-----------------------------

left_bracket:   ; Left square bracket: [
  if VERY_TALL
 db 1eh, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 1eh
  else
 db 0, 1eh, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 1eh, 0
  endif

right_bracket:  ; Right square bracket: ]
  if VERY_TALL
 db 78h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 78h
  else
 db 0, 78h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 78h, 0
  endif

left_paren:     ; Left parentheses: (
  if VERY_TALL
 db 06h, 0ch, 18h, 30h, 30h, 30h, 30h, 30h, 30h, 30h, 30h, 18h, 0ch, 06h
  else
 db 0, 06h, 0ch, 18h, 30h, 30h, 30h, 30h, 30h, 30h, 18h, 0ch, 06h, 0
  endif

right_paren:    ; Right parentheses: )
  if VERY_TALL
 db 60h, 30h, 18h, 0ch, 0ch, 0ch, 0ch, 0ch, 0ch, 0ch, 0ch, 18h, 30h, 60h
  else
 db 0, 60h, 30h, 18h, 0ch, 0ch, 0ch, 0ch, 0ch, 0ch, 18h, 30h, 60h, 0
  endif

left_brace:     ; Left curly brace: {
  if VERY_TALL
 db 0eh, 18h, 18h, 18h, 18h, 18h, 70h, 18h, 18h, 18h, 18h, 18h, 18h, 0eh
  else
 db 0, 0eh, 18h, 18h, 18h, 18h, 70h, 18h, 18h, 18h, 18h, 18h, 0eh, 0
  endif

right_brace:    ; Right curly brace: }
  if VERY_TALL
 db 70h, 18h, 18h, 18h, 18h, 18h, 0eh, 18h, 18h, 18h, 18h, 18h, 18h, 70h
  else
 db 0, 70h, 18h, 18h, 18h, 18h, 0eh, 18h, 18h, 18h, 18h, 18h, 70h, 0
  endif

CSEG ENDS
END newchars
