;
; *** Listing 6 ***
;
; Solution to MASM 5.0 problem with local labels in REPT blocks.
; Adrian Crum's solution.
;
; Note: this code is relatively simple, it should be easy to follow.
; Make sure that the counter, (?CNT1) is initialized only one in
; your program. Otherwise, you will receive multi-defined errors.
;
DOSSEG
.MODEL SMALL
.CODE
;
;
SYM_SUPP1	MACRO	X
	;; support macro #1 for SYMBOLS macro
	;;
	jmp	?TMPLBL&X&
	;;
	;; Note: if you're sure that these will always be short jumps,
	;; then JMP SHORT ?TMPLBL&X&
	;;
ENDM
SYM_SUPP2	MACRO	X
	;; Support macro #2 for SYMBOLS macro
	;;
	?TMPLBL&X&:
	;;
ENDM
;
SYMBOLS	MACRO
	;; This is the main macro. No calling parameters. This macro
	;; calls two other macros to generate 10 JMP instructions to
	;; 10 temporary labels and the temporary labels themselves.
	;;
	REPT	10
		SYM_SUPP1	%?CNT1	;; Generate JMP instruction
		SYM_SUPP2	%?CNT1	;; Generate label
		?CNT1 = ?CNT1 + 1	;; Increment counter
	ENDM
	;;
	;; Note: you could also define the number of repeats executed
	;; by this macro by including a dummy parameter X at the
	;; beginning of the macro and changing REPT 10 to REPT &X. The
	;; correct call in that case would be SYMBOLS n, where n is
	;; the number of repetitions.
	;;
ENDM
;
START:
	?CNT1 = 0			; INITIALIZE COUNTER
	SYMBOLS				; GENERATE 10 TEMP LABELS
	SYMBOLS				; GENERATE 10 MORE LABELS
	REPT 3				; GENERATE 3 MORE LABELS
		SYM_SUPP1	%?CNT1
		SYM_SUPP2	%?CNT1
		?CNT1 = ?CNT1 + 1
	ENDM
;
END	START


