#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <conio.h>
#include <time.h>
#include <sys\timeb.h>
#include "svga.h"

#include "version.c"

// This was compiled in Borland C, it should work with other C compilers
// but may need some altering.

int     x,y;
void fastline(int x1, int y1, int x2, unsigned char color);


/****************************************************************************
*
* Function:     pageFlipTest
*
* Description:  Animates a line on the display using page flipping if
*               page flipping is active.
*
****************************************************************************/
void pageFlipTest(int speed)
{
int color, apage, vpage, t, x2, count = 0;
int npage[2],x[2][2];
int x1[]={160,97,257,102,125,159,179,188,207,221}; // X & Y top left
int y1[]={143,96,204,222,203,179,161,150,134,118}; // co-ordinates of square
struct timeb tim;
short diff, diff2;

maxpage = 1; // This program only uses the first two pages for the sake of
			 // simplicity, however depending on how much ram the graphics
			 // card has, more then two pages can be used.

if (maxpage != 0)
	{
	vpage = 0; // set beginning pages & clear them
	apage = 1;
	setActivePage(0);
	clear();
	setActivePage(apage);
	setVisualPage(vpage);
	clear();
	color = 15;
	npage[0] = 0;
	x2 = 462;
	x[0][vpage] = 0; // set to zero to aviod useless erasing
	x[1][vpage] = 0;
	x[0][apage] = 0;
	x[1][apage] = 0;

	while (!kbhit())
		{
		ftime(&tim);		 // get time to calculate processor independent
		diff2 = tim.millitm; // speed rate (I hope)
		setActivePage(apage);   // set screen writing to hidden page

		for(t = npage[apage]; t < npage[apage]+196; t++)
			fastline(x[0][apage], t, x[1][apage], 0);	// erase old square
		for(t = y1[count]; t < y1[count]+196; t++)
			fastline(x1[count], t, x2, color);	// draw new square

		npage[apage] = y1[count];   // store old square co-ordinates
		x[0][apage] = x1[count];	// for erasing
		x[1][apage] = x2;

		count++;			// count number of different screens (10)
		if(count == 10)
			count = 0;

		x2 = x1[count] + 302;	// make square width 302 pixels wide

		if(vpage == 0)	// set page to flip to
			{
			vpage = 1;
			apage = 0;
			}
		else
			{
			vpage = 0;
			apage = 1;
			}
		setVisualPage(vpage);

		ftime(&tim);						  // calculate processor
		diff = speed - (tim.millitm - diff2); // independent speed rate, not
		if(diff < speed && diff > 0)		  // the best way I guess but
			delay(diff);					  // it'll have to do for now


		}
	getch();                /* Swallow keypress */
	}
}

/****************************************************************************
*
* Function:     testingComplete
*
* Description:  Clears the first display page and puts up a message.
*
****************************************************************************/
void testingComplete(void)
{
    setActivePage(0);
    setVisualPage(0);
	clear();
}

int queryCpu(void);

void showargs(void)
{
printf("\nUsage: SVGAPAGE [mode] [speed]\n");
printf(" i.e.: SVGAPAGE 101\n");
printf("Graphics mode is mandatory, speed is optional\n");
printf("Try Vesa graphics modes: 101 - 640x480x256\n");
printf("                         103 - 800x600x256\n");
printf("                         105 - 1024x768x256\n");
printf("                         107 - 1280x1024x256\n");
printf("        Optional speeds: 0 to 120\n");
exit(0);
}

void main(int argc, char *argv[])
{
int mode, speed = 12, version;

if(argc == 1)
	showargs();

sscanf(argv[1], "%x", &mode); // get graphic from commandline

if(mode != 0x101 && mode != 0x103 && mode != 0x105 && mode != 0x107)
	showargs(); // check to see if they're acceptable modes

if(argc == 3)
	sscanf(argv[2], "%d", &speed); //get optional speed rate from commandline

if(speed > 120 || speed < 0)
	showargs(); // check to see if they're acceptable speeds

if(queryCpu() < 4)
	{
	printf("This program contains '386 specific instructions, and will not work on\n");
	printf("this machine - sorry\n");
	exit(1);
	}

version = initSuperVGA(); // get VESA version
if (version != 0x102 && version != 0x200)
	{
	printf("This program requires a 1.2 or 2.0 VESA driver. Try installing\n");
	printf("the Universal VESA VBE for your video card, or contact your\n");
	printf("video card vendor and ask for a suitable TSR\n");
	exit(1);
	}

if(extendedflipping == 1) // check for SVGA page support
	{
	clrscr();
	if (!setSuperVGAMode(mode))
		{
		printf("\nERROR: Video mode did not set correctly!\n\n");
		printf("\nPress any key to continue...\n");
		getch();
		}
	if(maxpage > 0) // check to see if there's more then one page
		{
		speed *= 13; // adjust speed rate
		pageFlipTest(speed);
		testingComplete();
		restoreMode();
		}
	else
		{
		restoreMode();
		printf("\nERROR: SVGA page support was not found in this mode\n");
		showargs();
		}
	}
else
	{
	printf("\nERROR: SVGA page support was not found in this mode\n");
	showargs();
	}
}

extern void setline256(int x, int y, int widthl, unsigned char color);

void fastline(int x1, int y1, int x2, unsigned char color)
{
int width;

width = (x2 - x1);
setline256(x1, y1, width, color); // call straight across line drawer

}
