;
; *** Listing 7-4 ***
;
; Adds one far array to another far array as a high-level
; language would, loading each far pointer with LES every
; time it's needed.
;
	jmp	Skip
;
ARRAY_LENGTH	equ	1000
Array1	db	ARRAY_LENGTH dup (1)
Array2	db	ARRAY_LENGTH dup (2)
;
; Adds one byte-sized array to another byte-sized array.
; C-callable.
;
; Input: parameters on stack as in AddArraysParms
;
; Output: none
;
; Registers altered: AL, BX, CX, ES
;
AddArraysParms	struc
	dw	?	;pushed BP
	dw	?	;return address
FarPtr1	dd	?	;pointer to array to be added to
FarPtr2	dd	?	;pointer to array to add to the
			; other array
AddArraysLength	dw ?	;# of bytes to add
AddArraysParms	ends
;
AddArrays	proc	near
	push	bp		;save caller's BP
	mov	bp,sp		;point to stack frame
	mov	cx,[bp+AddArraysLength]
				;get the length to add
AddArraysLoop:
	les	bx,[bp+FarPtr2]	;point to the array to add
				; from
	inc	word ptr [bp+FarPtr2]
				;point to the next byte
				; of the array to add from
	mov	al,es:[bx]	;get the array element to
				; add
	les	bx,[bp+FarPtr1]	;point to the array to add
				; to
	inc	word ptr [bp+FarPtr1]
				;point to the next byte
				; of the array to add to
	add	es:[bx],al	;add to the array
	loop	AddArraysLoop
	pop	bp		;restore caller's BP
	ret
AddArrays	endp
;
Skip:
	call	ZTimerOn
	mov	ax,ARRAY_LENGTH
	push	ax	;pass the length to add
	push	ds	;pass segment of Array2
	mov	ax,offset Array2
	push	ax	;pass offset of Array2
	push	ds	;pass segment of Array1
	mov	ax,offset Array1
	push	ax	;pass offset of Array1
	call	AddArrays
	add	sp,10	;clear the parameters
	call	ZTimerOff
