' Hieno Cd-soitin ohjelma,
' ei BootSectorin mutta saa kytt omiin tarkoituksiin,


DEFINT A-Z
DECLARE SUB SCDAudioStatus (paused%, start&, ending&)
DECLARE SUB SCDQInfo (track%, RTTrack&, RTDisk&)
DECLARE SUB SCDTrackInfo (track%, start&, ctrl%)
DECLARE SUB SCDDiskInfo (Low%, High%, Leadout&)
DECLARE FUNCTION SCDMediaChanged% ()
DECLARE FUNCTION SCDDeviceStatus% ()
DECLARE SUB SCDGetChannel (Ch0%, Vol0%, Ch1%, Vol1%, Ch2%, Vol2%, Ch3%, Vol3%)
DECLARE SUB RTQInfo (track%, RTTrack&, RTDisk&, lowest%, highest%, r1%, c1%, c2%)
DECLARE SUB HSGtoRBA (HSGSector&, RBAMin%, RBASec%, RBAFrm%)
DECLARE FUNCTION RBAtoHSG& (RBAMin%, RBASec%, RBAFrm%)
DECLARE FUNCTION SCDLocateHead& ()
DECLARE SUB Prepcb (code%)
DECLARE SUB Preprh (command%)
DECLARE SUB Call10 ()
DECLARE SUB CDError ()
DECLARE SUB InitDrives ()
DECLARE SUB GetDrives (numdrives%, first%)
DECLARE FUNCTION CheckMSCDEX% (major$, minor$)
DECLARE SUB Byte (Expression&, b1$, b2$, b3$, b4$)
DECLARE FUNCTION BitCheck% (Bit%, DecNum%)
DECLARE FUNCTION lbyte% (word%)
DECLARE FUNCTION hbyte% (word%)
DECLARE SUB GetTrack (lowest%, highest%, max&) 'gets track info and puts it in trackinfo()
DECLARE SUB DisplayTime (mm%, ss%, ff%)
DECLARE SUB SCDPlay (BeginSec&, LengthSec&)
DECLARE SUB SCDPause ()
DECLARE SUB DisplayTrackInfo (lowest%, highest%)
DECLARE SUB DisplayTrackPercent (RTTrack&, track%, lowest%, highest%)
DECLARE SUB KeyHandler (kbd$, lowest%, highest%, track%, max&, RTTrack&, RTDisk&, instruction$)
DECLARE SUB SCDClose ()
DECLARE SUB SCDEject ()
DECLARE SUB SCDReset ()
DECLARE SUB SCDResume ()
DECLARE SUB ShowTime (row%, col%)
'Sound Blaster routines
DECLARE SUB SBMasterVolume (Right%, Left%, Getvol%)
DECLARE SUB SBMain (vol%)
DECLARE SUB SBCDVolume (Right%, Left%, Getvol%)
DECLARE SUB SBVolTwist ()
DECLARE SUB GetBLASTER (DMA%, Baseport%, IRQ%)
DECLARE FUNCTION SBaddr% ()
DECLARE SUB SBWriteDSP (Byte2%)
DECLARE FUNCTION SBDSPVersion! ()
DECLARE FUNCTION SBReadDSP% ()
DECLARE FUNCTION SBResetDSP% ()

'$INCLUDE: 'I:\BASIC\QB4.5\qb.bi'
DIM SHARED inregsx AS RegTypeX
DIM SHARED outregsx AS RegTypeX
TYPE tracktype
	start AS LONG
	length AS LONG
	ctrlinfo AS INTEGER
END TYPE

TYPE disktype
	Low     AS INTEGER
	High    AS INTEGER
	Leadout AS LONG
END TYPE

'$DYNAMIC
'----------------------------------------------------------------
COMMON SHARED Baseport%             'for Sound Blaster card
COMMON SHARED SBMyVol%              'volume setting
COMMON SHARED CDDEBUG%
'env/status vars
COMMON SHARED CDDoorOpen%           'is cd tray/door open? Door in CDLIB
COMMON SHARED playing AS INTEGER    'is CD playing?
COMMON SHARED paused AS INTEGER
COMMON SHARED Stopped AS INTEGER
COMMON SHARED Drive AS INTEGER      'default drive

COMMON SHARED drv%                  'current drive
COMMON SHARED rhlength%             'length of request header
COMMON SHARED cblength%             'length of control block
COMMON SHARED max&                  'length of control block
COMMON SHARED numdrives AS INTEGER
COMMON SHARED first AS INTEGER      'drive letter of first CD drive : int
DIM SHARED drivearray(x, y) AS INTEGER
DIM SHARED rh(z) AS STRING * 1      'request header - dynamic array
DIM SHARED cb(z) AS STRING * 1      'command block  - dynamic array
DIM SHARED trackinfo(z) AS tracktype
DIM SHARED diskinfo(z) AS disktype
DIM driver$(5)

'Define some default values
CONST frameto100 = 1.333
CONST true = 1, false = 0
CONST skiplength& = 750&
paused1% = false
CDDoorOpen% = false
CDDEBUG% = false:  'A crude form of error correction in subs
max& = 0:
trlen& = 1
Baseport% = &H210
SBMyVol% = 10
vbar$ = CHR$(179)
r1 = 5: c1 = 1: c2 = 45: 'position of track info
'-----------------------------------END Definitions Block ------



CLS


top:
CDDEBUG% = false:  'DO NOT remove
SCREEN 0
PRINT "QuickBASIC CD AUDIO PLAYER V" + ver$
instruction$ = " " + CHR$(25) + " LAST_TR  " + CHR$(17) + " REW  <=PAUSE/RESUME 5=>   "
instruction$ = instruction$ + CHR$(16) + " FF  " + CHR$(24) + " NEXT_TR "
instruction$ = instruction$ + vbar$ + "0 EJECT" + vbar$ + " Enter STOP"
ShowTime 4, c2
COLOR 7
' SBMain 6

IF CheckMSCDEX(major$, minor$) = false THEN SYSTEM
LOCATE 3, 1
PRINT "Using MSCDEX v" + major$ + "." + minor$
driver$(0) = "MSCDEX v" + major$ + "." + minor$

InitDrives
drv% = drivearray(Drive, 1): 'drive D means drv%=3
status% = SCDDeviceStatus
IF BitCheck(4, status%) = false THEN
	PRINT "Your default drive cannot play Audio CDs!"
	SYSTEM
END IF
driver$(1) = CHR$(drv% + 65)


SCDDiskInfo lowest%, highest%, max&

'door is open
status% = SCDDeviceStatus
CDDoorOpen% = BitCheck(0, status%)
IF CDDoorOpen% THEN
	COLOR 15, 12: LOCATE 20, 1: PRINT "CD Door is Open"
ELSE
	'COLOR 15, 12: LOCATE 20, 1: PRINT "Door is Closed"
END IF
'no cd in tray
IF highest% = 0 THEN
	LOCATE 22, 1
	COLOR 14, 4: PRINT "No CD!"
	COLOR 7, 0
	SCDEject
	CDDoorOpen% = true
	END
END IF
HSGtoRBA max&, mm, ss, ff
COLOR 15
driver$(2) = LTRIM$(STR$(mm)) + ":" + LTRIM$(STR$(ss))

LOCATE 2, 40: COLOR 14
GetTrack lowest%, highest%, max&

DisplayTrackInfo lowest%, highest%
currtrack = lowest%: track% = lowest%
start& = trackinfo(lowest%).start
'IF start& = -150 THEN
'    LOCATE 21, 1: COLOR 14, 4
'    CDDoorOpen% = True
'    PRINT "CD Door is open": END
'END IF
'avoid General Failure error
SCDQInfo track%, RTTrack&, RTDisk&
IF playing = false THEN
	SCDPlay start&, max&
END IF
LOCATE 25, 1: COLOR 15, 1: PRINT instruction$;


'Main get_CD_info and keyboard polling loop-----------------------------
DO
       
SCDQInfo track%, RTTrack&, RTDisk& 'update playing
IF playing = false AND paused = false THEN SCDEject
kbd$ = INKEY$
KeyHandler kbd$, lowest%, highest%, track%, max&, RTTrack&, RTDisk&, instruction$
IF CDDEBUG = true THEN SCDReset: GOTO top
IF (1 XOR paused%) THEN
CALL RTQInfo(track%, RTTrack&, RTDisk&, lowest%, highest%, r1, c1, c2)
END IF
IF CDDEBUG = true THEN SCDReset: GOTO top
SCDAudioStatus paused%, lstart&, lending&: ' update Paused%
ShowTime 4, c2
COLOR 15
LOOP

END

REM $STATIC
DEFSNG A-Z
FUNCTION BitCheck% (Bit%, DecNum%)
'This function checks if a certain bit in a number is set
'
'ARGS:  Bit%                - The number of the bit you want to check (0-15)
'       DecNum%             - The number you want to check
'RET:   Function Value      - True (1) = bit is set
'                             False (0) = bit not set

IF (DecNum% AND 2 ^ Bit%) THEN
		BitCheck% = true
	ELSE
		BitCheck% = false
	END IF
END FUNCTION

SUB Byte (Expression&, b1$, b2$, b3$, b4$)
'This subroutine seperates a 4-byte number into its components.
'
'ARGS:  Expression& - 4-byte number
'       b1$         - string to store first byte in
'       b2$         - string to store second byte in
'       b3$         - string to store third byte in
'       b4$         - string to store fourth byte in
'RET:   Expression& - unchanged
'       b1$ - b4$   - containing the bytes

ts& = Expression&
b1$ = CHR$(ts& \ 2 ^ 24)
ts& = ts& MOD 2 ^ 24
b2$ = CHR$(ts& \ 2 ^ 16)
ts& = ts& MOD 2 ^ 16
b3$ = CHR$(ts& \ 2 ^ 8)
b4$ = CHR$(ts& MOD 2 ^ 8)
END SUB

SUB Call10 STATIC
' Calls function &H10 and takes care of filling in the
' selected drive, and the pointer to our request header
'
' ARGS:     None, but assumes that drivearray(), Drive,
'           and rh() are defined and ready
' RETS:     Nothing

'PRINT "Request Header length"; rhlength%
'FOR a = 1 TO rhlength%
'      PRINT ASC(rh(a));
'NEXT
'PRINT
'PRINT "Control Block length"; cblength%
'FOR a = 1 TO cblength%
'      PRINT ASC(cb(a));
'NEXT
'PRINT "drivearray"; drivearray(Drive, 1)
inregsx.ax = &H1510
inregsx.cx = drivearray(Drive, 1)
inregsx.es = VARSEG(rh(1))
inregsx.bx = VARPTR(rh(1))

CALL INTERRUPTX(&H2F, inregsx, outregsx)

'Check Error bit of Status field
IF BitCheck(7, ASC(rh(5))) = true THEN
 IF ASC(rh(4)) = 2 THEN
	CDDoorOpen% = true
 ELSE
	CDError
 END IF
END IF
END SUB

SUB CDError
'Displays error messages and loops until ESC is pressed
'
' ARGS: none, but assumes that rh(4) contains the error
'       code
' RET:  nothing

COLOR 14, 4: LOCATE 21, 1
SELECT CASE ASC(rh(4))
	CASE 0
		PRINT "Write-protect violation"
	CASE 1
		PRINT "Unknown unit"
	CASE 2
		PRINT "Drive not ready - Insert CD"
	CASE 3
		PRINT "Unknown command"
	CASE 4
		PRINT "CRC error"
	CASE 5
		PRINT "Bad drive request header length"
	CASE 6
		PRINT "Seek error"
	CASE 7
		PRINT "Unknown media"
	CASE 8
		PRINT "Sector not found"
	CASE 9
		PRINT "Printer out of paper"
	CASE 10
		PRINT "Write fault"
	CASE 11
		PRINT "Read fault"
	CASE 12
		PRINT "General failure"
		'SERIOUS ERROR!
		'caused by CD playing already and invoking SCDplay
		END
	CASE 13
		PRINT "Reserved"
	CASE 14
		PRINT "Reserved"
	CASE 15
		PRINT "Invalid disk change"
END SELECT

'PRINT
'PRINT "Press ESC to continue!"

'DO: LOOP UNTIL INKEY$ = CHR$(27)
END
END SUB

DEFINT A-Z
SUB CDSystemInit
'Initializes our CD-ROM Library
'
'ARGS:  none
'RET:   Updates all environment variables

CLS
IF CheckMSCDEX(major$, minor$) THEN
	PRINT "Supported version of MSCDEX installed..."
ELSE
	PRINT "No supported version of MSCDEX installed!"
	PRINT "Please run this program again once MSCDEX is installed."
	SYSTEM
END IF

PRINT "Initializing CD-ROM drives..."
InitDrives

IF SCDMediaChanged >= 0 THEN
	PRINT "Resetting default drive!"
	SCDReset
END IF

PRINT "Checking status of default drive..."
status% = SCDDeviceStatus

IF BitCheck(4, status%) = false THEN
	PRINT "Your default drive cannot play Audio CDs!"
	SYSTEM
END IF

IF CDDoorOpen% THEN
	SCDReset
	paused = false
	Stopped = true
	playing = false
END IF

END SUB

DEFSNG A-Z
FUNCTION CheckMSCDEX% (major$, minor$)
'Check if MSCDEX is installed
'
'ARGS:  two strings which will hold the major and minor
'       version numbers
'RET:   major$          - major version number
'       minor$          - minor version number
'       function value  - True = MSCDEX installed
'                         False = MSCDEX not installed

inregsx.ax = &H150C
inregsx.bx = &H0
CALL INTERRUPTX(&H2F, inregsx, outregsx)

IF hbyte(outregsx.bx) = 0 THEN
		CheckMSCDEX = false
	ELSE
		CheckMSCDEX = true
		major$ = LTRIM$(STR$(hbyte(outregsx.bx)))
		minor$ = LTRIM$(STR$(lbyte(outregsx.bx)))
	END IF
END FUNCTION

DEFINT A-Z
SUB DisplayTime (mm, ss, ff)
mmfmt$ = "00:00.00"
IF mm < 10 THEN
	MID$(mmfmt$, 2, 1) = LTRIM$(STR$(mm))
ELSE
	MID$(mmfmt$, 1, 2) = LTRIM$(STR$(mm))
END IF
'begin debug code
'IF ss < 0 THEN LOCATE 18, 60: PRINT ss
'end debug code
IF ss = -2 THEN ss = 58
IF ss = -1 THEN ss = 59
IF ss < 10 THEN
	MID$(mmfmt$, 5, 1) = LTRIM$(STR$(ss))
ELSE
	MID$(mmfmt$, 4, 2) = LTRIM$(STR$(ss))
END IF
ff = ff * frameto100
IF ff < 10 THEN
	MID$(mmfmt$, 8, 1) = LTRIM$(STR$(ff))
ELSE
	MID$(mmfmt$, 7, 2) = LTRIM$(STR$(ff))
END IF
PRINT mmfmt$;

END SUB

SUB DisplayTrackInfo (lowest%, highest%)

'ctrlinfo byte breakdown
'  76543210 <- bit #
'  00x00000  - 2 audio channels without pre-emphasis
'  00x10000  - 2 audio channels with pre-emphasis
'  10x00000  - 4 audio channels without pre-emphasis
'  10x10000  - 4 audio channels with pre-emphasis
'  01x00000  - data track
'  01x10000  - Reserved
'  11xx0000  - Reserved
'  xx0x0000  - digital copy prohibited
'  xx1x0000  - digital copy permitted

LOCATE 8, 1
COLOR 14
PRINT "track#", "Start Time", "Track Length", "Track Information"
LOCATE 9, 1
VIEW PRINT 9 TO 21
COLOR 7
FOR trk% = lowest% TO highest%
	PRINT "TRACK="; trk%,
	s& = trackinfo(trk%).start
	HSGtoRBA s&, mm%, ss%, ff%
	DisplayTime mm%, ss%, ff%: PRINT "",
	l& = trackinfo(trk%).length
	HSGtoRBA l&, mm%, ss%, ff%
	DisplayTime mm%, ss%, ff%: PRINT "",
	c% = trackinfo(trk%).ctrlinfo
	DigCopyOK = BitCheck(5, c%)
	IF DigCopyOK THEN
		PRINT "=:)";
	ELSE
		PRINT "(c)";
	END IF
	FourChnl = BitCheck(7, c%) AND 1 XOR BitCheck(6, c%)
	IF FourChnl THEN
		PRINT "4Chnl";
		IF BitCheck(4, c%) THEN
			PRINT "Emph";
		ELSE
			PRINT "Norm";
		END IF
	END IF
	TwoChnl = (1 XOR BitCheck(7, c%)) AND (1 XOR BitCheck(6, c%))
	IF TwoChnl THEN
		PRINT "2Chnl";
		IF BitCheck(4, c%) THEN
			PRINT "Emph";
		ELSE
			PRINT "Norm";
		END IF
	END IF
	AudioTrack = 1 XOR BitCheck(6, c%)
	IF AudioTrack THEN
		PRINT "Audio";
	ELSE
		PRINT "Data ";
	END IF
	PRINT
NEXT trk%
VIEW PRINT
END SUB

SUB DisplayTrackPercent (RTTrack&, track%, lowest%, highest%)
	'graphically show track %
	IF track% >= lowest% AND track% <= highest% THEN
		trlen& = trackinfo(track%).length
		trackpercent = INT(RTTrack& / trlen& * 100)
		LOCATE 22, 1: PRINT "Track" + STR$(track%) + ":" + STR$(trackpercent) + "% "
		LOCATE 23, 1:
		PRINT STRING$(trackpercent \ 2, 219) + STRING$(50 - trackpercent \ 2, 176)
	END IF

END SUB

SUB GetBLASTER (DMA%, Baseport%, IRQ%)
' This subroutine parses the BLASTER environment string and returns settings.
IF LEN(ENVIRON$("BLASTER")) = 0 THEN
	COLOR 14, 4: LOCATE 21, 1
	Baseport% = false: 'signal error
	PRINT "BLASTER environment variable not set."
	EXIT SUB
END IF
FOR length% = 1 TO LEN(ENVIRON$("BLASTER"))
   SELECT CASE MID$(ENVIRON$("BLASTER"), length%, 1)
	  CASE "A"
		Baseport% = VAL("&H" + MID$(ENVIRON$("BLASTER"), length% + 1, 3))
	  CASE "I"
		IRQ% = VAL(MID$(ENVIRON$("BLASTER"), length% + 1, 1))
	  CASE "D"
		DMA% = VAL(MID$(ENVIRON$("BLASTER"), length% + 1, 1))
   END SELECT
NEXT
END SUB

DEFSNG A-Z
SUB GetDrives (numdrives%, first%)
' Gets the number of drives installed on a system and
' the drive letter number of the first drive
'
' ARGS: two integers which will hold the returned
'       values
' RET:  numdrives%      - total number of CD-ROMs
'       first%          - drive letter number of first
'                         drive on system

inregsx.ax = &H1500
inregsx.bx = &H0
inregsx.cx = &H0

CALL INTERRUPTX(&H2F, inregsx, outregsx)

numdrives% = outregsx.bx
first% = outregsx.cx
END SUB

DEFINT A-Z
SUB GetTrack (lowest%, highest%, max&) STATIC
REDIM trackinfo(lowest% TO highest%) AS tracktype
'LOCATE 9, 1: COLOR 15, 3
' GETTRACK
' pre: lowest and highest track numbers
' ret: trackinfo array with start,length, and ctrlinfo in HSG format

FOR trk% = lowest% TO highest%
	'PRINT "TRACK="; trk%,
	SCDTrackInfo trk%, start&, ctrl%
	trackinfo(trk%).ctrlinfo = ctrl%

	trackinfo(trk%).start = start&
	'PRINT "track start="; trackinfo(trk%).start,
	IF trk% <> lowest% THEN
		trackinfo(trk% - 1).length = trackinfo(trk%).start - trackinfo(trk% - 1).start
	END IF

	'PRINT "track control info"; trackinfo(trk%).ctrlinfo
	AudioTrack = 1 XOR BitCheck(6, trackinfo(trk%).ctrlinfo)
	IF NOT AudioTrack AND highest% = lowest% THEN
		LOCATE 21, 1: COLOR 14, 4
		PRINT "CD-ROM found... Exiting.": END
	END IF

NEXT trk%
trackinfo(highest%).length = max& - trackinfo(highest%).start
END SUB

DEFSNG A-Z
FUNCTION hbyte% (word%)
'Returns the high byte of a 2-byte number (INNTEGER)
'
'ARGS:  word%               - 2-byte number (INTEGER)
'RET:   Function Value      - High byte or word%

IF word% >= 0 THEN
		hbyte% = word% \ 256
	ELSE
		hbyte% = (65536 + word%) \ 256
	END IF
END FUNCTION

SUB HSGtoRBA (HSGSector&, RBAMin%, RBASec%, RBAFrm%)
ts& = HSGSector&
RBAMin% = ts& \ 4500
ts& = ts& MOD 4500
RBASec% = ts& \ 75
ts& = ts& MOD 75
RBAFrm% = ts&
END SUB

SUB InitDrives
' Modifies the array passed to it and stores the Drive
' Management Structure in it
'
' ARGS: An integer array which will hold the returned
'       values
' RET:  drivearray()    - Drive Management Structure
'    ** Drive           - Sets default drive to 1 (Drive is init. HERE!)

GetDrives numdrives%, first%

DIM temp1(1 TO numdrives% * 5) AS STRING * 1
DIM temp2(1 TO numdrives%) AS STRING * 1
REDIM drivearray(1 TO numdrives%, 1 TO 2) AS INTEGER

inregsx.ax = &H1501
inregsx.es = VARSEG(temp1(1))
inregsx.bx = VARPTR(temp1(1))
CALL INTERRUPTX(&H2F, inregsx, outregsx)

inregsx.ax = &H150D
inregsx.es = VARSEG(temp2(1))
inregsx.bx = VARPTR(temp2(1))
CALL INTERRUPTX(&H2F, inregsx, outregsx)

FOR x = 1 TO numdrives%
	drivearray(x, 1) = ASC(temp2(x))
	drivearray(x, 2) = ASC(temp1(1 + (x - 1) * 5))
NEXT x
Drive = 1
END SUB

DEFINT A-Z
SUB KeyHandler (kbd$, lowest%, highest%, track%, max&, RTTrack&, RTDisk&, instruction$)
'respond to keyboard events
currtrack = track%
IF kbd$ = "*" OR kbd$ = CHR$(0) + CHR$(72) THEN
	LOCATE 25, 47: COLOR 14, 3: PRINT "* NEXT_TR"; : COLOR 7, 0
	currtrack = currtrack + 1
	IF currtrack > highest% THEN currtrack = lowest%
	start& = trackinfo(currtrack).start
	SCDPause
	SCDPlay start&, max& - start&
	LOCATE 25, 1: COLOR 15, 1: PRINT instruction$;
ELSEIF kbd$ = CHR$(0) + CHR$(&H47) THEN 'home - go to beginning of track
	start& = trackinfo(currtrack).start
	SCDPause
	SCDPlay start&, max& - start&
ELSEIF kbd$ = CHR$(0) + CHR$(&H4F) THEN 'last track
	start& = trackinfo(currtrack).start + trackinfo(currtrack).length * 9 \ 10
	SCDPause
	SCDPlay start&, max& - start&
ELSEIF kbd$ = "/" OR kbd$ = CHR$(0) + CHR$(80) THEN
	LOCATE 25, 2: COLOR 14, 3: PRINT "/ LAST_TR"; : COLOR 7, 0
	currtrack = currtrack - 1
	IF currtrack < lowest% THEN currtrack = highest%
	start& = trackinfo(currtrack).start
	'LOCATE 20, 40: PRINT currtrack, start&
	SCDPause
	SCDPlay start&, max& - start&
	LOCATE 25, 1: COLOR 15, 1: PRINT instruction$;
ELSEIF kbd$ = "+" OR kbd$ = "6" OR kbd$ = CHR$(0) + CHR$(77) THEN
	'fast forward 10 secs
	COLOR 14, 3: LOCATE 25, 41: PRINT "+ FF"; : COLOR 7, 0
	start& = RTDisk& + skiplength&
	IF start& >= max& THEN start& = trackinfo(lowest%).start
	SCDPause
	SCDPlay start&, max& - start&
	LOCATE 25, 1: COLOR 15, 1: PRINT instruction$;
ELSEIF kbd$ = "-" OR kbd$ = "4" OR kbd$ = CHR$(0) + CHR$(75) THEN
	COLOR 14, 3: LOCATE 25, 13: PRINT "- REW"; : COLOR 7, 0
	start& = RTDisk& - skiplength&
	IF start& <= trackinfo(lowest%).start THEN start& = trackinfo(highest%).start
	SCDPause
	SCDPlay start&, max& - start&
	LOCATE 25, 1: COLOR 15, 1: PRINT instruction$;
ELSEIF kbd$ = CHR$(0) + CHR$(&H49) THEN 'up arrow - Volume Up
	SBMyVol% = SBMyVol% + 1
	IF SBMyVol% > 15 THEN SBMyVol% = 15
	SBMain SBMyVol%
ELSEIF kbd$ = CHR$(0) + CHR$(&H51) THEN 'dn arrow - Volume Down
	SBMyVol% = (SBMyVol% - 1)
	IF SBMyVol% = -1 THEN SBMyVol% = 0
	SBMain SBMyVol%
ELSEIF kbd$ = CHR$(0) + CHR$(&H53) THEN 'DEL - Stop & Eject
	SCDPause
	SCDEject
	LOCATE 25, 1: PRINT "Thanks for using Toshi's CD Player!";
	END
ELSEIF kbd$ = "0" THEN                          'CLOSE/EJECT
	IF NOT CDDoorOpen% THEN 'door closed so open/
		SCDEject
		CDDoorOpen% = true
		LOCATE 23, 1
		PRINT "Waiting 5 seconds for new CD..."
		SLEEP 5
		SCDClose
		DO: status% = SCDDeviceStatus
		CDDoorClose% = 1 XOR BitCheck(0, status%)
		LOOP UNTIL CDDoorClose%
		CDDoorOpen% = false
		tp1% = SCDMediaChanged%
		IF tp1% < 1 THEN
			SCDReset
			CDDEBUG% = true
		ELSE
			LOCATE 22, 14: PRINT "Same CD"
			CDDEBUG% = false
			DO
			SCDQInfo track%, RTTrack&, RTDisk&
			LOOP WHILE RTDisk& < 0
			start& = trackinfo(currtrack).start
			SCDPlay start&, max& - start&
			SLEEP 5
		END IF
	ELSE
		LOCATE 22, 1: PRINT "Software Close is inactive"
	END IF
ELSEIF kbd$ = "5" THEN                          'PAUSED
	IF paused% THEN
		LOCATE 25, 28: COLOR 14, 3: PRINT "RESUME"; : COLOR 7, 0
		SCDResume
		LOCATE 25, 1: COLOR 15, 1: PRINT instruction$;
	ELSE
		LOCATE 25, 22: COLOR 14, 3: PRINT "PAUSE"; : COLOR 7, 0
		SCDPause
	END IF
ELSEIF kbd$ = "." THEN
	SCDReset
	LOCATE 25, 1: COLOR 15, 1: PRINT instruction$;
	END
ELSEIF kbd$ = CHR$(0) + CHR$(&H52) THEN
	SBVolTwist
ELSEIF kbd$ = CHR$(13) THEN
	SCDPause
	SCDReset
	LOCATE 23, 1: PRINT "CD Stopped. Exiting program."
	END
ELSEIF kbd$ = " " THEN
	SOUND 50, 1
ELSEIF kbd$ > "" THEN
	LOCATE 25, 1
	PRINT "Now you may carry on with your work.";
	END
END IF
END SUB

DEFSNG A-Z
FUNCTION lbyte% (word%)
'Returns the low byte of a 2-byte number (INNTEGER)
'
'ARGS:  word%               - 2-byte number (INTEGER)
'RET:   Function Value      - Low byte or word%

IF word% >= 0 THEN
		lbyte% = word% MOD 256
	ELSE
		lbyte% = (65536 + word%) MOD 256
	END IF
END FUNCTION

SUB Prepcb (code%) STATIC
' Prepares the control block for a given subfunction
' Checks whether cb() is used for IOCTL INPUT or OUTPUT
'
' ARGS: code%           - control block code
' RET:  - correctly dimensioned control block cb()
'       - correctly filled in fields for entire request
'         header
IF ASC(rh(3)) = 3 THEN
	SELECT CASE code%
		CASE 1
			length% = 6
		CASE 4
			length% = 9
		CASE 6
			length% = 5
		CASE 9
			length% = 2
		CASE 10, 11
			length% = 7
		CASE 12, 15
			length% = 11
	END SELECT
ELSE
	SELECT CASE code%
		CASE 0, 2, 5
			length% = 1
		CASE 1
			length% = 2
		CASE 3
			length% = 9
	END SELECT
	END IF

REDIM cb(1 TO length%) AS STRING * 1

cb(1) = CHR$(code%)

'Update address of cb() in rh()
rh(15) = CHR$(lbyte(VARPTR(cb(1))))
rh(16) = CHR$(hbyte(VARPTR(cb(1))))
rh(17) = CHR$(lbyte(VARSEG(cb(1))))
rh(18) = CHR$(hbyte(VARSEG(cb(1))))
'Number of bytes to transfer
rh(19) = CHR$(lbyte(length%))
rh(20) = CHR$(hbyte(length%))

END SUB

SUB Preprh (command%) STATIC
' Prepares the request header for a given command code
'
' ARGS: command%        - command code
' RET:  - correctly dimensioned request header rh()
'       - correctly filled in fields for basic request
'         header

SELECT CASE command%
	CASE 3, 12            'IOCTL Input , IOCTL Output
		rhlength% = 26
	CASE 132              'Play
		rhlength% = 22
	CASE 133, 136         'Pause, Resume
		rhlength% = 13
END SELECT

REDIM rh(1 TO rhlength%) AS STRING * 1
rh(1) = CHR$(rhlength%)
rh(2) = CHR$(drivearray(Drive, 2))
rh(3) = CHR$(command%)
END SUB

FUNCTION RBAtoHSG& (RBAMin%, RBASec%, RBAFrm%)
RBAtoHSG& = RBAMin% * 4500& + RBASec% * 75 + RBAFrm%
END FUNCTION

DEFINT A-Z
SUB RTQInfo (track%, RTTrack&, RTDisk&, lowest%, highest%, r1, c1, c2)
	LOCATE r1, c2
	ct$ = LTRIM$(RTRIM$(STR$(track%)))
	IF LEN(ct$) = 1 THEN ct$ = "  " + ct$
	IF LEN(ct$) = 2 THEN ct$ = " " + ct$
	PRINT "Current Track:  " + ct$
	CALL DisplayTrackPercent(RTTrack&, track%, lowest%, highest%)
  
	HSGtoRBA RTTrack&, RBAMin%, RBASec%, RBAFrm%
	LOCATE r1 + 1, c2
	PRINT "Track Time "; : DisplayTime RBAMin%, RBASec%, RBAFrm%
	HSGtoRBA RTDisk&, RBAMin%, RBASec%, RBAFrm%
	'IF RBAFrm% < 0 AND highest% = lowest% THEN
	'    LOCATE 21, 1: COLOR 14, 4
	'    PRINT "CD-ROM found... exiting": END
	'END IF
	LOCATE r1 + 2, c2
	PRINT "Disk Time  "; : DisplayTime RBAMin%, RBASec%, RBAFrm%

END SUB

FUNCTION SBaddr
'function returns TRUE if a soundblaster was initialized
'otherwise FALSE  The BasePort% variable is set to the
'base address of the SB.
PRINT "entering sbaddr"
PORT = &H220
a = 0

SBaddr = false
FOR PORT = &H210 TO &H280 STEP &H10
		Baseport% = PORT
		Ok = SBResetDSP
		IF Ok THEN
				SBaddr = true
				EXIT FUNCTION
		END IF
NEXT PORT
PRINT "exiting sbaddr"
END FUNCTION

SUB SBCDVolume (Right%, Left%, Getvol%)
OUT Baseport% + 4, &H28
IF Getvol% THEN
   Left% = INP(Baseport% + 5) \ 16
   Right% = INP(Baseport% + 5) AND &HF
   EXIT SUB
ELSE
   OUT Baseport% + 5, (Right% + Left% * 16) AND &HFF
END IF
END SUB

FUNCTION SBDSPVersion!
' Gets the DSP version.
SBWriteDSP &HE1
temp% = SBReadDSP%
temp2% = SBReadDSP%
'SELECT CASE temp%
'CASE 1
'        PRINT "Sound Blaster 1.0"
'CASE 2
'        PRINT "Sound Blaster 2.0"
'CASE 3
'        PRINT "Sound Blaster Pro/16"
'CASE 4
'        PRINT "Sound Blaster Awe 32"
'CASE IS >= 5
'        PRINT "SB 64 Turbo?"
'END SELECT
SBDSPVersion! = VAL(STR$(temp%) + "." + STR$(temp2%))

END FUNCTION

SUB SBMain (vol%)
'PRINT STRING$(80, 196)
'PRINT "Initializing SoundBlaster card..."
GetBLASTER Channel%, Baseport%, IRQ%: ' Parses BLASTER environment
'try to find out by reseting each possible base port
IF Baseport% = false THEN
	foundaddr = SBaddr
	IF foundaddr = false THEN END
END IF
'PRINT "Sound Blaster settings: Address=" + HEX$(Baseport%) + "h IRQ=" + STR$(IRQ%) + " DMA Channel=" + STR$(Channel%)
'PRINT STRING$(80, 196)
IF SBResetDSP% THEN 'resets DSP (returns true if sucessful)
   'PRINT "DSP reset sucessfully!"
ELSE
   SOUND 2000, 1
   LOCATE 21, 1: COLOR 14, 4
   PRINT "DSP failed to reset at " + HEX$(Baseport%) + "h"
   COLOR 7, 0
   END
END IF
temp! = SBDSPVersion!
'PRINT "Sound Card DSP version:"; temp!
'15, 15, 0 cranks the master volume all the way up.
IF vol% > 15 THEN vol% = 15
IF vol% < 0 THEN vol% = 0
SBMasterVolume vol%, vol%, 0
IF SBDSPVersion >= 3 THEN SBCDVolume 8, 8, 0
END SUB

SUB SBMasterVolume (Right%, Left%, Getvol%)
OUT Baseport% + 4, &H22
IF Getvol% THEN
   Left% = INP(Baseport% + 5) \ 16
   Right% = INP(Baseport% + 5) AND &HF
   EXIT SUB
ELSE
   OUT Baseport% + 5, (Right% + Left% * 16) AND &HFF
END IF
END SUB

FUNCTION SBReadDSP%
' Reads a byte from the DSP
' this MUST be a tight loop!
DO
iii = INP(Baseport% + 10)
IF iii <> &HAA THEN EXIT DO
LOOP
SBReadDSP% = iii
END FUNCTION

FUNCTION SBResetDSP%
' Resets the SB DSP
' returns TRUE or FALSE

ct = 0: stat = 0: 'byte
OUT Baseport% + &H6, 1
DO
		OUT Baseport% + &H6, 0
		stat = INP(Baseport% + &HE)
		stat = INP(Baseport% + &HA)
		IF stat = &HAA THEN EXIT DO
		ct = ct + 1
LOOP WHILE ct < 100 'wait about 100 ms
IF stat = &HAA THEN
	SBResetDSP = true
ELSE
	 SBResetDSP% = false
END IF
END FUNCTION

SUB SBVolTwist
IF SBDSPVersion < 3 THEN EXIT SUB
	FOR a = 0 TO 7
		SBCDVolume 8 + a, 8 - a, 0
		DEF SEG = &H40: starttime = PEEK(&H6C)
		DO: LOOP UNTIL PEEK(&H6C) <> starttime
	NEXT a
	FOR a = 7 TO -7 STEP -1
		SBCDVolume 8 + a, 8 - a, 0
		DEF SEG = &H40: starttime = PEEK(&H6C)
		DO: LOOP UNTIL PEEK(&H6C) <> starttime
	NEXT a
	FOR a = -7 TO 0
		SBCDVolume 8 + a, 8 - a, 0
		DEF SEG = &H40: starttime = PEEK(&H6C)
		DO: LOOP UNTIL PEEK(&H6C) <> starttime
	NEXT a
END SUB

SUB SBWriteDSP (Byte2%)
' Writes a byte to the DSP
DO
LOOP WHILE INP(Baseport% + 12) AND &H80
OUT Baseport% + 12, Byte2%
END SUB

DEFSNG A-Z
SUB SCDAudioStatus (paused%, start&, ending&)
'Returns the paused bit information, starting and
'ending location of last Play/next Resume command
'
'ARGS:  Variables to hold returned information
'RET:   paused%     - Paused bit
'       start&      - Start of last Play/next Resume
'       ending&     - End of last Play/next Resume
'       All addresses in HSG mode

Preprh 3
Prepcb 15
Call10

paused% = BitCheck(0, ASC(cb(2)))
start& = RBAtoHSG(ASC(cb(6)), ASC(cb(5)) - 2, ASC(cb(4)))
ending& = RBAtoHSG(ASC(cb(10)), ASC(cb(9)) - 2, ASC(cb(8)))
END SUB

DEFINT A-Z
SUB SCDClose
'closes tray of CD
Preprh 12
Prepcb 5
Call10
END SUB

DEFSNG A-Z
FUNCTION SCDDeviceStatus%
'Get the dword which contains the parameters
'describing the status of the CD-ROM drive
'
'ARGS:  None
'RET:   Function value  - device parameters

'Device status
'
'DevStat   DB   6         ; Control block code
'      DD   ?         ; Device parameters
'
'The device driver will return a 32-bit value. Bit 0 is the least significant
'bit. The bits are interpreted as follows:
'
'  Bit 0     0    Door closed
'            1    Door open
'
'  Bit 1     0    Door locked
'            1    Door unlocked
'
'  Bit 2     0    Supports only cooked reading
'            1    Supports cooked and raw reading
'
'  Bit 3     0    Read only
'            1    Read/write
'
'  Bit 4     0    Data read only
'            1    Data read and plays audio/video tracks
'
'  Bit 5     0    No interleaving
'            1    Supports interleaving
'
'  Bit 6     0    Reserved
'
'  Bit 7     0    No prefetching
'            1    Supports prefetching requests
'
'  Bit 8     0    No audio channel manipulation
'            1    Supports audio channel manipulation
'
'  Bit 9     0    Supports HSG addressing mode
'            1    Supports HSG and Red Book addressing modes
'
'  Bit 10-31 0    Reserved (all 0)


Preprh 3
Prepcb 6
Call10
SCDDeviceStatus% = ASC(cb(2)) + ASC(cb(3)) * 256
END FUNCTION

SUB SCDDiskInfo (Low%, High%, Leadout&)
'Get general disk information
'
'ARGS:  Variables to return values to
'RET:   low%        - Lowest track on CD
'       high%       - Highest track on CD
'       leadout&    - HSG address of the lead-out
'                     track (end of disk)

Preprh 3
Prepcb 10
Call10
Low% = ASC(cb(2))
High% = ASC(cb(3))
Leadout& = RBAtoHSG(ASC(cb(6)), ASC(cb(5)) - 2, ASC(cb(4)))
END SUB

DEFINT A-Z
SUB SCDEject
'ejects a CD
Preprh 12
Prepcb 0
Call10
END SUB

DEFSNG A-Z
SUB SCDGetChannel (Ch0%, Vol0%, Ch1%, Vol1%, Ch2%, Vol2%, Ch3%, Vol3%)
'Read the input/ouput channel assignments and the
'volume levels for each output channel
'
'ARGS:  None
'RET:   Ch0     - Input channel assigned to ouput 0
'       Vol0    - Volume for output channel 0
'       **Same things for channels 1, 2, and 3**

Preprh 3
Prepcb 4
Call10
Ch0% = ASC(cb(2))
Vol0% = ASC(cb(3))
Ch1% = ASC(cb(4))
Vol1% = ASC(cb(5))
Ch2% = ASC(cb(6))
Vol2% = ASC(cb(7))
Ch3% = ASC(cb(8))
Vol3% = ASC(cb(9))
END SUB

FUNCTION SCDLocateHead&
' Determine the location of the drive head
'
' ARGS: None
' RET:  Function value  - HSG address of the drive
'                         heads' location

Preprh 3
Prepcb 1
cb(2) = CHR$(0)
Call10
SCDLocateHead& = ASC(cb(3)) + ASC(cb(4)) * 256& + ASC(cb(5)) * 256& ^ 2 + ASC(cb(6)) * 256& ^ 3
END FUNCTION

FUNCTION SCDMediaChanged%
'Check whether the media in a drive was changed
'
'ARGS:  None
'RET:   Function value:  1 = Media not changed
'                        0 = Don't know if changed
'                       -1 = Media Changed

Preprh 3
Prepcb 9
Call10

IF ASC(cb(2)) = 255 THEN
		SCDMediaChanged = -1
	ELSE
		SCDMediaChanged = ASC(cb(2))
	END IF
END FUNCTION

SUB SCDPause
'Pause the audio on the CD
'ARGS:  none
'RET:   none

Preprh 133
Call10
END SUB

SUB SCDPlay (BeginSec&, LengthSec&)
'Play the audio on the CD starting at start& for
'length& sectors
'
'ARGS:  start&      - Location where playback begins
'       length&     - Number of sectors to play
'RET:   none
Preprh 132
rh(14) = CHR$(0)
Byte BeginSec&, b1$, b2$, b3$, b4$
rh(15) = b4$
rh(16) = b3$
rh(17) = b2$
rh(18) = b1$

Byte LengthSec&, b1$, b2$, b3$, b4$
rh(19) = b4$
rh(20) = b3$
rh(21) = b2$
rh(22) = b1$
Call10
END SUB

SUB SCDQInfo (track%, RTTrack&, RTDisk&)
'Returns information directly from the Q-Channel
'
'ARGS:  Variables to hold returned information
'RET:   track%      - Track where head is at
'       RTtrack&    - Running time within track (HSG)
'       RTdisk&     - Running time within disk (HSG)
'       playing     - updated as a side effect

Preprh 3
Prepcb 12
Call10

track% = VAL(HEX$(ASC(cb(3)))) 'BCD -> decimal
IF track% = 0 THEN
	LOCATE 21, 1: COLOR 15, 4
	CDDoorOpen% = true
	PRINT "CD Door is open"
	END
END IF
'update playing variable
playing = BitCheck(1, ASC(rh(5)))

RTTrack& = RBAtoHSG(ASC(cb(5)), ASC(cb(6)), ASC(cb(7)))
RTDisk& = RBAtoHSG(ASC(cb(9)), ASC(cb(10)) - 2, ASC(cb(11)))
END SUB

DEFINT A-Z
SUB SCDReset
'Resets the CD-ROM drive
'
'ARGS:  none
'RET:   none

Preprh 12
Prepcb 2
Call10
END SUB

SUB SCDResume
'Resume the audio on the CD
'ARGS:  none
'RET:   none

Preprh 136
Call10

END SUB

DEFSNG A-Z
SUB SCDTrackInfo (track%, start&, ctrl%)
'Get specific track information
'
'ARGS:  track%      - track number you want info about
'       variables to return values to
'RET:   start&      - HSG address where the track begins
'       ctrl%       - track control information

Preprh 3
Prepcb 11
cb(2) = CHR$(track%)
Call10
start& = RBAtoHSG(ASC(cb(5)), ASC(cb(4)) - 2, ASC(cb(3)))
ctrl% = ASC(cb(7))
END SUB

DEFINT A-Z
SUB ShowTime (row, col)
hr = VAL(MID$(TIME$, 1, 2))
IF hr < 12 THEN ap$ = "am" ELSE ap$ = "pm"
hr = hr MOD 12
IF hr = 0 THEN hr = 12
hour$ = STR$(hr)
min$ = MID$(TIME$, 4, 2)
currtime$ = "Time: " + hour$ + ":" + min$ + ap$

LOCATE row, col
END SUB

