/*
  ͻ
                                                                          
                        DNA - deoxyribonucleic acid                       
                                                                          
                         by Christopher D. Watkins                        
                                                                          
  ͼ
*/

#include "stdio.h"
#include "stdlib.h"
#include "dos.h"
#include "math.h"
#include "defs.h"

#define piover180 0.01745

float cosd(Word a)
{
  return cos(a * piover180);
}

float sind(Word a)
{
  return sin(a * piover180);
}

typedef char name[13];

FILE *Out_File;
name filename;

Word xresolution  = 160;
Word yresolution  = 100;
Byte numberofframes  = 30;

void writeheader()
{
  fprintf(Out_File,"ͻ\n");
  fprintf(Out_File,"                                                                        \n");
  fprintf(Out_File,"                      DNA - deoxyribonucleic acid                       \n");
  fprintf(Out_File,"                                                                        \n");
  fprintf(Out_File,"                       by Christopher D. Watkins                        \n");
  fprintf(Out_File,"                                                                        \n");
  fprintf(Out_File,"ͼ\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"STATS\n");
  fprintf(Out_File,"   XRES    = %d\n",xresolution);
  fprintf(Out_File,"   YRES    = %d\n",yresolution);
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"FRAMES\n");
  fprintf(Out_File,"   NUMBER  = %d\n",numberofframes);
}

void writestudio()
{
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"ENVIRONMENT\n");
  fprintf(Out_File,"   LOCLWGT =    0.750    0.750    0.750\n");
  fprintf(Out_File,"   REFLWGT =    0.250    0.250    0.250\n");
  fprintf(Out_File,"   TRANWGT =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   MINWGT  =    0.030    0.030    0.030\n");
  fprintf(Out_File,"   MAXWGT  =    1.000    1.000    1.000\n");
  fprintf(Out_File,"   RDEPTH  =    2\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"LAMPS\n");
  fprintf(Out_File,"   REFLAMP = FALSE\n");
  fprintf(Out_File,"   LAMPREF =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   DISTEFF =    0.050\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"OBSERVER\n");
  fprintf(Out_File,"   FLENGTH =    2.900\n");
  fprintf(Out_File,"   OBSPOS  =  -90.000 -950.000  230.000\n");
  fprintf(Out_File,"   ROTATE  =    5.800\n");
  fprintf(Out_File,"   TILT    =    3.000\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"MATERIAL\n");
  fprintf(Out_File,"   TYPE    = BLUEMATTE\n");
  fprintf(Out_File,"   TEXTURE = SHEETROCK\n");
  fprintf(Out_File,"   AMBRFL  =    0.100    0.100    0.200\n");
  fprintf(Out_File,"   DIFRFL  =    0.600    0.600    0.900\n");
  fprintf(Out_File,"   SPCRFL  =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   GLOSS   =    0.000\n");
  fprintf(Out_File,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   INDEX   =    1.000\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"MATERIAL\n");
  fprintf(Out_File,"   TYPE    = PHOSPHATE\n");
  fprintf(Out_File,"   TEXTURE = SMOOTH\n");
  fprintf(Out_File,"   AMBRFL  =    0.200    0.200    0.200\n");
  fprintf(Out_File,"   DIFRFL  =    0.600    0.600    0.600\n");
  fprintf(Out_File,"   SPCRFL  =    0.200    0.200    0.200\n");
  fprintf(Out_File,"   GLOSS   =   35.000\n");
  fprintf(Out_File,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   INDEX   =    1.000\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"{ nitrogenous bases (pyrimidine and purine derivatives) }\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"MATERIAL\n");
  fprintf(Out_File,"   TYPE    = GUANINE\n");
  fprintf(Out_File,"   TEXTURE = SMOOTH\n");
  fprintf(Out_File,"   AMBRFL  =    0.000    0.200    0.000\n");
  fprintf(Out_File,"   DIFRFL  =    0.000    0.600    0.000\n");
  fprintf(Out_File,"   SPCRFL  =    0.000    0.200    0.000\n");
  fprintf(Out_File,"   GLOSS   =   35.000\n");
  fprintf(Out_File,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   INDEX   =    1.000\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"MATERIAL\n");
  fprintf(Out_File,"   TYPE    = CYTOSINE\n");
  fprintf(Out_File,"   TEXTURE = SMOOTH\n");
  fprintf(Out_File,"   AMBRFL  =    0.000    0.000    0.200\n");
  fprintf(Out_File,"   DIFRFL  =    0.000    0.000    0.600\n");
  fprintf(Out_File,"   SPCRFL  =    0.000    0.000    0.200\n");
  fprintf(Out_File,"   GLOSS   =   35.000\n");
  fprintf(Out_File,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   INDEX   =    1.000\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"MATERIAL\n");
  fprintf(Out_File,"   TYPE    = THYMINE\n");
  fprintf(Out_File,"   TEXTURE = SMOOTH\n");
  fprintf(Out_File,"   AMBRFL  =    0.200    0.000    0.000\n");
  fprintf(Out_File,"   DIFRFL  =    0.600    0.000    0.000\n");
  fprintf(Out_File,"   SPCRFL  =    0.200    0.000    0.000\n");
  fprintf(Out_File,"   GLOSS   =   35.000\n");
  fprintf(Out_File,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   INDEX   =    1.000\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"MATERIAL\n");
  fprintf(Out_File,"   TYPE    = ADENINE\n");
  fprintf(Out_File,"   TEXTURE = SMOOTH\n");
  fprintf(Out_File,"   AMBRFL  =    0.200    0.000    0.200\n");
  fprintf(Out_File,"   DIFRFL  =    0.600    0.000    0.600\n");
  fprintf(Out_File,"   SPCRFL  =    0.200    0.000    0.200\n");
  fprintf(Out_File,"   GLOSS   =   35.000\n");
  fprintf(Out_File,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   INDEX   =    1.000\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"{ floor }\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"GROUND\n");
  fprintf(Out_File,"   MATL    = BLUEMATTE\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"{ lights }\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"LAMP\n");
  fprintf(Out_File,"   LOC     =  400.000 -400.000  400.000\n");
  fprintf(Out_File,"   RADIUS  =  100.000\n");
  fprintf(Out_File,"   INTENS  =    0.950    0.950    0.950\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"LAMP\n");
  fprintf(Out_File,"   LOC     = -400.000 -400.000  400.000\n");
  fprintf(Out_File,"   RADIUS  =  100.000\n");
  fprintf(Out_File,"   INTENS  =    0.950    0.950    0.950\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
}

Byte randnum[41];

void assignmoleculetypes()
{
  Word i;

  for (i = 0; i <= 40; i++)
    randnum[i] = 0;
  for (i = 0; i <= 40; i++)
    randnum[i] = random(4);
}

void makedna()
{
  Word theta;
  Word theta2;
  Word dtheta;
  float x, y, z;
  float dz;
  Word level;
  Word t;
  float phase;
  float rad;

  assignmoleculetypes();
  phase = 0.0;
  for (t = 1; t <= numberofframes; t++)
  {
    writestudio();
    theta = (int)(phase) & 0xFFFF;
    theta2 = (int)(phase + 130) & 0xFFFF;
    rad = 15.0;
    x = 0.0;
    y = 0.0;
    z = rad;
    dtheta = 25;
    dz = 25.0;
    level = 1;
    do
    {
      x = 45 * cosd(theta);
      y = 45 * sind(theta);
      fprintf(Out_File,"SPHERE\n");
      fprintf(Out_File,"   LOC     = %3.3f %3.3f %3.3f\n",x,y,z);
      fprintf(Out_File,"   RADIUS  = %3.3f\n",rad);
      fprintf(Out_File,"   MATL    = PHOSPHATE\n");
      fprintf(Out_File,"\n");
      x = 45 * cosd(theta2);
      y = 45 * sind(theta2);
      fprintf(Out_File,"SPHERE\n");
      fprintf(Out_File,"   LOC     = %3.3f %3.3f %3.3f\n",x,y,z);
      fprintf(Out_File,"   RADIUS  = %3.3f\n",rad);
      fprintf(Out_File,"   MATL    = PHOSPHATE\n");
      fprintf(Out_File,"\n");
      if ((level % 2 == 0))
      {
	x = 15 * cosd(theta);
	y = 15 * sind(theta);
	fprintf(Out_File,"SPHERE\n");
	fprintf(Out_File,"   LOC     = %3.3f %3.3f %3.3f\n",x,y,z);
	fprintf(Out_File,"   RADIUS  = %3.3f\n",rad);
	switch (randnum[(level - 1) / 2])
	{
	  case 0 : fprintf(Out_File,"   MATL    = GUANINE\n");
		   break;
	  case 1 : fprintf(Out_File,"   MATL    = CYTOSINE\n");
		   break;
	  case 2 : fprintf(Out_File,"   MATL    = THYMINE\n");
		   break;
	  case 3 : fprintf(Out_File,"   MATL    = ADENINE\n");
		   break;
	}
	fprintf(Out_File,"\n");
	x = 15 * cosd(theta2);
	y = 15 * sind(theta2);
	fprintf(Out_File,"SPHERE\n");
	fprintf(Out_File,"   LOC     = %3.3f %3.3f %3.3f\n",x,y,z);
	fprintf(Out_File,"   RADIUS  = %3.3f\n",rad);
	switch (randnum[(level - 1) / 2])
	{
	  case 0 : fprintf(Out_File,"   MATL    = CYTOSINE\n");
		   break;
	  case 1 : fprintf(Out_File,"   MATL    = GUANINE\n");
		   break;
	  case 2 : fprintf(Out_File,"   MATL    = ADENINE\n");
		   break;
	  case 3 : fprintf(Out_File,"   MATL    = THYMINE\n");
		   break;
	}
	fprintf(Out_File,"\n");
      }
      level = level + 1;
      theta = theta + dtheta;
      theta2 = theta2 + dtheta;
      z = z + dz;
    }
    while (!(((int)(theta - phase) > 360)));
    fprintf(Out_File,"");
    fprintf(Out_File,"");
    fprintf(Out_File,"ENDFRAME");
    phase = phase + (360.0 / numberofframes);
  }
}

void main()
{
  strcpy(filename,"DNA.RT");
  clrscr();
  printf("Generating %s File\n",filename);
  printf("\n");
  printf("By Christopher D. Watkins\n");
  printf("\n");
  printf("\n");
  printf("Writing %d frames\n",numberofframes);
  Out_File=fopen(filename, "wt");
  writeheader();
  makedna();
  fclose(Out_File);
}