/*
  ͻ
                                                                          
                                 Fly Over                                 
                                                                          
                         by Christopher D. Watkins                        
                                                                          
  ͼ
*/

#include "stdio.h"
#include "dos.h"
#include "math.h"
#include "defs.h"

typedef char name[33];

FILE *Out_File;
name filename;

Word xresolution  = 160;
Word yresolution  = 100;
Byte numberofframes  = 30;

void writeheader()
{
  fprintf(Out_File,"ͻ\n");
  fprintf(Out_File,"                                                                        \n");
  fprintf(Out_File,"                               Fly Over                                 \n");
  fprintf(Out_File,"                                                                        \n");
  fprintf(Out_File,"                       by Christopher D. Watkins                        \n");
  fprintf(Out_File,"                                                                        \n");
  fprintf(Out_File,"ͼ\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"STATS\n");
  fprintf(Out_File,"   XRES    = %d\n",xresolution);
  fprintf(Out_File,"   YRES    = %d\n",yresolution);
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"FRAMES\n");
  fprintf(Out_File,"   NUMBER  = %d\n",numberofframes);
}

float ypos;

void writestudio()
{
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"ENVIRONMENT\n");
  fprintf(Out_File,"   LOCLWGT =    0.750    0.750    0.750\n");
  fprintf(Out_File,"   REFLWGT =    0.250    0.250    0.250\n");
  fprintf(Out_File,"   TRANWGT =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   MINWGT  =    0.030    0.030    0.030\n");
  fprintf(Out_File,"   MAXWGT  =    1.000    1.000    1.000\n");
  fprintf(Out_File,"   RDEPTH  =    2\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"LAMPS\n");
  fprintf(Out_File,"   REFLAMP = FALSE\n");
  fprintf(Out_File,"   LAMPREF =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   DISTEFF =    0.050\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"OBSERVER\n");
  fprintf(Out_File,"   FLENGTH =    3.200\n");
  fprintf(Out_File,"   OBSPOS  =    0.000 %3.3f 220.000\n",ypos);
  fprintf(Out_File,"   ROTATE  =    0.000\n");
  fprintf(Out_File,"   TILT    =   16.000\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"SKY\n");
  fprintf(Out_File,"   HORCOL  =    0.500    0.600    0.700\n");
  fprintf(Out_File,"   ZENCOL  =    0.700    0.800    1.000\n");
  fprintf(Out_File,"   CLOUDS  = FALSE\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"MATERIAL\n");
  fprintf(Out_File,"   TYPE    = PLASTICTILE\n");
  fprintf(Out_File,"   TEXTURE = CHECKER\n");
  fprintf(Out_File,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(Out_File,"   DIFRFL  =    0.700    0.700    0.700\n");
  fprintf(Out_File,"   SPCRFL  =    0.200    0.200    0.200\n");
  fprintf(Out_File,"   GLOSS   =    8.000\n");
  fprintf(Out_File,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(Out_File,"   INDEX   =    1.000\n");
  fprintf(Out_File,"   TILE1   =    1.000    0.200    0.200\n");
  fprintf(Out_File,"   TILE2   =    0.250    0.250    0.250\n");
  fprintf(Out_File,"   TILE    =    0.012\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"GROUND\n");
  fprintf(Out_File,"   MATL    = PLASTICTILE\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"LAMP\n");
  fprintf(Out_File,"   LOC     =  150.000 %3.3f 350.000\n",ypos);
  fprintf(Out_File,"   RADIUS  =  100.000\n");
  fprintf(Out_File,"   INTENS  =    0.950    0.950    0.910\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"\n");
  fprintf(Out_File,"LAMP\n");
  fprintf(Out_File,"   LOC     = -150.000 %3.3f 350.000\n",ypos);
  fprintf(Out_File,"   RADIUS  =  100.000\n");
  fprintf(Out_File,"   INTENS  =    0.950    0.950    0.910\n");
}

void make()
{
  Byte t;

  ypos = -660.0;
  for (t = 1; t <= numberofframes; t++)
  {
    writestudio();
    ypos = ypos + (2.0 / 0.012) / numberofframes;
    fprintf(Out_File,"\n");
    fprintf(Out_File,"\n");
    fprintf(Out_File,"ENDFRAME\n");
  }
}

void main()
{
  strcpy(filename,"FlyOver.RT");
  clrscr();
  printf("Generating %s File\n",filename);
  printf("\n");
  printf("By Christopher D. Watkins\n");
  printf("\n");
  printf("\n");
  printf("Writing %d frames\n",numberofframes);
  Out_File=fopen(filename, "wt");
  writeheader();
  make();
  fclose(Out_File);
}