/*
  ͻ
                                                                          
                         M&T Publishing, Inc. Logo                        
                                                                          
                         by Christopher D. Watkins                        
                                                                          
  ͼ
*/

#include "stdio.h"
#include "dos.h"
#include "math.h"
#include "defs.h"

#define Pi_Over_180 0.01745

float CosD(float a)
{
  return( cos(a * Pi_Over_180));
}

float SinD(float a)
{
  return (sin(a * Pi_Over_180));
}


typedef char name[81];

FILE *textdiskfile;
name filename;

Word xresolution  = 1024;
Word yresolution  = 768;
Byte numberofframes  = 1;

void writeheader()
{
  fprintf(textdiskfile,"ͻ\n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"                       M&T Publishing, Inc. Logo                        \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"                       by Christopher D. Watkins                        \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"ͼ\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"STATS\n");
  fprintf(textdiskfile,"   XRES    = %d\n",xresolution);
  fprintf(textdiskfile,"   YRES    = %d\n",yresolution);
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"FRAMES\n");
  fprintf(textdiskfile,"   NUMBER  = %d\n",numberofframes);
}

float oceanphase;

void writestudio()
{
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"ENVIRONMENT\n");
  fprintf(textdiskfile,"   LOCLWGT =    0.800    0.800    0.800\n");
  fprintf(textdiskfile,"   REFLWGT =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   TRANWGT =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   MINWGT  =    0.030    0.030    0.030\n");
  fprintf(textdiskfile,"   MAXWGT  =    1.000    1.000    1.000\n");
  fprintf(textdiskfile,"   RDEPTH  =    4\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMPS\n");
  fprintf(textdiskfile,"   REFLAMP = FALSE\n");
  fprintf(textdiskfile,"   LAMPREF =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   DISTEFF =    0.050\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"OBSERVER\n");
  fprintf(textdiskfile,"   FLENGTH =    3.400\n");
  fprintf(textdiskfile,"   OBSPOS  =  425.000 -850.000  215.000\n");
  fprintf(textdiskfile,"   ROTATE  =  -18.000\n");
  fprintf(textdiskfile,"   TILT    =    8.500\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"SKY\n");
  fprintf(textdiskfile,"   HORCOL  =    0.600    0.700    1.000\n");
  fprintf(textdiskfile,"   ZENCOL  =    0.500    0.500    0.500\n");
  fprintf(textdiskfile,"   CLOUDS  = TRUE\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = BRASS\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.300    0.300    0.300\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.600    0.500    0.250\n");
  fprintf(textdiskfile,"   GLOSS   =   20.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = REDMIRROR\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.500    0.350    0.350\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.400    0.250    0.250\n");
  fprintf(textdiskfile,"   GLOSS   =    8.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = WATER\n");
  fprintf(textdiskfile,"   TEXTURE = OCEANWAVES\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.300\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.100    0.300    0.300\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.100    0.100    0.400\n");
  fprintf(textdiskfile,"   GLOSS   =    3.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"   AMPL    =    0.550\n");
  fprintf(textdiskfile,"   PHASE   = %f\n",oceanphase);
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"GROUND\n");
  fprintf(textdiskfile,"   MATL    = WATER\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMP\n");
  fprintf(textdiskfile,"   LOC     = -350.000 -350.000  350.000\n");
  fprintf(textdiskfile,"   RADIUS  =   50.000\n");
  fprintf(textdiskfile,"   INTENS  =    0.950    0.950    0.910\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMP\n");
  fprintf(textdiskfile,"   LOC     = 1000.000 -999.000 1000.000\n");
  fprintf(textdiskfile,"   RADIUS  =  700.000\n");
  fprintf(textdiskfile,"   INTENS  =    0.950    0.950    0.890\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"SPHERE\n");
  fprintf(textdiskfile,"   LOC     =  135.000  300.000  130.000\n");
  fprintf(textdiskfile,"   RADIUS  =   90.000\n");
  fprintf(textdiskfile,"   MATL    = REDMIRROR\n");
}

#define rad 10.0
#define zoff (rad + 15.0)

void sph(float x, float y, float z)
{
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"SPHERE\n");
  fprintf(textdiskfile,"   LOC     = %3.3f %3.3f %3.3f\n",x,y,z);
  fprintf(textdiskfile,"   RADIUS  = %3.3f\n",rad);
  fprintf(textdiskfile,"   MATL    = BRASS\n");
}

void cyl(float x1, float y1, float z1, float x2, float y2, float z2)
{
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CYLINDER\n");
  fprintf(textdiskfile,"   BASELOC = %3.3f %3.3f %3.3f\n",x1,y1,z1);
  fprintf(textdiskfile,"   BASERAD = %3.3f\n",rad);
  fprintf(textdiskfile,"   APEXLOC = %3.3f %3.3f %3.3f\n",x2,y2,z2);
  fprintf(textdiskfile,"   MATL    = BRASS\n");
}

void make()
{
  int i;
  float dx, th;

    /*  M  */
  sph(0.0,0.0,zoff);
  cyl(0.0,0.0,zoff,0.0,0.0,zoff + 100.0);
  sph(0.0,0.0,zoff + 100.0);
  cyl(0.0,0.0,zoff + 100.0,57.5,0.0,zoff);
  sph(57.5,0.0,zoff);
  cyl(57.5,0.0,zoff,115.0,0.0,zoff + 100.0);
  sph(115.0,0.0,zoff + 100.0);
  cyl(115.0,0.0,zoff + 100.0,115.0,0.0,zoff);
  sph(115.0,0.0,zoff);

    /*  &  */
  for (i = 0; i <= 17; i++)
    sph(239.0 - i * 4.1,0.0,zoff + i * 4.1);
  th = 212;
  for (i = 0; i <= 20; i++)
  {
    sph(184.0 + 20 * CosD(th),0.0,zoff + 80.0 + 20 * SinD(th));
    th = th - 9;
  }
  th = 98;
  dx = 0.0;
  for (i = 0; i <= 60; i++)
  {
    sph(174.0 + 34 * CosD(th) + dx,0.0,zoff + 34.0 + 34 * SinD(th));
    th = th + 4.5;
    if(th > 180)
      dx = dx + 0.5;
  }

    /*  T  */
  sph(221.0,0.0,zoff + 100.0);
  cyl(221.0,0.0,zoff + 100.0,321.0,0.0,zoff + 100.0);
  sph(321.0,0.0,zoff + 100.0);
  cyl(271.0,0.0,zoff + 100.0,271.0,0.0,zoff);
  sph(271.0,0.0,zoff);
}

void main()
{
  oceanphase = 0.0;
  strcpy(filename,"M&T.RT");
  clrscr();
  printf("Generating %s File\n",filename);
  printf("\n");
  printf("By Christopher D. Watkins\n");
  printf("\n");
  printf("\n");
  printf("Writing %d frames\n",numberofframes);
  textdiskfile=fopen(filename, "wt");
  writeheader();
  writestudio();
  make();
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"BOUNDINGSPHERETEST\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"ENDFRAME\n");
  fclose(textdiskfile);
}