/*

  ͻ
                                                                          
                  Recursive Tetrahedron : Spheres at Centers              
                                                                          
                         By Christopher D. Watkins                        
                                                                          
  ͼ

*/

#include "stdio.h"
#include "stdlib.h"
#include "dos.h"
#include "math.h"
#include "defs.h"
#include "globals.h"
#include "mathb.h"
#include "graphb.h"

typedef char name[33];

FILE *textdiskfile;
name filename;

Word xresolution  = 1024;
Word yresolution  = 768;
Byte numberofframes  = 1;

void writeheader()
{
  fprintf(textdiskfile,"ͻ\n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"               Recursive Tetrahedron : Spheres at Centers               \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"                       by Christopher D. Watkins                        \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"ͼ\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"STATS\n");
  fprintf(textdiskfile,"   XRES    = %d\n",xresolution);
  fprintf(textdiskfile,"   YRES    = %d\n",yresolution);
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"FRAMES\n");
  fprintf(textdiskfile,"   NUMBER  = %d\n",numberofframes);
}

void writestudio()
{
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"ENVIRONMENT\n");
  fprintf(textdiskfile,"   LOCLWGT =    0.750    0.750    0.750\n");
  fprintf(textdiskfile,"   REFLWGT =    0.250    0.250    0.250\n");
  fprintf(textdiskfile,"   TRANWGT =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   MINWGT  =    0.030    0.030    0.030\n");
  fprintf(textdiskfile,"   MAXWGT  =    1.000    1.000    1.000\n");
  fprintf(textdiskfile,"   RDEPTH  =    2\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMPS\n");
  fprintf(textdiskfile,"   REFLAMP = FALSE\n");
  fprintf(textdiskfile,"   LAMPREF =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   DISTEFF =    0.050\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"OBSERVER\n");
  fprintf(textdiskfile,"   FLENGTH =    3.500\n");
  fprintf(textdiskfile,"   OBSPOS  = -120.000  660.000  220.000\n");
  fprintf(textdiskfile,"   ROTATE  =  169.000\n");
  fprintf(textdiskfile,"   TILT    =   13.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"SKY\n");
  fprintf(textdiskfile,"   HORCOL  =    0.300    0.300    0.400\n");
  fprintf(textdiskfile,"   ZENCOL  =    0.700    0.800    1.000\n");
  fprintf(textdiskfile,"   CLOUDS  = FALSE\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = PLASTICTILE\n");
  fprintf(textdiskfile,"   TEXTURE = CHECKER\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.700    0.700    0.700\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   GLOSS   =    8.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"   TILE1   =    1.000    0.200    0.200\n");
  fprintf(textdiskfile,"   TILE2   =    0.250    0.250    0.250\n");
  fprintf(textdiskfile,"   TILE    =    0.012\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = BRASS\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.300    0.300    0.300\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.600    0.500    0.250\n");
  fprintf(textdiskfile,"   GLOSS   =   15.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"GROUND\n");
  fprintf(textdiskfile,"   MATL    = PLASTICTILE\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMP\n");
  fprintf(textdiskfile,"   LOC     =  350.000  150.000  300.000\n");
  fprintf(textdiskfile,"   RADIUS  =  100.000\n");
  fprintf(textdiskfile,"   INTENS  =    0.900    0.900    0.900\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMP\n");
  fprintf(textdiskfile,"   LOC     = -350.000  250.000  300.000\n");
  fprintf(textdiskfile,"   RADIUS  =  100.000\n");
  fprintf(textdiskfile,"   INTENS  =    0.900    0.900    0.900\n");
}

Byte col;
float rad;
Word lastpoint;
TDA point[2048];

void addsphere(TDA pt)  /*  avoids repeating spheres  */
{
  Word t;

  if (lastpoint!=0)
  {
    for (t = 1; t <= lastpoint; t++)
    {
      if((point[t-1][0] == pt[0]) &&
	 (point[t-1][1] == pt[1]) &&
	 (point[t-1][2] == pt[2]))
	return;
    }
  }
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"SPHERE\n");
  fprintf(textdiskfile,"   LOC     = %3.3f %3.3f %3.3f\n",pt[0],pt[1],pt[2] + rad);
  fprintf(textdiskfile,"   RADIUS  = %3.3f\n",rad);
  fprintf(textdiskfile,"   MATL    = BRASS\n");
  lastpoint = lastpoint + 1;
  VecCopy(pt,point[lastpoint-1]);
}

void tetra(int x1, int y1, int z1,
	   int x2, int y2, int z2,
	   int x3, int y3, int z3,
	   int x4, int y4, int z4,
	   Byte level)

{
  TDA pnt1, pnt2;
  TDA pnt3, pnt4;
  TDA avr;

  if ((level == 0))
  {
    Vec(x1,y1,z1,pnt1);
    Vec(x2,y2,z2,pnt2);
    Vec(x3,y3,z3,pnt3);
    Vec(x4,y4,z4,pnt4);
    VecAdd3(pnt1,pnt2,pnt3,avr);
    VecAdd(avr,pnt4,avr);
    VecScalMult(0.25,avr,avr);
    addsphere(avr);
    Draw_Line_3D(pnt1,pnt2,col);
    Draw_Line_3D(pnt2,pnt3,col);
    Draw_Line_3D(pnt3,pnt1,col);
    Draw_Line_3D(pnt1,pnt4,col);
    Draw_Line_3D(pnt4,pnt2,col);
    Draw_Line_3D(pnt3,pnt4,col);
  }
  else
  {
    tetra(x1,y1,z1,(x1 + x2) / 2,(y1 + y2) / 2,(z1 + z2) / 2,(x1 + x3) / 2,(y1 + y3) / 2,(z1 + z3) / 2,(x1 + x4) / 2,(y1 + y4) / 2,(z1 + z4) / 2,level - 1);
    tetra(x2,y2,z2,(x2 + x3) / 2,(y2 + y3) / 2,(z2 + z3) / 2,(x2 + x4) / 2,(y2 + y4) / 2,(z2 + z4) / 2,(x2 + x1) / 2,(y2 + y1) / 2,(z2 + z1) / 2,level - 1);
    tetra(x3,y3,z3,(x3 + x4) / 2,(y3 + y4) / 2,(z3 + z4) / 2,(x3 + x1) / 2,(y3 + y1) / 2,(z3 + z1) / 2,(x3 + x2) / 2,(y3 + y2) / 2,(z3 + z2) / 2,level - 1);
    tetra(x4,y4,z4,(x4 + x1) / 2,(y4 + y1) / 2,(z4 + z1) / 2,(x4 + x2) / 2,(y4 + y2) / 2,(z4 + z2) / 2,(x4 + x3) / 2,(y4 + y3) / 2,(z4 + z3) / 2,level - 1);
    col = (level % 6) * 36 + 35;
  }
}

/*
  ͻ
                          M a i n  P r o g r a m                          
  ͼ
*/

int x1, y1, z1;
int x2, y2, z2;
int x3, y3, z3;
int x4, y4, z4;
Word t;

#define rot 0    /*  rotation aRound z-axis    0 = x-direction  */
#define ang1 0 + rot
#define ang2 120 + rot
#define ang3 240 + rot
#define scale 150    /*  scaling  */
#define xs scale
#define ys scale
#define zs scale
#define level 4    /*  level of recursion  */   /*  level = 4^Level spheres  */
		       /*  0 ->     1 spheres  */
		       /*  1 ->     4 spheres  */
		       /*  2 ->    16 spheres  */
		       /*  3 ->    64 spheres  */
		       /*  4 ->   256 spheres  */

void main()
{
  randomize();
  strcpy(filename,"TetSphr2.RT");
  Title();
  clrscr();
  printf("Generating %s File\n",filename);
  printf("\n");
  printf("By Christopher D. Watkins\n");
  printf("\n");
  printf("\n");
  printf("Writing %d frames\n",numberofframes);
  printf("\n");
  printf("\n");
  printf("Depth of Recursion = %d\n",level);
  printf("\n");
  printf("This Depth yields %d spheres\n",IntPower(4,level));
  printf("\n");
  printf("\n");
  printf("< Hit any Key >\n");
  Wait_For_Key();
  textdiskfile=fopen(filename, "wt");
  Init_Graphics(56);
  Init_Perspective(true,0,0,250,500);
  Init_Plotting(-20,10);
  Put_Axis_And_Palette(true);
  Axis_And_Palette();
  col = 35;
  rad = sqrt(SqrFP(xs * (CosD(ang1) - CosD(ang2))) + SqrFP(ys * (SinD(ang1) - SinD(ang2)))) / ((Power(2,level + 1) + Power(2,level)) / 2.0);
  x1 = Round(xs * CosD(ang1));
  y1 = Round(ys * SinD(ang1));
  z1 = 0;
  x2 = Round(xs * CosD(ang2));
  y2 = Round(ys * SinD(ang2));
  z2 = 0;
  x3 = Round(xs * CosD(ang3));
  y3 = Round(ys * SinD(ang3));
  z3 = 0;
  x4 = 0;
  y4 = 0;
  z4 = zs;
  lastpoint = 0;   /*  point array  */
  for (t = 1; t <= 2048; t++)
    VecNull(point[t-1]);
  writeheader();
  writestudio();
  tetra(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,level);
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"BOUNDINGSPHERETEST\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"ENDFRAME\n");
  fclose(textdiskfile);
  Exit_Graphics();
}