/*
  ͻ
                                                                          
                                  Plant                                   
                                                                          
                          Christopher D. Watkins                          
                                                                          
  ͼ
*/

#include "stdio.h"
#include "dos.h"
#include "string.h"
#include "defs.h"
#include "globals.h"
#include "mathb.h"
#include "graphb.h"

Word x=512;    /*  coordinate for base of trunk  */
Word y=767;
float Angle=0.0;    /*  trunk Angle with respect to ground normal  */
float BranchFan=45.0;    /*  maximum 'fan' of branch grouping  */
float Height=120.0;    /*  Height of trunk  */
float HeightFactor=0.75;
float AngleFactor=0.75;
float BranchDensity=2.0;
Byte Depth=10;

#define TreeColor (2*36-1)-10
#define LeafColor (5*36-1)

float InvBranchDensity;

void Tree(Word y, Word x,
	  float Angle, float BranchFan,
	  float Height, float HeightFactor,
	  Byte Depth)

{
  Byte i;
  Word xinc, yinc;
  float Start, Theta;
  Word NewHeight;

  if(Depth==0)
  {
    Draw(x-3, y, x+3, y, LeafColor);
    Draw(x, y-3, x, y+3, LeafColor);
  }
  else
  {
    Start=Angle-BranchFan*0.5;
    Theta=BranchFan*InvBranchDensity;
    if(Depth<3)
      HeightFactor=HeightFactor*0.5;
    xinc=Round(Height*SinD(Angle))&0xFFFF;
    yinc=Round(Height*CosD(Angle))&0xFFFF;
    Draw(x, y, x+xinc, y-yinc, TreeColor);
    for(i=0; i<=BranchDensity; i++)
    {
      NewHeight=Round(Height*HeightFactor)&0xFFFF;
      Tree(y-yinc, x+xinc,
	   Start*0.5+Sign(Start)*RandInt(abs(Round(Start))+1),
	   BranchFan*AngleFactor,
	   NewHeight*0.5+RandInt(NewHeight+1),
	   HeightFactor,
	   Depth-1);
      Start=Start+Theta;
    }
  }
}

void main()
{
  InitRand(3.9);
  Init_Graphics(56);
  InvBranchDensity=1.0/BranchDensity;
  Tree(y, x, Angle, BranchFan, Height, HeightFactor, Depth);
  Exit_Graphics();
}