/* ***********************************************************************
   *									 *
   *		  	  Grid Database Generator		         *
   *									 *
   *				Program by				 *
   *			   Christopher D. Watkins			 *
   *									 *
   *			     'C' conversion by				 *
   *                            Larry Sharp				 *
   *									 *
   ***********************************************************************
*/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "math.h"
#include "string.h"
#include "malloc.h"
#include "defs.h"
#include "globals.h"
#include "mathb.h"
#include "graphb.h"
#include "modelsup.h"
#include "shpmk.h"

/* ***********************************************************************
   *									 *
   *				Equations				 *
   *									 *
   ***********************************************************************
*/

#define Span 5.0
#define Contour 13
#define Offset 0.5


float Dx, HalfDx;
float Dy, HalfDy;
float x, y;
float sx, sy;
float ix, iy;
float ex, ey;

void SetupGrid(float Xlft, float Xrgt,
	       float Ybot, float Ytop,
	       int HorzContours, int VertContours,
	       float offset)
{
  VertexNum=1;
  VertexNumInFacet=1;
  LastFacet=HorzContours*VertContours;
  LastVertexNumInFacet=MaxVertexNumInFacet;
  LastVertex=LastFacet*LastVertexNumInFacet;
  sx=20.0/((Xrgt-Xlft)*11.0);
  sy=20.0/((Ytop-Ybot)*11.0);
  Dx=(Xrgt-Xlft)/(float)(HorzContours-1);
  Dy=(Ybot-Ytop)/(float)(VertContours-1);
  HalfDx=Dx/((offset+1.0)*2.0);
  HalfDy=Dy/((offset+1.0)*2.0);
  ix=Xlft;
  iy=Ytop;
  ex=Xrgt;
  ey=Ybot;
}

void MakeGridDatabase()
{
  float XMinus, XPlus;
  float YMinus, YPlus;

  FacetNum=0;
  x=ix;
  do
  {
    XMinus=sx*(x-HalfDx);
    XPlus=sx*(x+HalfDx);
    y=iy;
    do
    {
      ++FacetNum;
      YMinus=sy*(y-HalfDy);
      YPlus=sy*(y+HalfDy);
      AddVertex(XMinus, YPlus, 0.0);
      AddVertex(XPlus, YPlus, 0);
      AddVertex(XPlus, YMinus, 0);
      AddVertex(XMinus, YMinus, 0);
      VertexNumInFacet=1;
      y+=Dy;
    }
    while(y>=ey);
    x+=Dx;
  }
  while(x<=ex);
}

/* ***********************************************************************
   *									 *
   *				Main Program				 *
   *									 *
   ***********************************************************************
*/

void main()
{
  Facet=farcalloc(((MaxFacet+1)*(MaxVertexNumInFacet+1)), sizeof(int));
  InitVertexMaker();
  SetupGrid(-Span, Span, -Span, Span, Contour, Contour, Offset);
  MakeGridDatabase();
  SaveData("GRID.DAT");
  Exit_Graphics();
  farfree(Facet);
}
