/* ***********************************************************************
   *									 *
   *                  Addition of Verticies to Objects	 		 *
   *									 *
   *		 Original Material by Christopher D. Watkins		 *
   *									 *
   *			     'C' conversion by				 *
   *                            Larry Sharp				 *
   *									 *
   ***********************************************************************

   ReduceRepeatedVerticies - switch repeated vertex check
   AddVertex		   - adds vertex to database
*/

Boolean RepeatedVertexCheck;
Boolean RepeatedVertex;
int OldVertexNum;

void ReduceRepeatedVerticies(Boolean Repeated)
{
  RepeatedVertexCheck=Repeated;
}

void CheckForRepeatingVerticies(int x, int y, int z)
{
  RepeatedVertex=false;
  if(FacetNum>1)
  {
    for(OldVertexNum=VertexNum-1; OldVertexNum>=1; OldVertexNum--)
    {
      if((Vertex[OldVertexNum][0]==x) &&
	 (Vertex[OldVertexNum][1]==y) &&
	 (Vertex[OldVertexNum][2]==z))
      {
	RepeatedVertex=true;
	break;
      }
    }
  }
}

void AddVertex(float xr, float yr, float zr)
{
  Boolean XError, YError, ZError;
  int x, y, z;
  float sc;

  if((xr<-1.0) || (xr>1.0))
    XError=true;
  else
    XError=false;
  if((yr<-1.0) || (yr>1.0))
    YError=true;
  else
    YError=false;
  if((zr<-1.0) || (zr>1.0))
    ZError=true;
  else
    ZError=false;
  if(XError || YError || ZError)
  {
    sound(1000);
    delay(1000);
    nosound();
    ungetch(32);
    Exit_Graphics();
    printf("Out of Range -1 to +1 in ");
    if(XError)
      puts("X !");
    else
    {
      if(YError)
	puts("Y !");
      else
	puts("Z !");
    }
    printf("\n\n\n\nHit any key to exit....\n");
    getch();
    exit(1);
  }
  x=Round((float)ScaleData*xr);
  y=Round((float)ScaleData*yr);
  z=Round((float)ScaleData*zr);
  if(RepeatedVertexCheck)
    CheckForRepeatingVerticies(x, y, z);
  else
    RepeatedVertex=false;
  if(!(RepeatedVertex))
  {
    VecInt(x, y, z, Vertex[VertexNum]);
    sc=100.0/(float)ScaleData;
    Cartesian_Plot_3D(sc*(float)x, sc*(float)y, sc*(float)z, 215);
    Facet[(FacetNum*5)+VertexNumInFacet]=VertexNum;
    LastVertex=VertexNum;
    ++VertexNum;
  }
  else
    Facet[(FacetNum*5)+VertexNumInFacet]=OldVertexNum;
  ++VertexNumInFacet;
}

/* ***********************************************************************
   *									 *
   *		  Initialization of Vertex Database Maker		 *
   *									 *
   ***********************************************************************

   InitVertexMaker - calls routines required to generate an object database
*/

void InitVertexMaker()
{
  Init_Graphics(19);
  Init_Perspective(false, 0, 0, 500, 500);
  Init_Plotting(215, 18);
  Put_Axis_And_Palette(true);
  Axis_And_Palette();
  InitVertexBuffer();
  ReduceRepeatedVerticies(true);
}
