/* ***********************************************************************
   *									 *
   *		           Toroid Database Generator		         *
   *									 *
   *				Program by				 *
   *			   Christopher D. Watkins			 *
   *									 *
   *			     'C' conversion by				 *
   *                            Larry Sharp				 *
   *									 *
   ***********************************************************************
*/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "math.h"
#include "string.h"
#include "malloc.h"
#include "defs.h"
#include "globals.h"
#include "mathb.h"
#include "graphb.h"
#include "modelsup.h"
#include "shpmk.h"

int Theta, DTheta, HalfDTheta;
int Phi, DPhi, HalfDPhi;
int HorzLoop, VertLoop;

void SetupToroid(int Horizontal, int Vertical)
{
  VertexNum=1;
  VertexNumInFacet=1;
  HorzLoop=Horizontal;
  VertLoop=Vertical;
  LastFacet=HorzLoop*VertLoop;
  LastVertexNumInFacet=MaxVertexNumInFacet;
  LastVertex=LastFacet*LastVertexNumInFacet;
  DTheta=360/HorzLoop;
  HalfDTheta=DTheta/2;
  Theta=HalfDTheta+45+45;
  DPhi=360/VertLoop;
  HalfDPhi=DPhi/2;
  Phi=HalfDPhi;
}

void MakeToroidDatabase(float Rho, float R)
{
  float CosThetaMinus, SinThetaMinus;
  float CosThetaPlus, SinThetaPlus;
  float RCosPhiMinus, RSinPhiMinus;
  float RCosPhiPlus, RSinPhiPlus;
  float x, y, z;

  FacetNum=0;
  do
  {
    Phi=HalfDPhi;
    CosThetaMinus=CosD(Theta-HalfDTheta);
    SinThetaMinus=SinD(Theta-HalfDTheta);
    CosThetaPlus=CosD(Theta+HalfDTheta);
    SinThetaPlus=SinD(Theta+HalfDTheta);
    do
    {
      RCosPhiMinus=R*CosD(Phi-HalfDPhi);
      RSinPhiMinus=R*SinD(Phi-HalfDPhi);
      RCosPhiPlus=R*CosD(Phi+HalfDPhi);
      RSinPhiPlus=R*SinD(Phi+HalfDPhi);
      ++FacetNum;
      x=(Rho+RCosPhiMinus)*CosThetaMinus;
      y=(Rho+RCosPhiMinus)*SinThetaMinus;
      z=RSinPhiMinus;
      AddVertex(x, y, z);
      x=(Rho+RCosPhiMinus)*CosThetaPlus;
      y=(Rho+RCosPhiMinus)*SinThetaPlus;
      z=RSinPhiMinus;
      AddVertex(x, y, z);
      x=(Rho+RCosPhiPlus)*CosThetaPlus;
      y=(Rho+RCosPhiPlus)*SinThetaPlus;
      z=RSinPhiPlus;
      AddVertex(x, y, z);
      x=(Rho+RCosPhiPlus)*CosThetaMinus;
      y=(Rho+RCosPhiPlus)*SinThetaMinus;
      z=RSinPhiPlus;
      AddVertex(x, y, z);
      VertexNumInFacet=1;
      Phi+=DPhi;
    }
    while(Phi<360+HalfDPhi);
    Theta+=DTheta;
  }
  while(Theta<360+HalfDTheta+90);
}

/* ***********************************************************************
   *									 *
   *				Main Program				 *
   *									 *
   ***********************************************************************
*/

void main()
{
  Facet=farcalloc(((MaxFacet+1)*(MaxVertexNumInFacet+1)), sizeof(int));
  InitVertexMaker();
  SetupToroid(60, 60);
  MakeToroidDatabase(0.75, 0.25);
  SaveData("TOROID.DAT");
  Exit_Graphics();
  farfree(Facet);
}
