/* ***********************************************************************
   *									 *
   *			Histogram VGA Color Processor			 *
   *									 *
   *				Program by				 *
   *			   Christopher D. Watkins			 *
   *									 *
   *			     'C' conversion by				 *
   *				Larry Sharp				 *
   *									 *
   ***********************************************************************
*/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "malloc.h"
#include "string.h"
#include "defs.h"
#include "globals.h"
#include "mathb.h"
#include "graphb.h"

static Byte  far *ColorHistogram;
static Byte far *Frequency;
static Word far *Hues;
int LastColor;
Word ColorNum;
char Temp_File[80], Pic_File[80];
FILE *In_File;
FILE *Out_File;
Byte Frame_Num, Last_Frame_Num;
Palette_Register PalArray;

void Alloc_Mem()
{
  ColorHistogram=_fmalloc(32768);
  Frequency=_fmalloc(31000);
  Hues=_fcalloc(31000, sizeof(Word));
  if((ColorHistogram==NULL) || (Frequency==NULL) || (Hues==NULL))
  {
    printf("Not enough memory!\n");
    printf("Out of memory!\n Hit any key to exit.\n");
    getch();
    exit(1);
  }
}

void Free_Mem()
{
  farfree(ColorHistogram);
  farfree(Frequency);
  farfree(Hues);
}

void SwapByte(Byte *A, Byte *B)
{
  Byte T;

  T=*A;
  *A=*B;
  *B=T;
}

void SwapWord(Word *A, Word *B)
{
  Word T;

  T=*A;
  *A=*B;
  *B=T;
}

void Sort(Word First, Word Last)
{
  Word i, j, k;
  Word Pivot, Temp2;
  Byte Temp;

  if(First<Last-1)
  {
    i=First;
    j=Last;
    k=(First+Last)/2;
    Pivot=(Frequency[i]+Frequency[j]+Frequency[k])/3;
    while(i<j)
    {
      while(Frequency[i]>Pivot)
	++i;
      while(Frequency[j]<Pivot)
       --j;
      if(i<j)
      {
	SwapByte(&Frequency[i], &Frequency[j]);
	SwapWord(&Hues[i], &Hues[j]);
	++i;
	--j;
      }
    }
    if(j<Last)
    {
      Sort(First,j);
      Sort(j+1,Last);
    }
  }
  if(Frequency[Last]>Frequency[First])
  {
    SwapByte(&Frequency[First], &Frequency[Last]);
    SwapWord(&Hues[First], &Hues[Last]);
  }
}

void CollectColorData()
{
  Word x, y;

  gotoxy(1, 1);
  printf("Collecting color data from Frame# %d\n", Frame_Num);
  for(y=0; y<100; y++)
  {
    for(x=0; x<160; x++)
    {
      ColorNum=getw(In_File);
      if(ColorHistogram[ColorNum]<255)
	ColorHistogram[ColorNum]=ColorHistogram[ColorNum]+1;
    }
  }
}

void SortColorData()
{
  Word d1, Tempd, d2;
  Byte r1, g1, b1;
  Byte r2, g2, b2;
  Word i, j;

  printf("Sorting %d colors.\n",LastColor);
  Sort(0, LastColor);
  for(i=0; i<=255; i++)
    Frequency[i]=i;
  for(i=256; i<=LastColor; i++)
  {
    d1=32768;
    for(j=0; j<=255; j++)
    {
      r1=(Hues[i]<<1)&62;
      g1=(Hues[i]>>4)&62;
      b1=(Hues[i]>>9)&62;
      r2=(Hues[j]<<1)&62;
      g2=(Hues[j]>>4)&62;
      b2=(Hues[j]>>9)&62;
      Tempd=Sqr(r1-r2)+Sqr(g1-g2)+Sqr(b1-b2);
      if(Tempd<d1)
      {
	d1=Tempd;
	d2=j;
      }
    }
    Frequency[i]=d2;
  }
}

void MakePalette(Palette_Register PalArray)
{
  Word j;

  for(j=0; j<=255; j++)
  {
    PalArray[j].Red=(Hues[j]<<1)&62;
    PalArray[j].Grn=(Hues[j]>>4)&62;
    PalArray[j].Blu=(Hues[j]>>9)&62;
  }
}

void GetColorHistogramFromFrequency()
{
  Word j;

  for(j=0; j<=LastColor; j++)
    ColorHistogram[Hues[j]]=Frequency[j];
}

void DisplayFrame()
{
  Word x, y;

  for(y=0; y<100; y++)
  {
    for(x=0; x<160; x++)
    {
      ColorNum=getw(In_File);
      Plot(x, y, ColorHistogram[ColorNum]);
    }
  }
}

void Create_Arrays_For_Sort()
{
  Word j;

  LastColor=-1;
  for(j=0; j<32768; j++)
  {
    if(ColorHistogram[j]>0)
    {
      ++LastColor;
      if(LastColor>31000)
      {
	sound(750);
	delay(1000);
	nosound();
	exit(1);
      }
      Hues[LastColor]=j;
      Frequency[LastColor]=ColorHistogram[j];
    }
  }
  if(LastColor<0)
  {
    ungetch(32);
    Exit_Graphics();
    printf("No colors in frame.\n");
    exit(1);
  }
}

void AppendFile()
{
  Word x, y;
  Byte d;

  for(y=0; y<100; y++)
  {
    for(x=0; x<160; x++)
    {
      d=Get_Pixel(x, y);
      putc(d, Out_File);
    }
  }
}

void Get_TMP_File_Name()
{
  Byte x, y;

  textcolor(YELLOW);
  textbackground(BLUE);
  gotoxy(1, 8);
  cprintf("Enter File Name -> ");
  x=wherex();
  y=wherey();
  textcolor(WHITE+BLINK);
  cprintf("%s", "BOUNCE");
  textcolor(YELLOW);
  gotoxy(x, y);
  while(!(kbhit()));
  cprintf("            ");
  gotoxy(x, y);
  gets(Temp_File);
  if(!(strcmp(Temp_File, "")))
    strcpy(Temp_File, "BOUNCE");
  strupr(Temp_File);
  strcpy(Pic_File, Temp_File);
  strcat(Temp_File, ".TMP");
  strcat(Pic_File, ".ANI");
}

void Clear_Screen()
{
  Set_Graphics_Mode(160, 100);
  Init_Palette(PalArray);
  Set_Palette(PalArray);
}

void main()
{
  Title();
  Alloc_Mem();
  clrscr();
  Get_TMP_File_Name();
  Clear_Screen();
  _fmemset(ColorHistogram, 0, 32768);
  _fmemset(Frequency, 0, 31000);
  _fmemset(Hues, 0, 62000);
  if((Out_File=fopen(Pic_File, "wb"))==NULL)
  {
    ungetch(32);
    Exit_Graphics();
    printf("Can't open Output File!\n");
    exit(1);
  }
  if((In_File=fopen(Temp_File, "rb"))==NULL)
  {
    ungetch(32);
    Exit_Graphics();
    printf("Can't open Input File!\n");
    exit(1);
  }
  Last_Frame_Num=getc(In_File);
  for(Frame_Num=0; Frame_Num<Last_Frame_Num; Frame_Num++)
    CollectColorData();
  fclose(In_File);
  Create_Arrays_For_Sort();
  SortColorData();
  Clear_Screen();
  MakePalette(PalArray);
  Set_Palette(PalArray);
  GetColorHistogramFromFrequency();
  putc(Last_Frame_Num, Out_File);
  fwrite(PalArray, 768, 1, Out_File);
  if((In_File=fopen(Temp_File, "rb"))==NULL)
  {
    ungetch(32);
    Exit_Graphics();
    printf("Can't open Input File!\n");
    exit(1);
  }
  Last_Frame_Num=getc(In_File);
  for(Frame_Num=0; Frame_Num<Last_Frame_Num; Frame_Num++)
  {
    DisplayFrame();
    AppendFile();
  }
  fclose(In_File);
  fclose(Out_File);
  Free_Mem();
  remove(Temp_File);
  Exit_Graphics();
}