#include <stdio.h>

#define ENVSIZE 4000
extern int _PSP;
void *calloc();
char *environment=NULL, *str_upper();
int env_paragraph;
char *next_env;
#define envlimit(a) &a[ENVSIZE-1]

/* implement aliasing */
int alias(argc,argv)
char *argv[];
{
	if (argc == 1)
	{
		fprintf(stderr,"alias : usage alias name = string\n");
		return -1;
	}
	return set(argc,argv);
}
int unalias(argc,argv)
	char *argv[];
{
	char local[32],*index();
	if ((argc == 1) || (argc != 2))
	{
		fprintf(stderr,"unalias : usage unalias name\n");
		return -1;
	}
	if (NULL == index(argv[1],'='))
	{
		strcpy(local,argv[1]);
		strcat(local,"=");
		argv[1] = local;
	}
	set(argc,argv);
}
#ifdef MAIN
int main
#else
int set
#endif
(argc,argv)
	char *argv[];
{
	char *index();
	char setbuffer[256];
	if (!environment)
		init_env();
	if (argc == 1)
	{
		show_env();
		return 0;
	}
	while(--argc)
	{
		/* need to allow for formats such as set var = foo */
		if (NULL == index(*++argv,'=') && argv[1][0] == '=' && argv[2])
		{
			strcpy(setbuffer,*argv);
			strcat(setbuffer,*++argv);
			strcat(setbuffer,*++argv);
			argc -= 2;
		}
		else
			strcpy(setbuffer,*argv);
		(void)add_env(setbuffer);
	}
	return 0;
}

char *
str_upper(c)
	register char *c;
{
	register char *save = c;
	while(*c)
	{
		*c = toupper(*c);
		c++;
	}
	return save;
}

char *
str_lower(c)
	register char *c;
{
	register char *save = c;
	while(*c)
	{
		*c = tolower(*c);
		c++;
	}
	return save;
}
init_env()
{
	extern unsigned _dsval;	/* current data segment register value */
	long fudgefactor;
	register int c;
	unsigned envseg;
	unsigned offset = 0;
	envseg = peekw(0x2c,_PSP);
	environment = calloc((unsigned)1,(unsigned)ENVSIZE+16);
	/* convert to absolute long */
	fudgefactor = (long)_dsval << 4;
	/* add in offset of environment space and round up to next paragraph */
	fudgefactor += (unsigned)environment + 15;
	fudgefactor &= 0xFFFF0L;
	/*lint -e511 lint doesn't want to know about this!! */
	/* shift back to a 16 bit segment value */
	env_paragraph = (int)((fudgefactor >>4) & 0xFFFF);
	/* subtract out _ds to make short pointer for local use */
	environment = (char *) (fudgefactor - (long)(_dsval << 4));
	/*lint +e511 lint doesn't want to know about this!! */
	next_env = environment;
	/* copy environment strings */
	while (c = peekb(offset,envseg))
	{
		while (c = peekb(offset++,envseg))
		{
			/* change backslashes to forward slashes */
			*next_env++ = (c == '\\' ? '/' : c);
		}
		*next_env++ = '\0';
	}
}

show_env()
{
	register char *env;
	char c;
	for (env = environment;*env;)
	{
		while (c = *env++)
			write(1,&c,1);
		crlf();
	}
}

static char *enverr = "No more environment space\r\n";
static char *enverr2 = "Improper environment string format!!\r\n";

char *get_env(string)
	char *string;
{
	char local[32];
	register char *env; char *index();
	char *envstring;

	int namelen = strlen(string);
	strncpy(local,string,32);

	for (env = environment;*env;)
	{
		if (0 == strncmp(env,local,namelen))
		{
			/* a match */
			if (NULL == (envstring = index(env,'=')))
			{
				write(2,enverr2,strlen(enverr2));
				return NULL;
			}
			/* string desired starts one byte after the equals sign */
			++envstring; return envstring;
		}
		/* &env[strlen(env)] is the terminating NULL of the current string,
		 * so one past that should be start of next string
		 */
		env = &env[strlen(env)+1];
	}
	return NULL;
}

int add_env(string)
	char *string;

{
	char *env_copy, *new, *index();
	char *old = environment;
	char *name_end,*new_name_end;
	int added = 0;
	int namelen;

	if (NULL == (env_copy = new = calloc((unsigned)1,(unsigned)ENVSIZE)))
	{
		write(2,enverr,strlen(enverr));
		return -1;
	}

	while (*old)
	{
		if ( NULL == (name_end = index(old,'=')) || 
			NULL == (new_name_end = index(string,'=')) 
		)
		{
			write(2,enverr2,strlen(enverr2));
			free(env_copy);
			return -1;
		}
		namelen = (int)(name_end - old);
		if (0 == strncmp(old,string,namelen))
		{
			if (new_name_end[1])
			{
				/* if we don't have a string of the form name= */
				/* copy new string instead of old string */
				strcpy(new,string);
			}
			else
			/* if we have a set name= with no string then we want
			   to remove the string from the environment
			 */
				;
			added++;
		}
		else
		{
			strcpy(new,old);
		}
		new = &new[strlen(new)+1];
		old = &old[strlen(old)+1];
		if (new >= envlimit(new))
		{
			write(2,enverr,strlen(enverr));
			free(env_copy);
			return -1;
		}
	}
	if (!added)
	{
		strcpy(new,string);
	}
	new = &new[strlen(new)+1];
	/* copy the copy back to the environment */
	movmem(env_copy,environment,(unsigned)(new-env_copy)+2);
	free(env_copy);
	return 0;
}
