#
# Makefile for Borland C++ 3.1 for kernel.exe
#
# $Header:   D:/dos-c/src/kernel/kernel.mav   1.0   02 Jul 1995  8:30:22   patv  $
#
# $Log:   D:/dos-c/src/kernel/kernel.mav  $
#
#   Rev 1.0   02 Jul 1995  8:30:22   patv
#Initial revision.
#

RELEASE = 1.00

.AUTODEPEND

#
# Compiler and Options for Borland C++
# ------------------------------------
CC = bcc +kernel.cfg
ASM = TASM
LIB = TLIB
LINK = TLINK
LIBPATH = .
INCLUDEPATH = ..\HDR
CFLAGS		= -v -X -I. -D__STDC__=0 -DDEBUG -DKERNEL -DI86 -DPROTO -DSHWR -DASMSUPT
AFLAGS		= /Mx/Zi/DSTANDALONE=1
LIBS		=..\..\LIB\DEVICE.LIB ..\..\LIB\LIBM.LIB

# where to copy source from
FSSRC = \
  ..\fs\fatfs.c \
  ..\fs\fatdir.c \
  ..\fs\fattab.c \
  ..\fs\dosfns.c \
  ..\fs\fcbfns.c \
  ..\fs\error.c
SUPTSRC = \
  ..\fs\prf.c \
  ..\fs\misc.c \
  ..\fs\dosnames.c \
  ..\fs\syspack.c
IOSRC = \
  ..\fs\blockio.c \
  ..\fs\chario.c

# what to delete when cleaning
COPIEDSRCA = \
  fatfs.c \
  fatdir.c \
  fattab.c \
  dosfns.c \
  fcbfns.c
COPIEDSRCB = \
  error.c \
  prf.c \
  misc.c \
  dosnames.c \
  syspack.c \
  blockio.c \
  chario.c

#		*Implicit Rules*
.c.obj:
  $(CC) -c {$< }

.cpp.obj:
  $(CC) -c {$< }

#		*List Macros*


EXE_dependencies =  \
 kernel.obj \
 blockio.obj \
 chario.obj \
 dosfns.obj \
 dsk.obj \
 error.obj \
 fatdir.obj \
 fatfs.obj \
 fattab.obj \
 fcbfns.obj \
 initoem.obj \
 inthndlr.obj \
 ioctl.obj \
 main.obj \
 memmgr.obj \
 misc.obj \
 dosnames.obj \
 prf.obj \
 strings.obj \
 sysclk.obj \
 syscon.obj \
 syspack.obj \
 systime.obj \
 task.obj \
 apisupt.obj \
 asmsupt.obj \
 execrh.obj \
 procsupt.obj \
 stacks.obj

#		*Explicit Rules*
all:		production

production:	populate kernel.exe
		tdstrip kernel.exe
		copy kernel.exe ..\..\dist
		del *.obj
		del kernel.exe

populate:	$(FSSRC) $(SUPTSRC) $(IOSRC)
		release $(RELEASE)
		..\utils\pop $(FSSRC)
		..\utils\pop $(SUPTSRC)
		..\utils\pop $(IOSRC)

clobber:	clean
		del kernel.exe

clean:
		..\utils\rmfiles $(COPIEDSRCA)
		..\utils\rmfiles $(COPIEDSRCB)
		del *.obj
		del *.bak
		del *.crf
		del *.xrf
		del *.map
		del *.lst
		del *.las

kernel.exe: kernel.cfg $(EXE_dependencies)
  $(LINK) /m/v/c/P-/L$(LIBPATH) @&&|
kernel.obj+
blockio.obj+
chario.obj+
dosfns.obj+
dsk.obj+
error.obj+
fatdir.obj+
fatfs.obj+
fattab.obj+
fcbfns.obj+
initoem.obj+
inthndlr.obj+
ioctl.obj+
main.obj+
memmgr.obj+
misc.obj+
dosnames.obj+
prf.obj+
strings.obj+
sysclk.obj+
syscon.obj+
syspack.obj+
systime.obj+
task.obj+
apisupt.obj+
asmsupt.obj+
execrh.obj+
procsupt.obj+
stacks.obj
kernel		# exe file
kernel		# map file
$(LIBS)
|


#		*Individual File Dependencies*
kernel.obj: kernel.cfg kernel.asm 
	$(ASM) $(AFLAGS) KERNEL.ASM,KERNEL.OBJ

blockio.obj: kernel.cfg blockio.c 

chario.obj: kernel.cfg chario.c 

dosfns.obj: kernel.cfg dosfns.c 

dsk.obj: kernel.cfg dsk.c 

error.obj: kernel.cfg error.c 

fatdir.obj: kernel.cfg fatdir.c 

fatfs.obj: kernel.cfg fatfs.c 

fattab.obj: kernel.cfg fattab.c 

fcbfns.obj: kernel.cfg fcbfns.c 

initoem.obj: kernel.cfg initoem.c 

inthndlr.obj: kernel.cfg inthndlr.c 

ioctl.obj: kernel.cfg ioctl.c 

main.obj: kernel.cfg main.c 

memmgr.obj: kernel.cfg memmgr.c 

misc.obj: kernel.cfg misc.c 

dosnames.obj: kernel.cfg dosnames.c 

prf.obj: kernel.cfg prf.c 

strings.obj: kernel.cfg strings.c 

sysclk.obj: kernel.cfg sysclk.c 

syscon.obj: kernel.cfg syscon.c 

syspack.obj: kernel.cfg syspack.c 

systime.obj: kernel.cfg systime.c 

task.obj: kernel.cfg task.c 

apisupt.obj: kernel.cfg apisupt.asm 
	$(ASM) $(AFLAGS) APISUPT.ASM,APISUPT.OBJ

asmsupt.obj: kernel.cfg asmsupt.asm 
	$(ASM) $(AFLAGS) ASMSUPT.ASM,ASMSUPT.OBJ

execrh.obj: kernel.cfg execrh.asm 
	$(ASM) $(AFLAGS) EXECRH.ASM,EXECRH.OBJ

procsupt.obj: kernel.cfg procsupt.asm 
	$(ASM) $(AFLAGS) PROCSUPT.ASM,PROCSUPT.OBJ

stacks.obj: kernel.cfg stacks.asm 
	$(ASM) $(AFLAGS) STACKS.ASM,STACKS.OBJ


proto.h:	$(CSRC) $(LIBCSRC1) $(LIBCSRC2) $(LIBCSRC3) $(LIBCSRC4)
		echo /* proto.h generated by make */ > proto.h
		echo #undef _P >> proto.h
		..\utils\proto $(CSRC)
		..\utils\proto $(LIBCSRC1)
		..\utils\proto $(LIBCSRC2)
		..\utils\proto $(LIBCSRC3)
		..\utils\proto $(LIBCSRC4)
		echo Don't forget to edit proto.h for version control

#		*Compiler Configuration File*
kernel.cfg: kernel.mak
  copy &&|
$(CFLAGS)
| kernel.cfg


