/*----------------------------------------------------------------------*
 | FONTDEMO.C                                                           |  
 | Demo for setfont8x8() and setstdfont()                               |
 | Fra PC Magazine vol 9 No 8 s.334                                     |
 *----------------------------------------------------------------------*/

#include <conio.h>
#include <dos.h>
#include <stdlib.h>

#define VIDEO_BIOS 0x10

int setfont8x8(int mode);
void setstdfont(int mode);
void main(void);

void main(void)
  {
  int lines, i;
  lines = setfont8x8(C80);		/* Set 43/50 lines mode */
  textattr(WHITE);
  clrscr();
  if ( lines < 43 )			/* If not EGA or VGA */
    {
    textattr(LIGHTRED);
    cprintf("No EGA or VGA present\r\n");
    exit(1);
    }
  window(20, 15, 70, 35);
  textattr( (RED<<4) + WHITE );		/* White on red */
  clrscr();
  for ( i=15; i<=35; i++ )
    cprintf ("\r\n  Line %d", i);
  window(45, 5, 77, lines);
  textattr( (MAGENTA<<4) + YELLOW );	/* Yellow on magenta */
  clrscr();
  for ( i=5; i<=lines; i++ )
    cprintf("\r\n  Line %d", i);
  getch();
  window(1, 1, 80, lines);
  textattr( LIGHTGRAY<<4 );
  clrscr();
  cprintf("\r\n  Whole screen 80x%d display\r\n", lines);
  getch();
  lines = setfont8x8(C40); 		/* Set 40 col 43/50 lines */
  textattr( (BLUE<<4) + LIGHTGREEN );
  clrscr();
  cprintf("\r\n  There is also a 40x%d mode\r\n", lines);
  getch();
  setstdfont(C80);                     	/* Return to standard font */
  clrscr();
  cprintf("\r\n  Just called setstdfont()...back in 80x25\r\n");
  getch();
  exit(0);
  }

/*----------------------------------------------------------------*
 | FUNCTION setfont8x8()                                          |
 | Uses the EGA/VGA 8x8 font to display 43/50 lines text display. |
 | In this case, MCGA behaves like a VGA.                         |
 *----------------------------------------------------------------*/
int setfont8x8(int mode)
  {
  int maxlines, maxcol;
  char vtype, displaytype;

  textmode(mode);			/* Set text mode */
  _AH = 0x0F;                           /* Get video status */
  geninterrupt(VIDEO_BIOS);             /* Call video BIOS */
  maxcol = _AH;                         /* Save # of columns */
  _AX = 0x1A00;                         /* Get video display */
  geninterrupt(VIDEO_BIOS);
  displaytype = _AL;
  vtype = _BL;                          /* Save active display */

  if ( displaytype == 0x1A )            /* If supported, VGA/MCGA */
    {
    switch(vtype)
      {
      case 4: 				/* EGA color */
      case 5:                           /* EGA mono */
	maxlines = 43;
	break;
      case 7:                           /* VGA analog mono */
      case 8:                           /* VGA analog color */
      case 11:                          /* MCGA analog mono */
      case 12:                          /* MCGA analog color */
	maxlines = 50;
	break;
      default:                          /* Something else */
	maxlines = 25;
	break;
      }
    }
  else   				/* Else look for EGA */
    {
    _AH = 0x12;   			/* Get video configuration */
    _BL = 0x10;
    geninterrupt(VIDEO_BIOS);
    if (_BL == 0x10)                    /* EGA not supported */
      maxlines = 25;
    else                                /* EGA bios and card present */
      maxlines = 43;
    }
  if (maxlines > 25)
    {
    _AX = 0x1112;                       /* Set font 8x8 */
    _BL = 0;
    geninterrupt(VIDEO_BIOS);

    _AX = 0x1113; 			/* Use font 8x8 */
    _BX = 0;
    geninterrupt(VIDEO_BIOS);
    }

  *((char *)&directvideo - 8) = maxlines; /* Set max # of lines */
  window(1, 1, maxcol, maxlines);         /* Create logical windows */
  return(maxlines);                       /* Return new # of lines */
  }

/*----------------------------------------------------------*
 | FUNCTION setstdfont()                                    |
 | Reset 80x25 mode by forcing a call to BIOS change mode   |
 *----------------------------------------------------------*/
void setstdfont(int mode)
  {
  if ( mode != LASTMODE )
    _AL = mode;
  else
    {
    _AH = 0x0F;				/* Get video mode */
    geninterrupt(VIDEO_BIOS);
    mode = _AL;                         /* Save mode */
    }

  _AH = 0;                              /* Set video mode */
  geninterrupt(VIDEO_BIOS);

  *((char *)&directvideo - 8) = 25;     /* Reset max lines */
  textmode(mode);                       /* Update Turbo C's variables */
  }
