/*_______________________________________________________________

func-002.c

Function:  This program demonstrates automatic configuration
of the software to match the graphics hardware.

Compatibility:  Supports all graphics adapters and monitors.
The software uses the 640x480 16-color mode if a VGA is
present, the 640x350 16-color mode if an EGA and enhanced
monitor are present, the 640x200 16-color mode if an EGA and
standard monitor are present, and the 320x200 4-color mode
if a CGA or MCGA is present.

Remarks:  This program is intended as a framework upon which
software can be developed.  Refer to the book for further
guidance.

Copyright 1988 Lee Adams and TAB BOOKS Inc.

_________________________________________________________________


I N C L U D E    F I L E S                                       */

#include <dos.h>                       /* supports the BIOS call */
#include <stdio.h>               /* supports the printf function */
#include <graphics.h>            /* supports the graphics functions */
#include <process.h>                /* support for exit function */

/*_______________________________________________________________


D E C L A R A T I O N S                                          */

/*                                      declare global variables */
int C0=0,C1=1,C2=2,C3=3,C4=4,C5=5,       /* color code variables */
C6=6,C7=7,C8=8,C9=9,C10=10,C11=11,
C12=12,C13=13,C14=14,C15=15,mode_flag=0;
float x_res,y_res;      /* screen resolution for mapping routine */
float sx,sy;            /* device-independent screen coordinates */

/*                                    declare global subroutines */
void keyboard(void);void quit_pgm(void);void get_coords(void);
void graphics_setup(void);

/*_______________________________________________________________


M A I N    R O U T I N E                                         */

main(){
graphics_setup();                     /* establish graphics mode */

keyboard();                      /* wait for user to press <Esc> */
quit_pgm();}                       /* end the program gracefully */

/*______________________________________________________________


SUBROUTINE: CHECK THE KEYBOARD BUFFER                            */

void keyboard(void){
union u_type {int a;char b[3];} keystroke;
int get_keystroke(void);           /* declare a local subroutine */
do keystroke.a=get_keystroke();
while (keystroke.b[0]!=27);        /* return if <Esc> is pressed */
}

/* LOCAL SUBROUTINE: RETRIEVE ONE KEYSTROKE                      */

int get_keystroke(void){
union REGS regs;regs.h.ah=0;return int86(0x16,&regs,&regs);}

/*_______________________________________________________________


SUBROUTINE: GRACEFUL EXIT FROM THE PROGRAM                       */

void quit_pgm(void){
cleardevice();restorecrtmode();exit(0);}

/*______________________________________________________________


SUBROUTINE: VGA/EGA/CGA/MCGA compatibility module

This subroutine invokes the highest-resolution graphics mode
which is permitted by the hardware.  The 640x480 16-color mode
is established if a VGA is present.  The 640x350 16-color mode
is established if an EGA is being used with an enhanced color
display monitor or a multiscanning monitor.  The 640x200
16-color mode is established if an EGA is being used with a
standard color monitor.  The 320x200 4-color mode is invoked
if a CGA or MCGA is present.                                     */

void graphics_setup(void){
int graphics_adapter,graphics_mode;
detectgraph(&graphics_adapter,&graphics_mode);
if (graphics_adapter==VGA) goto VGA_mode;              /* if VGA */
if (graphics_mode==EGAHI) goto EGA_ECD_mode;   /* if EGA and ECD */
if (graphics_mode==EGALO) goto EGA_SCD_mode;   /* if EGA and SCD */
if (graphics_adapter==CGA) goto CGA_mode;              /* if CGA */
if (graphics_adapter==MCGA) goto MCGA_mode;           /* if MCGA */
goto abort_message;              /* if no VGA, EGA, CGA, or MCGA */

VGA_mode:                     /* establish 640x480 16-color mode */
graphics_adapter=VGA;graphics_mode=VGAHI;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=480;C0=0;C1=1;C2=2;C3=3;C4=4;C5=5,C6=6;C7=7;
C8=8;C9=9;C10=10;C11=11;C12=12;C13=13;C14=14;C15=15;
mode_flag=1;
setcolor(C7);outtextxy(216,472,"640x480 16-color VGA mode.");
return;

EGA_ECD_mode:                 /* establish 640x350 16-color mode */
graphics_adapter=EGA;graphics_mode=EGAHI;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=350;C0=0;C1=1;C2=2;C3=3;C4=4;C5=5,C6=6;C7=7;
C8=8;C9=9;C10=10;C11=11;C12=12;C13=13;C14=14;C15=15;
mode_flag=2;
setcolor(C7);outtextxy(216,342,"640x350 16-color EGA mode.");
return;

EGA_SCD_mode:                 /* establish 640x200 16-color mode */
graphics_adapter=EGA;graphics_mode=EGALO;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=200;C0=0;C1=1;C2=2;C3=3;C4=4;C5=5,C6=6;C7=7;
C8=8;C9=9;C10=10;C11=11;C12=12;C13=13;C14=14;C15=15;
mode_flag=3;
setcolor(C7);outtextxy(216,192,"640x200 16-color EGA mode.");
return;

CGA_mode:                      /* establish 320x200 4-color mode */
graphics_adapter=CGA;graphics_mode=CGAC3;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=320;y_res=200;C0=0;C1=1;C2=1;C3=1;C4=1;C5=1,C6=1;C7=3;
C8=1;C9=0;C10=1;C11=1;C12=1;C13=2;C14=1;C15=3;
mode_flag=4;
setcolor(C7);outtextxy(64,192,"320x200 4-color CGA mode.");
return;

MCGA_mode:                     /* establish 320x200 4-color mode */
graphics_adapter=MCGA;graphics_mode=MCGAC3;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=320;y_res=200;C0=0;C1=1;C2=1;C3=1;C4=1;C5=1;C6=1;C7=3;
C8=1;C9=0;C10=1;C11=1;C12=1;C13=2;C14=1;C15=3;
mode_flag=4;
setcolor(C7);outtextxy(64,192,"320x200 4-color MCGA mode.");
return;

abort_message:
printf("\n\nUnable to proceed.\n");
printf("Requires VGA, EGA, MCGA, or CGA adapter\n");
printf("   with appropriate monitor.\n");
printf("Please refer to the book.\n\n");
exit(0);
}
/*_______________________________________________________________


SUBROUTINE: coords()

This subroutine accepts sx,sy device-independent display
coordinates and returns sx,sy device-dependent screen
coordinates scaled to fit the 640x480, 640x350, 640x200, or
320x200 screen, depending upon the graphics mode being used.     */

void coords(void){
sx=sx*(x_res/640);sy=sy*(y_res/480);return;}

/*_______________________________________________________________

End of source code                                               */


