/*_______________________________________________________________

tc-015.c

Function:  This program uses the techniques of bitblt
animation to display a simulated analog clock face.

Compatibility:  Supports all graphics adapters and monitors.
The software uses the 640x200 2-color mode.

Remarks:  The animated clock runs at the correct speed on
a 4.77 MHz microprocessor.  If your computer runs faster,
you will be required to add more timing delays by simply
increasing the size of the variable tn in the declarations
section of the source code.

Copyright 1988 Lee Adams and TAB BOOKS Inc.

_________________________________________________________________


I N C L U D E    F I L E S                                       */

#include <stdio.h>               /* supports the printf function */
#include <graphics.h>         /* supports the graphics functions */
#include <process.h>             /* supports the exit() function */
#include <bios.h>            /* supports read of keyboard buffer */
#include <alloc.h>                 /* supports memory allocation */

/*_______________________________________________________________


D E C L A R A T I O N S                                          */

void keyboard(void);void quit_pgm(void);
void notice(float x,float y);void graphics_setup(void);
void draw_face(void);void draw_sec(void);void anim(void);

int t1=1;
int C0=0,C1=1,C2=2,C3=3,C4=4,C5=5,C6=6,C7=7,C8=8,C9=9,C10=10,
C11=11,C12=12,C13=13,C14=14,C15=15,mode_flag=0;
unsigned int t2=1,tn=35408;     /* tn is set for a 4.77 MHz rate */

/*                                    pointers to graphic arrays */
char far *num_array0;char far *num_array1;char far *num_array2;
char far *num_array3;char far *num_array4;char far *num_array5;
char far *num_array6;char far *num_array7;char far *num_array8;
char far *num_array9;
char far *face_array;char far *face_array1;char far *face_array2;
char far *face_array3;char far *face_array4;
char far *gr_array0;char far *gr_array1;char far *gr_array2;
char far *gr_array3;char far *gr_array4;char far *gr_array5;
char far *gr_array6;char far *gr_array7;char far *gr_array8;
char far *gr_array9;char far *gr_array10;char far *gr_array11;
char far *gr_array12;char far *gr_array13;char far *gr_array14;
char far *gr_array15;char far *gr_array16;char far *gr_array17;
char far *gr_array18;char far *gr_array19;char far *gr_array20;
char far *gr_array21;char far *gr_array22;char far *gr_array23;
char far *gr_array24;char far *gr_array25;char far *gr_array26;
char far *gr_array27;char far *gr_array28;char far *gr_array29;
char far *gr_array30;char far *gr_array31;char far *gr_array32;
char far *gr_array33;char far *gr_array34;char far *gr_array35;
char far *gr_array36;char far *gr_array37;char far *gr_array38;
char far *gr_array39;char far *gr_array40;char far *gr_array41;
char far *gr_array42;char far *gr_array43;char far *gr_array44;
char far *gr_array45;char far *gr_array46;char far *gr_array47;
char far *gr_array48;char far *gr_array49;char far *gr_array50;
char far *gr_array51;char far *gr_array52;char far *gr_array53;
char far *gr_array54;char far *gr_array55;char far *gr_array56;
char far *gr_array57;char far *gr_array58;char far *gr_array59;

/*_______________________________________________________________


M A I N    R O U T I N E                                         */

main(){
graphics_setup();                     /* establish graphics mode */
draw_face();                    /* create the generic clock face */
draw_sec();             /* create 60 versions of the second-hand */
anim();                                /* animate the clock face */
quit_pgm();}                       /* end the program gracefully */

/*_______________________________________________________________


SUBROUTINE: animation loop                                       */

void anim(void){
for (t1=1;t1!=2; ){                              /* endless loop */
putimage(320,58,gr_array0,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,58,gr_array1,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,58,gr_array2,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,58,gr_array3,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,58,gr_array4,COPY_PUT);for (t2=1;t2<=tn;t2++);
keyboard();
putimage(320,58,gr_array5,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,58,gr_array6,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,58,gr_array7,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,58,gr_array8,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,58,gr_array9,COPY_PUT);for (t2=1;t2<=tn;t2++);
keyboard();
putimage(320,58,gr_array10,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,58,gr_array11,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,58,gr_array12,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,58,gr_array13,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,58,gr_array14,COPY_PUT);for (t2=1;t2<=tn;t2++);
keyboard();putimage(320,58,face_array1,COPY_PUT);
putimage(320,100,gr_array15,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,100,gr_array16,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,100,gr_array17,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,100,gr_array18,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,100,gr_array19,COPY_PUT);for (t2=1;t2<=tn;t2++);
keyboard();
putimage(320,100,gr_array20,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,100,gr_array21,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,100,gr_array22,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,100,gr_array23,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,100,gr_array24,COPY_PUT);for (t2=1;t2<=tn;t2++);
keyboard();
putimage(320,100,gr_array25,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,100,gr_array26,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,100,gr_array27,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,100,gr_array28,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(320,100,gr_array29,COPY_PUT);for (t2=1;t2<=tn;t2++);
keyboard();putimage(320,100,face_array2,COPY_PUT);
putimage(220,100,gr_array30,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,100,gr_array31,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,100,gr_array32,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,100,gr_array33,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,100,gr_array34,COPY_PUT);for (t2=1;t2<=tn;t2++);
keyboard();
putimage(220,100,gr_array35,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,100,gr_array36,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,100,gr_array37,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,100,gr_array38,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,100,gr_array39,COPY_PUT);for (t2=1;t2<=tn;t2++);
keyboard();
putimage(220,100,gr_array40,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,100,gr_array41,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,100,gr_array42,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,100,gr_array43,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,100,gr_array44,COPY_PUT);for (t2=1;t2<=tn;t2++);
keyboard();putimage(220,100,face_array3,COPY_PUT);
putimage(220,58,gr_array45,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,58,gr_array46,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,58,gr_array47,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,58,gr_array48,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,58,gr_array49,COPY_PUT);for (t2=1;t2<=tn;t2++);
keyboard();
putimage(220,58,gr_array50,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,58,gr_array51,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,58,gr_array52,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,58,gr_array53,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,58,gr_array54,COPY_PUT);for (t2=1;t2<=tn;t2++);
keyboard();
putimage(220,58,gr_array55,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,58,gr_array56,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,58,gr_array57,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,58,gr_array58,COPY_PUT);for (t2=1;t2<=tn;t2++);
putimage(220,58,gr_array59,COPY_PUT);for (t2=1;t2<=tn;t2++);
keyboard();putimage(220,58,face_array4,COPY_PUT);
};
return;}

/*_______________________________________________________________


SUBROUTINE: create the clock face                                */

void draw_face(void){

setcolor(C7);moveto(0,0);outtext("0123456789");
num_array0=(char far *)farmalloc((unsigned long)imagesize(0,0,7,7));
getimage(0,0,7,7,num_array0);
num_array1=(char far *)farmalloc((unsigned long)imagesize(8,0,15,7));
getimage(8,0,15,7,num_array1);
num_array2=(char far *)farmalloc((unsigned long)imagesize(16,0,23,7));
getimage(16,0,23,7,num_array2);
num_array3=(char far *)farmalloc((unsigned long)imagesize(24,0,31,7));
getimage(24,0,31,7,num_array3);
num_array4=(char far *)farmalloc((unsigned long)imagesize(32,0,39,7));
getimage(32,0,39,7,num_array4);
num_array5=(char far *)farmalloc((unsigned long)imagesize(40,0,47,7));
getimage(40,0,47,7,num_array5);
num_array6=(char far *)farmalloc((unsigned long)imagesize(48,0,55,7));
getimage(48,0,55,7,num_array6);
num_array7=(char far *)farmalloc((unsigned long)imagesize(56,0,63,7));
getimage(56,0,63,7,num_array7);
num_array8=(char far *)farmalloc((unsigned long)imagesize(64,0,71,7));
getimage(64,0,71,7,num_array8);
num_array9=(char far *)farmalloc((unsigned long)imagesize(72,0,79,7));
getimage(72,0,79,7,num_array9);
setfillstyle(SOLID_FILL,C0);bar(0,0,88,8);

circle(320,100,132);                          /* draw the circle */

/*                                 create hour-hand, minute-hand */
setfillstyle(SOLID_FILL,C7);
moveto(264,86);lineto(272,85);lineto(322,98);
lineto(319,102);lineto(266,88);lineto(264,86);
lineto(264,86);floodfill(300,95,C1);
moveto(316,99);lineto(379,71);lineto(385,71);
lineto(384,74);lineto(320,102);lineto(316,99);
lineto(316,99);floodfill(360,82,C1);

/*                           install alphanumerics on clock face */
putimage(370,55,num_array1,OR_PUT);putimage(407,73,num_array2,OR_PUT);
putimage(420,97,num_array3,OR_PUT);putimage(405,120,num_array4,OR_PUT);
putimage(370,138,num_array5,OR_PUT);putimage(318,144,num_array6,OR_PUT);
putimage(266,138,num_array7,OR_PUT);putimage(226,120,num_array8,OR_PUT);
putimage(210,97,num_array9,OR_PUT);putimage(222,73,num_array1,OR_PUT);
putimage(230,73,num_array0,OR_PUT);putimage(260,56,num_array1,OR_PUT);
putimage(268,56,num_array1,OR_PUT);putimage(312,49,num_array1,OR_PUT);
putimage(320,49,num_array2,OR_PUT);notice(5,193);

/*     save quarters of clock face for clean-up during animation */
face_array=(char far *)farmalloc((unsigned long)imagesize(202,46,438,154));
getimage(202,46,438,154,face_array);
face_array1=(char far *)farmalloc((unsigned long)imagesize(320,58,420,100));
getimage(320,58,420,100,face_array1);
face_array2=(char far *)farmalloc((unsigned long)imagesize(320,100,420,143));
getimage(320,100,420,143,face_array2);
face_array3=(char far *)farmalloc((unsigned long)imagesize(220,100,320,143));
getimage(220,100,320,143,face_array3);
face_array4=(char far *)farmalloc((unsigned long)imagesize(220,58,320,100));
getimage(220,58,320,100,face_array4);

return;}

/*_______________________________________________________________


SUBROUTINE: create 60 versions of the second-hand                */

void draw_sec(void){

moveto(320,100);lineto(320,58);
gr_array0=(char far *)farmalloc((unsigned long)imagesize(320,58,420,100));
getimage(320,58,420,100,gr_array0);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(329,58);
gr_array1=(char far *)farmalloc((unsigned long)imagesize(320,58,420,100));
getimage(320,58,420,100,gr_array1);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(340,59);
gr_array2=(char far *)farmalloc((unsigned long)imagesize(320,58,420,100));
getimage(320,58,420,100,gr_array2);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(348,60);
gr_array3=(char far *)farmalloc((unsigned long)imagesize(320,58,420,100));
getimage(320,58,420,100,gr_array3);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(358,62);
gr_array4=(char far *)farmalloc((unsigned long)imagesize(320,58,420,100));
getimage(320,58,420,100,gr_array4);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(367,63);
gr_array5=(char far *)farmalloc((unsigned long)imagesize(320,58,420,100));
getimage(320,58,420,100,gr_array5);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(375,66);
gr_array6=(char far *)farmalloc((unsigned long)imagesize(320,58,420,100));
getimage(320,58,420,100,gr_array6);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(381,69);
gr_array7=(char far *)farmalloc((unsigned long)imagesize(320,58,420,100));
getimage(320,58,420,100,gr_array7);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(388,72);
gr_array8=(char far *)farmalloc((unsigned long)imagesize(320,58,420,100));
getimage(320,58,420,100,gr_array8);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(395,75);
gr_array9=(char far *)farmalloc((unsigned long)imagesize(320,58,420,100));
getimage(320,58,420,100,gr_array9);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(400,79);
gr_array10=(char far *)farmalloc((unsigned long)imagesize(320,58,420,100));
getimage(320,58,420,100,gr_array10);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(405,83);
gr_array11=(char far *)farmalloc((unsigned long)imagesize(320,58,420,100));
getimage(320,58,420,100,gr_array11);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(409,87);
gr_array12=(char far *)farmalloc((unsigned long)imagesize(320,58,420,100));
getimage(320,58,420,100,gr_array12);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(411,92);
gr_array13=(char far *)farmalloc((unsigned long)imagesize(320,58,420,100));
getimage(320,58,420,100,gr_array13);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(412,96);
gr_array14=(char far *)farmalloc((unsigned long)imagesize(320,58,420,100));
getimage(320,58,420,100,gr_array14);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(413,100);
gr_array15=(char far *)farmalloc((unsigned long)imagesize(320,100,420,143));
getimage(320,100,420,143,gr_array15);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(412,104);
gr_array16=(char far *)farmalloc((unsigned long)imagesize(320,100,420,143));
getimage(320,100,420,143,gr_array16);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(411,109);
gr_array17=(char far *)farmalloc((unsigned long)imagesize(320,100,420,143));
getimage(320,100,420,143,gr_array17);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(409,114);
gr_array18=(char far *)farmalloc((unsigned long)imagesize(320,100,420,143));
getimage(320,100,420,143,gr_array18);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(405,117);
gr_array19=(char far *)farmalloc((unsigned long)imagesize(320,100,420,143));
getimage(320,100,420,143,gr_array19);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(400,121);
gr_array20=(char far *)farmalloc((unsigned long)imagesize(320,100,420,143));
getimage(320,100,420,143,gr_array20);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(395,125);
gr_array21=(char far *)farmalloc((unsigned long)imagesize(320,100,420,143));
getimage(320,100,420,143,gr_array21);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(388,128);
gr_array22=(char far *)farmalloc((unsigned long)imagesize(320,100,420,143));
getimage(320,100,420,143,gr_array22);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(381,132);
gr_array23=(char far *)farmalloc((unsigned long)imagesize(320,100,420,143));
getimage(320,100,420,143,gr_array23);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(375,134);
gr_array24=(char far *)farmalloc((unsigned long)imagesize(320,100,420,143));
getimage(320,100,420,143,gr_array24);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(367,136);
gr_array25=(char far *)farmalloc((unsigned long)imagesize(320,100,420,143));
getimage(320,100,420,143,gr_array25);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(358,138);
gr_array26=(char far *)farmalloc((unsigned long)imagesize(320,100,420,143));
getimage(320,100,420,143,gr_array26);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(348,140);
gr_array27=(char far *)farmalloc((unsigned long)imagesize(320,100,420,143));
getimage(320,100,420,143,gr_array27);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(340,142);
gr_array28=(char far *)farmalloc((unsigned long)imagesize(320,100,420,143));
getimage(320,100,420,143,gr_array28);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(329,143);
gr_array29=(char far *)farmalloc((unsigned long)imagesize(320,100,420,143));
getimage(320,100,420,143,gr_array29);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(320,143);
gr_array30=(char far *)farmalloc((unsigned long)imagesize(220,100,320,143));
getimage(220,100,320,143,gr_array30);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(310,143);
gr_array31=(char far *)farmalloc((unsigned long)imagesize(220,100,320,143));
getimage(220,100,320,143,gr_array31);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(300,142);
gr_array32=(char far *)farmalloc((unsigned long)imagesize(220,100,320,143));
getimage(220,100,320,143,gr_array32);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(290,140);
gr_array33=(char far *)farmalloc((unsigned long)imagesize(220,100,320,143));
getimage(220,100,320,143,gr_array33);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(281,138);
gr_array34=(char far *)farmalloc((unsigned long)imagesize(220,100,320,143));
getimage(220,100,320,143,gr_array34);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(273,136);
gr_array35=(char far *)farmalloc((unsigned long)imagesize(220,100,320,143));
getimage(220,100,320,143,gr_array35);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(266,134);
gr_array36=(char far *)farmalloc((unsigned long)imagesize(220,100,320,143));
getimage(220,100,320,143,gr_array36);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(258,132);
gr_array37=(char far *)farmalloc((unsigned long)imagesize(220,100,320,143));
getimage(220,100,320,143,gr_array37);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(250,128);
gr_array38=(char far *)farmalloc((unsigned long)imagesize(220,100,320,143));
getimage(220,100,320,143,gr_array38);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(245,125);
gr_array39=(char far *)farmalloc((unsigned long)imagesize(220,100,320,143));
getimage(220,100,320,143,gr_array39);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(240,121);
gr_array40=(char far *)farmalloc((unsigned long)imagesize(220,100,320,143));
getimage(220,100,320,143,gr_array40);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(235,117);
gr_array41=(char far *)farmalloc((unsigned long)imagesize(220,100,320,143));
getimage(220,100,320,143,gr_array41);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(231,114);
gr_array42=(char far *)farmalloc((unsigned long)imagesize(220,100,320,143));
getimage(220,100,320,143,gr_array42);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(229,110);
gr_array43=(char far *)farmalloc((unsigned long)imagesize(220,100,320,143));
getimage(220,100,320,143,gr_array43);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(227,104);
gr_array44=(char far *)farmalloc((unsigned long)imagesize(220,100,320,143));
getimage(220,100,320,143,gr_array44);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(226,100);
gr_array45=(char far *)farmalloc((unsigned long)imagesize(220,58,320,100));
getimage(220,58,320,100,gr_array45);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(227,96);
gr_array46=(char far *)farmalloc((unsigned long)imagesize(220,58,320,100));
getimage(220,58,320,100,gr_array46);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(229,92);
gr_array47=(char far *)farmalloc((unsigned long)imagesize(220,58,320,100));
getimage(220,58,320,100,gr_array47);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(231,87);
gr_array48=(char far *)farmalloc((unsigned long)imagesize(220,58,320,100));
getimage(220,58,320,100,gr_array48);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(235,83);
gr_array49=(char far *)farmalloc((unsigned long)imagesize(220,58,320,100));
getimage(220,58,320,100,gr_array49);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(240,79);
gr_array50=(char far *)farmalloc((unsigned long)imagesize(220,58,320,100));
getimage(220,58,320,100,gr_array50);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(245,75);
gr_array51=(char far *)farmalloc((unsigned long)imagesize(220,58,320,100));
getimage(220,58,320,100,gr_array51);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(250,72);
gr_array52=(char far *)farmalloc((unsigned long)imagesize(220,58,320,100));
getimage(220,58,320,100,gr_array52);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(258,69);
gr_array53=(char far *)farmalloc((unsigned long)imagesize(220,58,320,100));
getimage(220,58,320,100,gr_array53);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(266,66);
gr_array54=(char far *)farmalloc((unsigned long)imagesize(220,58,320,100));
getimage(220,58,320,100,gr_array54);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(273,63);
gr_array55=(char far *)farmalloc((unsigned long)imagesize(220,58,320,100));
getimage(220,58,320,100,gr_array55);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(281,62);
gr_array56=(char far *)farmalloc((unsigned long)imagesize(220,58,320,100));
getimage(220,58,320,100,gr_array56);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(290,60);
gr_array57=(char far *)farmalloc((unsigned long)imagesize(220,58,320,100));
getimage(220,58,320,100,gr_array57);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(300,59);
gr_array58=(char far *)farmalloc((unsigned long)imagesize(220,58,320,100));
getimage(220,58,320,100,gr_array58);putimage(202,46,face_array,COPY_PUT);
moveto(320,100);lineto(310,58);
gr_array59=(char far *)farmalloc((unsigned long)imagesize(220,58,320,100));
getimage(220,58,320,100,gr_array59);putimage(202,46,face_array,COPY_PUT);

return;}

/*_______________________________________________________________


SUBROUTINE: press any key to quit                                */

void keyboard(void){
if (bioskey(1)==0) return; else quit_pgm();}

/*_______________________________________________________________


SUBROUTINE: GRACEFUL EXIT FROM THE PROGRAM                       */

void quit_pgm(void){
cleardevice();restorecrtmode();exit(0);}

/*______________________________________________________________


SUBROUTINE: VGA/EGA/CGA/MCGA compatibility module                */

void graphics_setup(void){
int graphics_adapter,graphics_mode;
detectgraph(&graphics_adapter,&graphics_mode);
if (graphics_adapter==VGA) goto CGA_mode;              /* if VGA */
if (graphics_mode==EGAHI) goto CGA_mode;       /* if EGA and ECD */
if (graphics_mode==EGALO) goto CGA_mode;       /* if EGA and SCD */
if (graphics_adapter==CGA) goto CGA_mode;              /* if CGA */
if (graphics_adapter==MCGA) goto CGA_mode;            /* if MCGA */
goto abort_message;              /* if no VGA, EGA, CGA, or MCGA */

CGA_mode:                      /* establish 640x200 2-color mode */
graphics_adapter=CGA;graphics_mode=CGAHI;
initgraph(&graphics_adapter,&graphics_mode,"");
C0=0;C1=1;C2=1;C3=1;C4=1;C5=1,C6=1;C7=1;
C8=1;C9=1;C10=1;C11=1;C12=1;C13=1;C14=1;C15=1;
mode_flag=4;setcolor(C7);
outtextxy(184,0,"USING C FOR HIGH SPEED ANIMATION");
outtextxy(232,192,"Press any key to quit...");
outtextxy(168,176,"640x200 2-color VGA, EGA, CGA, and MCGA mode");
outtextxy(176,16,"Bitblt animation of a clock face...");
return;

abort_message:
printf("\n\nUnable to proceed.\n");
printf("Requires VGA, EGA, MCGA, or CGA adapter\n");
printf("   with appropriate monitor.\n");
printf("Please refer to the book.\n\n");
exit(0);
}
/*_______________________________________________________________


SUBROUTINE: Copyright Notice

This subroutine displays the standard copyright notice.
If you are typing in this program from the book you can
safely omit this subroutine, provided that you also remove
the instruction "notice()" from the main routine.                */

int copyright[][3]={0x7c00,0x0000,0x0000,0x8231,
0x819c,0x645e,0xba4a,0x4252,0x96d0,0xa231,0x8252,0x955e,0xba4a,
0x43d2,0xf442,0x8231,0x825c,0x945e,0x7c00,0x0000,0x0000};

void notice(float x, float y){
int a,b,c; int t1=0;
for (t1=0;t1<=6;t1++){a=copyright[t1][0];b=copyright[t1][1];
c=copyright[t1][2];
setlinestyle(USERBIT_LINE,a,NORM_WIDTH);
moveto(x,y);lineto(x+15,y);
setlinestyle(USERBIT_LINE,b,NORM_WIDTH);
moveto(x+16,y);lineto(x+31,y);
setlinestyle(USERBIT_LINE,c,NORM_WIDTH);
moveto(x+32,y);lineto(x+47,y);y=y+1;};
setlinestyle(USERBIT_LINE,0xFFFF,NORM_WIDTH);
return;}

/*_______________________________________________________________

End of source code                                               */

