/******************************************************************************
* Cagd_mat.c - General matrix routines used by all modules of CAGD_lib.	      *
*******************************************************************************
* Written by Gershon Elber, Mar. 90.					      *
******************************************************************************/

#include "cagd_loc.h"

/******************************************************************************
* Vector - Matrix multiplication. It is assumed SrcVec != DstVec and both are *
* in homogeneous coordinates (i.e. vectore of length four).		      *
******************************************************************************/
void CagdMultMatVec(CagdMatStruct *Mat, CagdRType *SrcVec, CagdRType *DstVec)
{
    int i, j;

    for (i = 0; i < 4; i++) {
	DstVec[i] = 0;
        for (j = 0; j < 4; j++) DstVec[i] += Mat -> Mat[j][i] * SrcVec[j];
    }
}
