/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* Module to handle the windows used by the solid modeller.		     *
*****************************************************************************/

#ifdef __MSDOS__
#include <alloc.h>
#include <conio.h>
#include <dos.h>
#endif /* __MSDOS__ */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "program.h"
#include "graphgen.h"
#include "viewobj.h"
#include "windows.h"

#define IRIT_PROMPT	"Irit> "

#ifdef __MSDOS__

/* Set it to FALSE if the status window is used for other purpose (such as */
/* for interactive transformation (INTERACT command)).			   */
static int UpdateStatusWindow = TRUE;

#endif /* __MSDOS__ */

/*****************************************************************************
*  Routine to toggle the input window log file printing. If turned on, test  *
* is made if file has been opened and if not open it.			     *
*****************************************************************************/
void WndwLogPrint(RealType *Set)
{
    char s[LINE_LEN];

    if (APX_EQ(*Set, 0.0)) {
	GlblPrintLogFile = FALSE;
	fflush(GlblLogFile);
	return;
    }

    if (GlblLogFile == NULL) {		      /* Not open yet - open it now: */
	if ((GlblLogFile = fopen(GlblLogFileName, "w")) == NULL) {
	    sprintf(s, "Failed to open log file \"%s\"", GlblLogFileName);
	    WndwInputWindowPutStr(s);
	    return;
	}
	GlblPrintLogFile = TRUE;
    }
}

/*****************************************************************************
*  Routine to wait for user keystroke while drawing blinking cursor:	     *
* No data is returned - used as pause only.				     *
*****************************************************************************/
void WndwPause(RealType *R)
{
#ifdef __MSDOS__
    if (!APX_EQ(*R, 0.0)) while (kbhit()) getch();	     /* Flush stdin. */
    WndwInputWindowPutStr("Type return to continue:");
    getch();
#else
#ifdef DJGCC
    if (!APX_EQ(*R, 0.0)) while (kbhit()) getkey();	     /* Flush stdin. */
    WndwInputWindowPutStr("Type return to continue:");
    getkey();
#else
    fprintf(stderr, "Type return to continue:");
    getchar();
#endif /* DJGCC */
#endif /* __MSDOS__ */
}

/*****************************************************************************
*  Routine to handle the text on the Input Window. This window echoes all    *
* the input steam - the input parser input. Errors or information is also    *
* displayed in this window.						     *
*****************************************************************************/
void WndwInputWindowPutStr(char *Msg)
{
    char c, str[LINE_LEN_LONG];
    int i;

    for (i = 0; *Msg != 0; Msg++) {
	if (*Msg == 0x09)
	    do {
		str[i++] = ' ';
	    }
	    while (i % 8 != 0);
	else if (*Msg < ' ' || *Msg > '~')
	    break;
	else
	    str[i++] = *Msg;
    }
    str[i] = 0;

    if (GlblPrintLogFile) fprintf(GlblLogFile, "%s\n", str);

#if defined(__MSDOS__) || defined(DJGCC)
    if (GlblDoGraphics) {
#ifdef __MSDOS__
	if (kbhit())		    /* Test and handle Control S/Q protocol. */
	    if ((c = getch()) == '\x13')		    /* Its Ctrl - s. */
		while (getch() != '\x11');	       /* Wait for Ctrl - q. */
	    else
		ungetch(c);
#endif /* __MSDOS__ */

	IntrPrintf(InputWindowID, TRUE, str);
    }
    else {
	printf("%s\n", str);
    }
#else
    printf("%s\n", str);
#endif /* __MSDOS__ || DJGCC */
}

/*****************************************************************************
*  Routine to handle reading one line from stdin into string Str, with max.  *
* length Length in the Input Window.					     *
*  Note Str may be non empty and can be used to fix wrong entry.	     *
*****************************************************************************/
void WndwInputWindowGetStr(char *Str, int Length)
{
#ifdef __MSDOS__
    if (GlblDoGraphics) {
	Str[0] = 0;
    	IntrGetLineWindow(InputWindowID, Str, Length);
    }
    else {
	int i;
	char TLine[LINE_LEN_LONG];
	union REGS regs;
	struct SREGS sregs;

    	printf(IRIT_PROMPT);

	TLine[0] = LINE_LEN_LONG - 2;
	regs.x.dx = FP_OFF(TLine);
	sregs.ds = FP_SEG(TLine);
	regs.h.ah = 0x0a;
	intdosx(&regs, &regs, &sregs);
	printf("\n");

    	if (feof(stdin)) MyExit(0);/* Eof typed on keyboard (usually CtrlD). */
	for (i = TLine[1] + 2; i > 1; i--)
    	    if (TLine[i] <= ' ') TLine[i] = 0;
	strncpy(Str, &TLine[2], Length - 1);
    }
#else
#ifdef DJGCC
    if (GlblDoGraphics) {
	Str[0] = 0;
    	IntrGetLineWindow(InputWindowID, Str, Length);
    }
    else {
	printf(IRIT_PROMPT);
	fgets(Str, Length - 1, stdin);
	if (feof(stdin)) MyExit(0);/* Eof typed on keyboard (usually CtrlD). */
	if (Str[strlen(Str) - 1] < ' ') Str[strlen(Str) - 1] = 0;/* No CR/LF.*/
	puts(Str);
    } 
#else
    printf(IRIT_PROMPT);
    fgets(Str, Length - 1, stdin);
    if (feof(stdin)) MyExit(0);    /* Eof typed on keyboard (usually CtrlD). */
    if (Str[strlen(Str) - 1] < ' ') Str[strlen(Str) - 1] = 0;   /* No CR/LF. */
    puts(Str);
#endif /* DJGCC */
#endif /* __MSDOS__ */
}

#ifdef __MSDOS__

/*****************************************************************************
*  Routine to claim/reclaim control on the status window, so that it would   *
* not be updated. Used by other modules to display data on the status window *
* temporary, such as the INTERACT command - objects transformations.	     *
*****************************************************************************/
void WndwClaimStatus(void)
{
    UpdateStatusWindow = FALSE;
}

void WndwReclaimStatus(void)
{
    UpdateStatusWindow = TRUE;
}

/*****************************************************************************
*  Routine to handle the status window dynamic update - only reprint new.    *
*****************************************************************************/
void WndwStatusWindowUpdate(void)
{
    static char *AdvanceChar = "-\\|/";
    static int AdvanceCount = 0;
    static char CoreLine[11] = { 0 };

    if (!UpdateStatusWindow || !GlblDoGraphics) return;

    GRPushViewPort();
    if (!IntrWndwIsAllVisible(StatusWindowID))
	IntrWndwPop(StatusWindowID, TRUE, TRUE);
    else
	IntrWndwPop(StatusWindowID, FALSE, FALSE);
    
    GRPushTextSetting();
    GRSetTextJustify(CENTER_TEXT, CENTER_TEXT);	   /* Draw strings centered. */

    GGMySetColor(BLACK);			       /* Erase old version. */
    IntrWndwRText(0.0, 0.6, CoreLine);

    /* Preper the new data to display: */
    AdvanceCount = (AdvanceCount + 1) & 0x03;
    sprintf(CoreLine, "%c %3dk %c",
	AdvanceChar[AdvanceCount],
	(int) (coreleft()/1024L),
	AdvanceChar[AdvanceCount]);

    GGMySetColor(MAGENTA);			        /* Draw old version. */
    IntrWndwRText(0.0, 0.6, CoreLine);

    GRPopTextSetting();

    GRPopViewPort();
}

#endif /* __MSDOS__ */

/*****************************************************************************
*  Routine to handle the view on the View Window. This routine displays      *
* object(s) and prints its/their name also.				     *
* If ClearWindow is not zero then the window is cleared first.		     *
*****************************************************************************/
void WndwViewGeomObject(ObjectStruct *PObjList, RealType *ClearWindow)
{
    if (!GlblDoGraphics) return;

    if (!APX_EQ(*ClearWindow, 0.0)) {
	GGClearViewArea();
    }
    else {
	/* On SGI 4D with double buffer we want to draw on current window,   */
	/* so it is swap temporarily as a back plane and will be swapped     */
	/* back as front visible one after the drawing is complete.          */
#if defined(__MSDOS__) || defined(DJGCC)
    IntrWndwPop(ViewWindowID, FALSE, TRUE);
#else
	GGGraphicFlush();
#endif /* __MSDOS__ || DJGCC */
    }

    ViewGeomObject(PObjList);			  /* And finally display it. */

#if !defined(__MSDOS__) && !defined(DJGCC)
    GGGraphicFlush();
#endif /* !__MSDOS__ && !DJGCC */
}
