/*****************************************************************************
* Definitions, visible to others, of Priority Queue module:		     *
*****************************************************************************/

#ifndef PRIOR_Q_GH
#define PRIOR_Q_GH

typedef struct PriorQue {
    struct PriorQue *Right, *Left;	/* Pointers to two sons of this node. */
    VoidPtr Data;			      /* Pointers to the data itself. */
} PriorQue;

typedef int (*PQCompFuncType)(VoidPtr, VoidPtr);      /* Comparison function. */

/* And global function prototypes: */
void PQInit(PriorQue **PQ);
int PQEmpty(PriorQue *PQ);
void PQCompFunc(PQCompFuncType NewCompFunc);
VoidPtr PQFirst(PriorQue **PQ, int Delete);
VoidPtr PQInsert(PriorQue **PQ, VoidPtr NewItem);
VoidPtr PQDelete(PriorQue **PQ, VoidPtr NewItem);
VoidPtr PQFind(PriorQue *PQ, VoidPtr OldItem);
VoidPtr PQNext(PriorQue *PQ, VoidPtr CmpItem, VoidPtr BiggerThan);
void PQPrint(PriorQue *PQ, void (*PrintFunc)());
void PQFree(PriorQue *PQ, int FreeItems);
void PQFreeFunc(PriorQue *PQ, void (*FreeFunc)());

#endif /* PRIOR_Q_GH */
