#ifndef __LL_KBD_H__
#define __LL_KBD_H__

#ifndef CEXT
#ifdef  __cplusplus
#define CEXT    extern "C"
#else   // C
#define CEXT	extern
#endif  // C++ check
#endif  // CEXT

CEXT    char    *kbdFLAGS;
CEXT    void    kbdInit();
CEXT    void    kbdReset();
CEXT    char    kbdKeyHit();
CEXT    char    kbdPutKey(char);
CEXT    char    kbdGetKey();
CEXT    char    kbdGetMode();
CEXT    void    kbdSetMode(char);
CEXT    void    kbdSetScrlLight(char);
CEXT    void    kbdSetNumLight(char);
CEXT    void    kbdSetCapLight(char);
CEXT    void    kbdSetRate(char, char);

#pragma aux     kbdPutKey       parm    [ECX]
#pragma aux     kbdSetKey       parm    [EAX]
#pragma aux     kbdSetMode  	parm    [EAX]
#pragma aux     kbdSetScrlLight parm    [EAX]
#pragma aux     kbdSetNumLight  parm    [EAX]
#pragma aux     kbdSetCapLight  parm    [EAX]
#pragma aux     kbdSetRate      parm    [EAX] [EBX]

#define kbdKeyIs(key)       (kbdFLAGS[key] & 0x01)
#define kbdKeyWas(key)      (kbdFLAGS[key] & 0x02)
#define kbdKeySet(key)      (kbdFLAGS[key] |=  0x02)
#define kbdKeyClr(key)      (kbdFLAGS[key] &= ~0x02)
#define kbdKeyReset(key)    {                   \
                            if (kbdKeyIs(key))  \
                                kbdKeySet(key); \
                            else                \
                                kbdKeyClr(key); \
                            }

#define ABSOLUTE    0x00    /* 0000 0000 */
#define CONVERT     0x01    /* 0000 0001 */
#define NOSYSTEM    0x02    /* 0000 0010 */
#define EXTENDED    0xe0    /* Extended 0E0h 2-byte Key */
#define CONTROL     0xf0    /* Control  0F0h 2-byte Key */

/*
** Typematic Rates
*/
                                /* 0xx0 0000 */
#define DEL_14          0x00    /* 0000 0000 */
#define DEL_24          0x20    /* 0010 0000 */
#define DEL_34          0x40    /* 0100 0000 */
#define DEL_44          0x60    /* 0110 0000 */

                            	/* 000x xxxx */
#define CPS_30          0x00    /* 0000 0000 */
#define CPS_24          0x02    /* 0000 0010 */
#define CPS_20          0x04    /* 0000 0100 */
#define CPS_16          0x07    /* 0000 0111 */
#define CPS_15          0x08    /* 0000 1000 */
#define CPS_12          0x0A    /* 0000 1010 */
#define CPS_10          0x0C    /* 0000 1100 */
#define CPS_08          0x0F    /* 0000 1111 */
#define CPS_06          0x12    /* 0001 0010 */
#define CPS_05          0x14    /* 0001 0100 */
#define CPS_04          0x17    /* 0001 1110 */
#define CPS_03          0x1A    /* 0001 1010 */
#define CPS_02          0x1F    /* 0001 1111 */

#ifndef ON
#define ON 1
#define OFF 0
#endif
/*
** Scan Code Definitions . . .
*/
// System Keys
#define _ESC            0x01
#define _BACKSPACE      0x0E
#define _TAB            0x0F

#define _ENTER          0x1C
#define _L_CTRL         0x1D
#define _R_CTRL         0x5A
#define _L_SHIFT        0x2A
#define _R_SHIFT        0x36
#define _L_ALT          0x38
#define _R_ALT          0x5C

#define _SPACE          0x39
#define _CAPS_LOCK      0x3A
#define _NUM_LOCK       0x45
#define _PRNT_SCRN      0x47
#define _SCROLL_LOCK    0x57

// Function Keys
#define _F1             0x3b
#define _F2             0x3c
#define _F3             0x3d
#define _F4             0x3e
#define _F5             0x3f
#define _F6             0x40
#define _F7             0x41
#define _F8             0x42
#define _F9             0x43
#define _F10            0x44
#define _F11            0x57
#define _F12            0x58

// Directional Control Keys
#define _HOME           0x47
#define _UP             0x48
#define _PGUP           0x49
#define _LEFT           0x4b
#define _CENTER         0x4c
#define _RIGHT          0x4d
#define _END            0x4f
#define _DOWN           0x50
#define _PGDN           0x51
#define _INS            0x52
#define _DEL            0x53

// Cluster Directional Control Keys
#define _C_ENTER        0x59
#define _C_HOME         0x5d
#define _C_UP           0x5e
#define _C_PGUP         0x5f
#define _C_LEFT         0x60
#define _C_RIGHT        0x61
#define _C_END          0x62
#define _C_DOWN         0x63
#define _C_PGDN         0x64
#define _C_INS          0x65
#define _C_DEL          0x66


// Alphanumerics
#define _1              0x02
#define _2              0x03
#define _3              0x04
#define _4              0x05
#define _5              0x06
#define _6              0x07
#define _7              0x08
#define _8              0x09
#define _9              0x0A
#define _0              0x0B
#endif
