#pragma inline               /* TCC compiler command used to tell it */
                             /* to use in-line assembly. */
int minit()                  /* Mouse initialazation routine */
{                            /* used to reset mouse driver */
    asm mov ax,0             /* and/or detect presence of */
    asm int 51               /* driver by return value =-1 for no mouse, */
    return (_AX);            /* 0 if mouse is present. */
}

void mshow()                 /* Routine to display mouse cursor. */
{
   asm mov ax,1
   asm int 51
}

void mhide()                 /* Routine to hide mouse cursor. */
{
    asm mov ax,2
    asm int 51
}

void mpos(int x,int y)       /* Routine to position mouse cursor */
{                            /* x is the horizontal position, */
    asm mov ax,4             /* y is the vertical position. */
    asm mov cx,x
    asm mov dx,y
    asm int 51
}

int mx()                     /* Routine that returns the horizontal position. */
{
    asm mov ax,3
    asm int 51
    return(_CX);
}

int my()                     /* Routine that returns the vertical position. */
{
    asm mov ax,3
    asm int 51
    return(_DX);
}

char mb()                    /* Routine to detect mouse button */
{                            /* returns 1 for first button, */
    asm mov ax,3             /* returns 2 for 2nd button, */
    asm int 51               /* 4 for center button(if any), */
    return(_BX);             /* add these numbers together to get the */
}                            /* "chord" value. (button 1 +2= return value 3. */

void limitx(int min,int max) /* Routine to limit the mouse cursor's */
{                            /* horizontal postition. */
    asm mov ax,7
    asm mov cx,min
    asm mov dx,max
    asm int 51
}

void limity(int min,int max) /* Routine to limit mouse cursor's */
{                            /* vertical position. */
    asm mov ax,8
    asm mov cx,min
    asm mov dx,max
    asm int 51
}

void mdef(char def,int attr1,int attr2) /* Routine to define the text cursor, */
{                            /* pass 1 to use the regular blinking */
    asm mov ax,10            /* cursor, or 0 to use a solid, nonblinking */
    asm mov bx,def           /* cursor. The attr? variables define the */
    asm mov cx,attr1
    asm mov dx,attr2
	 asm int 51               /* color, etc. of the cursor */
}
