#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <mem.h>
#include <conio.h>
#include "mpvga.h"

char *ChipList[] = {
  "Unknown",
  "Acer",
  "Ahead",
  "Avance Logic",
  "Alliance",
  "ARK Logic",
  "ATI",
  "Chips & Tech",
  "Cirrus54",
  "Cirrus64",
  "Compaq",
  "HMC",
  "Matrox",
  "MXIC",
  "NCR",
  "Oak",
  "Primus",
  "Realtek",
  "S3",
  "Sierra",
  "SiS",
  "Trident",
  "Tseng",
  "UMC",
  "Video7",
  "Western Digital"
};

char *ChipVerList[] = {
 "Unknown Chip Version",

 "AC_CAT32",
 "AC_CAT64",

 "AH_A",
 "AH_B",

 "ALG_2101",
 "ALG_2201",
 "ALG_2228",
 "ALG_2301",
 "ALG_2302",
 "ALG_2364",

 "ALI_3210",

 "ARK_1000VL",
 "ARK_1000PV",
 "ARK_2000PV",

 "ATI_18800",
 "ATI_18800_1",
 "ATI_28800_2",
 "ATI_28800_4",
 "ATI_28800_5",
 "ATI_28800_6",
 "ATI_GUP_3",
 "ATI_GUP_6",
 "ATI_GUP_AX",
 "ATI_GUP_LX",
 "ATI_M64_GX",
 "ATI_M64_CX",

 "CL_AVGA1",
 "CL_AVGA2",
 "CL_GD5401",
 "CL_GD5402",
 "CL_GD5402r1",
 "CL_GD5420",
 "CL_GD5420r1",
 "CL_GD5422",
 "CL_GD5424",
 "CL_GD5426",
 "CL_GD5428",
 "CL_GD5429",
 "CL_GD5430",
 "CL_GD5434",
 "CL_GD7541",
 "CL_GD7542",
 "CL_GD7543",

 "CL_GD6205",
 "CL_GD6215",
 "CL_GD6225",
 "CL_GD6235",

  "CL_GD5410",
  "CL_GD6410",
  "CL_GD6412",
  "CL_GD6420A",
  "CL_GD6420B",
  "CL_GD6440",

  "CT_451",
  "CT_455",
  "CT_456",
  "CT_457",
  "CT_452",
  "CT_450",
  "CT_453",
  "CT_65520",
  "CT_65530",
  "CT_65510",
  "CT_65535",
  "CT_65540",
  "CT_65545",
  "CT_64200",
  "CT_64300",
  "CT_64310",

  "CPQ_AVPORT",
  "CPQ_IVGS",
  "CPQ_AVGA",
  "CPQ_QV",
  "CPQ_QV1024",
  "CPQ_QV1280",

  "ET_3000",
  "ET_4000",
  "ET_4W32",
  "ET_4W32i_a",
  "ET_4W32i_b",
  "ET_4W32i_c",
  "ET_4W32p_a",
  "ET_4W32p_b",
  "ET_4W32p_c",
  "ET_4W32p_d",

  "HMC_304",
  "HMC_314",

  "IIT_AGX1x",
  "IIT_AGX14",
  "IIT_AGX15",
  "IIT_AGX16",
  "IIT_AGX17",

  "MGA_VGA",
  "MGA_Titan",
  "MGA_Helena",

  "MX_86000",
  "MX_86010",
  "MX_86100",

  "NCR_77c21",
  "NCR_77c22",
  "NCR_77c22e",
  "NCR_77c22ep",
  "NCR_77c32blt",

  "OAK_037",
  "OAK_057",
  "OAK_067",
  "OAK_077",
  "OAK_083",
  "OAK_087",

  "PR_2000",

  "RT_3103",
  "RT_3105",
  "RT_3106",

  "S3_911",
  "S3_924",
  "S3_801AB",
  "S3_805AB",
  "S3_801C",
  "S3_805C",
  "S3_801D",
  "S3_805D",
  "S3_801I",
  "S3_805I",
  "S3_801P",
  "S3_805P",
  "S3_928",
  "S3_928C",
  "S3_928D",
  "S3_928E",
  "S3_928PCI",
  "S3_864",
  "S3_864P",
  "S3_964",
  "S3_732",
  "S3_764",
  "S3_866",
  "S3_868",
  "S3_968",

  "SC_15064",

  "SIS_201",

  "TR_8800BR",
  "TR_8800CS",
  "TR_8900B",
  "TR_8900C",
  "TR_9000",
  "TR_LCD9100B",
  "TR_LX8200",
  "TR_LCD9320",
  "TR_9000i",
  "TR_9000C",
  "TR_8900CL",
  "TR_9200CXr",
  "TR_9400CXi",
  "TR_GUI9420",
  "TR_GUI9430",
  "TR_GUI9440",
  "TR_GUI9660",
  "TR_GUI9680",

  "UMC_408",
  "UMC_418",

  "V7_VEGA",
  "V7_208_13",
  "V7_208A",
  "V7_208B",
  "V7_208CD",
  "V7_216BC",
  "V7_216D",
  "V7_216E",
  "V7_216F",

  "WD_PVGA1A",
  "WD_90c00",
  "WD_90c10",
  "WD_90c11",
  "WD_90c20",
  "WD_90c20A",
  "WD_90c22",
  "WD_90c24",
  "WD_90c26",
  "WD_90c30",
  "WD_90c31",
  "WD_90c33",

  "XGA_org",
  "XGA_NI",

  "VESA_10",
  "VESA_11",
  "VESA_12",
  "VESA_20"
};


int MaxPage;

void ClearScr (char Color)

{
  char *ScrPtr;

  ScrPtr = 0xA0000;
  memset(ScrPtr,Color,64000);

  return;
}

void point (int x, int y, char col)

{
  char *ScrPtr;

  ScrPtr = (char *) (0x0A0000 + ((y * 320) + x));

  *ScrPtr = (char) col;
  return;
}

void Test1 (void)
/* test pattern from VGAKIT 5.2 */

{
  long int x, x2, y;
  char color;
  int maxx = 319;
  int maxy = 199;

  for(x=0;x<maxx/2;x++)	{
    for(y=0;y<maxy/2;y++) {
      x2=(x+1)*(maxx-x);
      color=((x2*x2)/((y+1)*(long)(maxy-y))/113)&0xff;
      point(x,y,color);
      point((maxx-1)-x,y,color);
      point(x,(maxy-1)-y,color);
      point((maxx-1)-x,(maxy-1)-y,color);
     }
  }

  return;
}

void Test2 (void)

{
  int CurrentPage = 0;

  int X = 160;
  int Y = 100;
  int IncX = 1;
  int IncY = 1;


  outp(0x3C8,0);
  outp(0x3C9,0);
  outp(0x3C9,0);
  outp(0x3C9,0);

  outp(0x3C8,15);
  outp(0x3C9,63);
  outp(0x3C9,63);
  outp(0x3C9,63);

  for(;;) {
   MPVGA_SetActivePage(CurrentPage);
   ClearScr(0); /* brute force */

   X = X + IncX;
   Y = Y + IncY;
   if (X == 0) IncX = 1;
   if (Y == 0) IncY = 1;
   if (X == 319-4) IncX = -1;
   if (Y == 199-4) IncY = -1;

   point(X,Y,15);
   point(X+1,Y,15);
   point(X+2,Y,15);

   point(X,Y+1,15);
   point(X+1,Y+1,15);
   point(X+2,Y+1,15);

   point(X,Y+2,15);
   point(X+1,Y+2,15);
   point(X+2,Y+2,15);

   WaitVLB();
   MPVGA_SetVisualPage(CurrentPage);
   CurrentPage++;
   if (CurrentPage == MaxPage) CurrentPage = 0;

   if (kbhit()) return;
  }
}

void WaitVLB (void)

{
  while ((inp(0x03DA) & 8) > 0) ;
  while ((inp(0x03DA) & 8) == 0) ;
  return;
}

void MakePal (void)

{
  int Looper, Val;

  outp(0x3C8,0);
  Val = 63;
  for (Looper = 0; Looper < 64; Looper++) {
    outp(0x3C9,Val);
    outp(0x3C9,Val);
    outp(0x3C9,Val);
    Val--;
  }
  Val = 63;
  for (Looper = 0; Looper < 64; Looper++) {
    outp(0x3C9,0);
    outp(0x3C9,0);
    outp(0x3C9,Val);
    Val--;
  }
  Val = 63;
  for (Looper = 0; Looper < 64; Looper++) {
    outp(0x3C9,0);
    outp(0x3C9,Val);
    outp(0x3C9,0);
    Val--;
  }
  Val = 63;
  for (Looper = 0; Looper < 64; Looper++) {
    outp(0x3C9,Val);
    outp(0x3C9,0);
    outp(0x3C9,0);
    Val--;
  }
  return;
}

void main (void)

{
  union REGS Registers;
  int Looper;
  int Page;
  int Value;

  if (MPVGA_DetectChip() == NotDetected) {
    printf("Cannot determine video chip type !\n");
    return;
  }
  Registers.w.ax = 0x03;
  int386(0x10,&Registers,&Registers);

  MaxPage = MPVGA_VideoRAMSize / 64;

  printf("MPVGA Tiny Test Program Copyright (c) 1995 Lin Ke-Fong, Ethereal Software.\n\n");
  printf("Chip type: %s.\n",ChipList[MPVGA_ChipType]);
  printf("Chip version: %s.\n",ChipVerList[MPVGA_ChipVer]);
  if (MPVGA_VideoRAMSize != -1)
    printf("Video memory size: %dKB.\n",MPVGA_VideoRAMSize);
  else printf("Video memory size: unknown\n");
  if (MPVGA_BiosVRAMSize != -1)
    printf("BIOS reported memory size: %dKB.\n",MPVGA_BiosVRAMSize);
  else printf("BIOS reported memory size: unknown\n");
  printf("Number of graphic page: %d.\n\n",MaxPage);
  printf("Is it correct ? Press 'n' to modify or any other key to continue...\n");
  if (getch() == 'n') {
    printf("Please enter amount of video memory (in KB):\n");
    scanf("%d",&Value);
    MPVGA_VideoRAMSize = Value;
    MaxPage = MPVGA_VideoRAMSize / 64;
  }
  printf("\nMPVGA Tiny Test Program will now do some tests on you graphic card,\n"
	 "it will first draw a test pattern on all the pages available, you should\n"
         "have SizeOfYourVideoRAM/64 pages.\n"
         "Then you will see a bouncing ball, there should be no flickers.\n\n");
  printf("You will do those tests at your own risk ! If you think it's too\n"
         "dangerous, just press Esc to quit now.\n");
  if (getch() == 27) return;

  MPVGA_SetMode();
  MakePal();
  for (Looper = 0; Looper < MaxPage; Looper++) {
    MPVGA_SetActivePage(Looper);
    ClearScr(0);
  }

  for (Looper = 0; Looper < MaxPage; Looper++) {
    MPVGA_SetActivePage(Looper);
    MPVGA_SetVisualPage(Looper);
    Test1();
    getch();
  }

  for (Looper = 0; Looper < MaxPage; Looper++) {
    MPVGA_SetActivePage(Looper);
    ClearScr(0);
  }

  Test2();

/* TEST.C makes my Trident Windows driver bug if I don't do that: */
  MPVGA_SetActivePage(0);
  MPVGA_SetVisualPage(0);

  Registers.w.ax = 0x03;
  int386(0x10,&Registers,&Registers);

  return;
}



