.model small

.data
VideoSeg dw 0A000h

.code
public InitGraph_
public CloseGraph_
public SetPixel_
public GetPixel_
public SetPage_
public ShowPage_

InitGraph_ PROC NEAR
           ;changes: dx,ax,cx,di,es
           push dx
           push ax
           push cx
           push di
           push es

           mov ax,0013h
           int 10h

           ;Im Graphics-Controller das Bit4 im Mode-Register lschen
           mov dx,3CEh
           mov al,05h
           out dx,al
           inc dx
           in  al,dx
           and al,11101111b
           out dx,al

           ;Im Miscellaneous-Register des G-C das Bit1 lschen
           dec dx
           mov al,06h
           out dx,al
           inc dx
           in  al,dx
           and al,11111101b
           out dx,al

           ;Im Memory-Mode-Reg des Sequenzer-Controllers das Bit4 lschen und
           ;das Bit3 setzen
           mov dx,3C4h
           mov al,04h
           out dx,al
           inc dx
           in  al,dx
           and al,11110111b
           or  al,4
           out dx,al

           ;Das Bit6 des Underline-Reg im CRT-Controller lschen
           mov dx,3D4h
           mov al,14h
           out dx,al
           inc dx
           in  al,dx
           and al,10111111b
           out dx,al

           ;Das Bit Bit6 im Mode-Controll-Reg des CRT-Controllers setzen
           dec dx
           mov al,17h
           out dx,al
           inc dx
           in  al,dx
           or  al,01000000b
           out dx,al

           ;Alle Bitplanes lschen
           mov ax,VideoSeg
           mov es,ax
           xor di,di
           mov dx,3C4h
           mov ax,020Fh
           out dx,ax
           mov cx,80*200
           xor al,al
           rep stosb

           pop es
           pop di
           pop cx
           pop ax
           pop dx

           ret
InitGraph_ ENDP

CloseGraph_ PROC NEAR
            ;changes: ax
            push ax
            mov ax,0003h
            int 10h
            pop ax
            ret
CloseGraph_ ENDP

SetPixel_ PROC NEAR
          ;changes: bp,ax,es,bx,di,dx,cx
          push bp
          mov bp,sp
          push ax
          push es
          push bx
          push di
          push dx
          push cx

          ;Offset in bx berechnen
          mov ax,VideoSeg
          mov es,ax
          mov ax,[bp+6]
          mov bx,80
          mul bx
          mov di,[bp+4]
          mov cx,di
          shr di,1
          shr di,1
          add di,ax             ;Offset => di, Segment => es

          ;Bitmaske ausgeben
          mov ah,1
          and cl,3
          shl ah,cl
          mov al,02h
          mov dx,3C4h
          out dx,ax

          ;Punkt ausgeben
          mov al,byte ptr [bp+8]
          stosb

          pop cx
          pop dx
          pop di
          pop bx
          pop es
          pop ax
          pop bp

          ret 6
SetPixel_ ENDP

GetPixel_ PROC NEAR
          ;changes: bp,es,bx,di,cx,dx
          push bp
          mov bp,sp
          push es
          push bx
          push di
          push cx
          push dx

          ;Offset in di berechnen
          mov ax,VideoSeg
          mov es,ax
          mov ax,[bp+6]
          mov bx,80
          mul bx
          mov di,[bp+4]
          mov cx,di
          shr di,1
          shr di,1
          add di,ax     ;Segment => es, Offset => di

          and cl,3
          mov ah,cl
          mov al,4
          mov dx,3CEh
          out dx,ax

          mov al,es:[di]

          pop dx
          pop cx
          pop di
          pop bx
          pop es
          pop bp

          ret 4
GetPixel_ ENDP

SetPage_ PROC NEAR
         ;changes: bp,ax,bx
         push bp
         mov bp,sp
         push ax
         push bx

         mov ax,[bp+4]
         mov bx,1000
         mul bx
         mov VideoSeg,ax
         add VideoSeg,0A000h

         pop bx
         pop ax
         pop bp

         ret 2
SetPage_ ENDP

ShowPage_ PROC NEAR
          ;changes: bp,bx,ax,dx
          push bp
          mov bp,sp
          push bx
          push ax
          push dx

          mov bx,[bp+4]
          mov ax,16000
          mul bx
          mov bx,ax

          mov dx,3D4h
          mov al,0Ch
          mov ah,bh
          out dx,ax
          inc al
          mov ah,bl
          out dx,ax

          pop dx
          pop ax
          pop bx
          pop bp

          ret 2
ShowPage_ ENDP

END