;
;                             MEMBLOCK Free Memory
;
;
; Borland C++ 4.0 for WIN32 prototype:
; void  __pascal mbfree (MEMBLOCK *mb, PTR ptr);
;
; version 0.3
; - White Shadow -
;
.386p
Ideal
include "bmmalloc.inc"

Public MBFREE


;
Segment _TEXT byte public use32 'CODE'
Assume  cs:_TEXT, ds:DGROUP


; -- argument stack offsets
arg1 = 4                ; -> MEMBLOCK
arg2 = 0                ; -> Mem Area

MBFREE:         push ebx esi edi ebp
pct = (4)+(4*4)         ; # bytes pushed on stack after last argument

                ;-- Get ptr to MemNode (NULL PTR?)
                mov  edx, [esp+pct+arg2]        ; -> Mem Area
                or   edx, edx
                jz   Exit                    ; Null ptr?
                sub  edx, size MemNode          ; -> MemNode

                ;-- Load MEMBLOCK info
                mov  esi, [esp+pct+arg1]        ; -> MEMBLOCK
                mov  ebx, [esi+MEMBLOCK.base]   ; linear adx of MEMBLOCK
                sub  ebx, [_database]           ; relative ofs to DGROUP
                mov  ebp, [esi+MEMBLOCK.size]   ; size of memblock
                add  ebp, ebx                   ; -> final byte + 1

                ;-- MEMBLOCK uninitalized?
                cmp  ecx, ebp
                je   Exit

If DebugMode    ;-- Check MBSig
                cmp  [dword ebx], MBSig
                jne  Exit                    ; Invalid MBSig?
                add  ebx, MBSigSize             ; -> first node
EndIf

                ;-- nullify ptr to previous MemNode
                xor  edi, edi

;---------------

FindNode:
; ebx -> current MemNode
; edx -> MemNode to free
; edi -> previous MemNode
; ebp -> final byte of MEMBLOCK + 1

If DebugMode    ;-- Is current MemNode valid?
                mov  eax, [ebx+MemNode.size]
                xor  eax, NodeSigKey
                cmp  [ebx+MemNode.sig], eax
                jne  CorruptMB               ; invalid MemNode?
EndIf
                ;-- Is MemNode the one to free?
                cmp  edx, ebx
                je   FoundNodeToFree

                ;-- Update previous MemNode ptr
                mov  edi, ebx                   ; -> previous node

                ;-- Point to next node
                mov  eax, [ebx+MemNode.size]
                and  eax, 7fffffffh             ; kill 'used' flag
                add  ebx, size MemNode          ; skip MemNode
                add  ebx, eax                   ; skip mem area

                ;-- Any more nodes to check?
                cmp  ebx, ebp
                jb   FindNode
                ja   CorruptMB
                jmp  short Exit


;---------------

FoundNodeToFree:
; ebx -> node to free
; edi -> previous node (null = no last node)
; ebp -> final byte of MEMBLOCK + 1

                ;-- MemNode already free?
                mov  eax, [ebx+MemNode.size]
                test eax, 80000000h
                jz   Exit

                ;-- Mark node as free
                and  eax, 7fffffffh
                mov  [ebx+MemNode.size], eax
If DebugMode
                xor  eax, NodeSigKey
                mov  [ebx+MemNode.sig], eax
                xor  eax, NodeSigKey
EndIf
                ;-- Is next node free?
                add  eax, size MemNode
                add  eax, ebx                   ; -> next MemNode
                cmp  eax, ebp
                ja   CorruptMB
                je   NextNotFree
                mov  ecx, [eax+MemNode.size]
                test ecx, 80000000h
                jnz  NextNotFree

                ;-- Join next node and freed node
                mov  [eax+MemNode.size], 0      ; destroy next node
                mov  eax, [ebx+MemNode.size]    ; newly freed node's size
                                                ; high bit is 0
                add  eax, size MemNode          ; next node size
                add  eax, ecx                   ; mem area of next node
                mov  [ebx+MemNode.size], eax
If DebugMode
                xor  eax, NodeSigKey
                mov  [ebx+MemNode.sig], eax
EndIf

NextNotFree:
; ebx -> freed node
; edi -> previous node (null = no last node)

                ;-- Last MemNode NULL?
                or   edi, edi
                jz   Exit

                ;-- Is last node free?
                mov  eax, [edi+MemNode.size]
                test eax, 80000000h
                jnz  Exit

                ;-- Join last node and freed node
                add  eax, size MemNode          ; size of freed node
                add  eax, [ebx+MemNode.size]    ; high bit is 0
                mov  [ebx+MemNode.size], 0      ; destroy freed node
                mov  [edi+MemNode.size], eax
If DebugMode
                xor  eax, NodeSigKey
                mov  [edi+MemNode.sig], eax
EndIf

;---------------

Exit:           pop  ebp edi esi ebx
                ret  8                          ; 2 args

;---------------

CorruptMB:
If DebugMode    ;-- Invalidate MEMBLOCK
                mov  ebx, [esp+pct+arg1]        ; -> MEMBLOCK
                mov  ebx, [ebx+MEMBLOCK.base]   ; linear adx of MEMBLOCK
                sub  ebx, [_database]           ; relative ofs to DGROUP
                mov  [dword ebx], MBSigInvl
EndIf
                jmp  short Exit


;
EndS            _TEXT
End
