;
;                          MEMBLOCK Get MemArea Size
;
;
; Borland C++ 4.0 for WIN32 prototype:
; DWORD __pascal mbgetsize (MEMBLOCK *mb, PTR ptr);
;
; version 0.3
; - White Shadow -
;
.386p
Ideal
include "bmmalloc.inc"

Public MBGETSIZE


;
Segment _TEXT byte public use32 'CODE'
Assume  cs:_TEXT, ds:DGROUP


; -- argument stack offsets
arg1 = 4                ; -> MEMBLOCK
arg2 = 0                ; -> Mem Area

MBGETSIZE:      push ebx
pct = (4)+(1*4)         ; # bytes pushed on stack after last argument

                ;-- Get ptr to MemNode
                mov  edx, [esp+pct+arg2]        ; -> MemArea
                or   edx, edx                   ; null?
                jz   ExitNull
                sub  edx, size MemNode          ; -> MemNode

                ;-- Load MEMBLOCK info
                mov  eax, [esp+pct+arg1]        ; -> MEMBLOCK
                mov  ebx, [eax+MEMBLOCK.base]   ; linear adx of MEMBLOCK
                sub  ebx, [_database]           ; relative ofs to DGROUP
                mov  ecx, [eax+MEMBLOCK.size]   ; size of memblock
                add  ecx, ebx                   ; -> final byte + 1

                ;-- MEMBLOCK uninitailized?
                cmp  ecx, ebx
                je   ExitNull

If DebugMode    ;-- Check MBSig
                cmp  [dword ebx], MBSig
                jne  ExitNull                   ; Invalid MBSig?
                add  ebx, MBSigSize             ; -> first node
EndIf

;---------------

FindNode:
; ebx -> current MemNode
; ecx -> final byte of MEMBLOCK + 1
; edx -> MemNode to find

                ;-- Load size
                mov  eax, [ebx+MemNode.size]
If DebugMode
                xor  eax, NodeSigKey
                cmp  [ebx+MemNode.sig], eax
                jne  ExitNull                   ; invalid MemNode?
                xor  eax, NodeSigKey
EndIf
                and  eax, 7fffffffh

                ;-- Is this the node to find?
                cmp  ebx, edx
                je   FoundNode

                ;-- Point to next node
                add  ebx, size MemNode
                add  ebx, eax                   ; + MemArea size

                ;-- Reached the end?
                cmp  ebx, ecx
                jb   FindNode

;---------------

ExitNull:       xor  eax, eax

;---------------

FoundNode:
; eax -> MemArea size of node to find
                pop  ebx
                ret  8                          ; 2 args


;
EndS            _TEXT
End
