;
;                               MEMBLOCK Squish
;
;
; Borland C++ 4.0 for WIN32 prototype:
; DWORD __pascal mbsquish(MEMBLOCK *mb);
;
; Returns # bytes removed, and modifies MEMBLOCK struct
;
; version 0.1
; - White Shadow -
;
.386p
Ideal
include "bmmalloc.inc"

Public MBSQUISH

;
Segment _TEXT byte public use32 'CODE'
Assume  cs:_TEXT, ds:DGROUP

; -- argument stack offsets
arg1 = 0                ; -> MEMBLOCK

MBSQUISH:       push ebx
pct = (4)+(1*4)         ; # bytes pushed on stack after last argument

                ;-- load MEMBLOCK info
                mov  ecx, [esp+pct+arg1]        ; -> MEMBLOCK
                mov  ebx, [ecx+MEMBLOCK.base]   ; linear adx of MEMBLOCK
                sub  ebx, [_database]           ; relative ofs to DGROUP
                mov  edx, [ecx+MEMBLOCK.size]   ; size of memblock
                add  edx, ebx                   ; relative ofs + size

                ;-- MEMBLOCK uninialized?
                cmp  edx, ebx
                je   ExitNull

If DebugMode    ;-- check MBSig
                cmp  [dword ebx], MBSig         ; 4 byte signature
                jne  BadMBSig                   ; is it there?
                add  ebx, MBSigSize             ; -> first node
EndIf

;---------------

FindLastNode:   ;-- Get Node Size
                mov  eax, [ebx+MemNode.size]
If DebugMode
                xor  eax, NodeSigKey
                cmp  [ebx+MemNode.sig], eax
                jne  CorruptMB
                xor  eax, NodeSigKey
EndIf
                and  eax, 7fffffffh

                ;-- Last Node?
                add  eax, ebx
                add  eax, size MemNode
                cmp  eax, edx
                je   FoundLastNode
                ja   CorruptMB

                ;-- No, continue
                mov  ebx, eax
                jmp  short FindLastNode

;---------------

FoundLastNode:
; ebx -> last MemNode
                ;-- Is last node allocated?
                mov  eax, [ebx+MemNode.size]
                or   eax, eax
                js   ExitNull

                ;-- Is the last node also the first node?
                mov  edx, [ecx+MEMBLOCK.base]   ; linear adx of MEMBLOCK
                sub  edx, [_database]           ; relative ofs to DGROUP
If DebugMode
                add  edx, MBSigSize
EndIf
                cmp  ebx, edx
                jne  NotFirstNode

;---------------

                ;-- Make only (and free) MemNode's size = 4
                mov  [ebx+MemNode.size], 4
If DebugMode
                mov  [ebx+MemNode.sig], NodeSigKey XOR 4
EndIf

                ;-- Get size freed  (eax >= 4)
                sub  eax, 4
                jmp  short ReduceMB

;---------------

NotFirstNode:   ;-- Kill last MemNode
                mov  [ebx+MemNode.size], 0
                add  eax, size MemNode

;---------------

ReduceMB:       ;-- Reduce MEMBLOCK size
                sub  [ecx+MEMBLOCK.size], eax

;---------------

Exit:           pop  ebx
                ret  4                          ;1 arg

;---------------

BadMBSig:
ExitNull:       xor  eax, eax
                jmp  short Exit

;---------------

CorruptMB:
If DebugMode    ;-- Invalidate MEMBLOCK
                mov  ecx, [esp+pct+arg1]        ; ->MEMBLOCK
                mov  ecx, [ecx+MEMBLOCK.base]   ; linear adx of MEMBLOCK
                sub  ecx, [_database]           ; realtive ofs to DGROUP
                mov  [dword ecx], MBSigInvl
EndIf
                jmp  short ExitNull


;
EndS            _TEXT
End
