;
;                              MEMBLOCK Unsquish
;
;
; Borland C++ 4.0 for WIN32 prototype:
; void  __pascal mbunsquish(MEMBLOCK *mb, DWORD size);
;
; version 0.1
; - White Shadow -
;
.386p
Ideal
include "bmmalloc.inc"

Public MBUNSQUISH

;
Segment _TEXT byte public use32 'CODE'
Assume  cs:_TEXT, ds:DGROUP

; -- argument stack offsets
arg1 = 4                ; -> MEMBLOCK
arg2 = 0                ; size of orig MEMBLOCK

MBUNSQUISH:     push ebx
pct = (4)+(1*4)         ; # bytes pushed on stack after last argument

                ;-- load MEMBLOCK info
                mov  ecx, [esp+pct+arg1]        ; -> MEMBLOCK
                mov  ebx, [ecx+MEMBLOCK.base]   ; linear adx of MEMBLOCK
                sub  ebx, [_database]           ; relative ofs to DGROUP
                mov  edx, [ecx+MEMBLOCK.size]   ; size of memblock
                add  edx, ebx                   ; relative ofs + size

                ;-- MEMBLOCK uninitilized?
                cmp  edx, ebx
                je   Exit

If DebugMode    ;-- check MBSig
                cmp  [dword ebx], MBSig         ; 4 byte signature
                jne  Exit                       ; is it there?
                add  ebx, MBSigSize             ; -> first node
EndIf

;---------------
; ebx -> current MemNode
; edx -> last byte of MEMBLOCK + 1  (also new MemNode if needed)

FindLastNode:   ;-- Get Node Size
                mov  eax, [ebx+MemNode.size]
If DebugMode
                xor  eax, NodeSigKey
                cmp  [ebx+MemNode.sig], eax
                jne  CorruptMB
                xor  eax, NodeSigKey
EndIf
                and  eax, 7fffffffh

                ;-- Last Node?
                add  eax, ebx
                add  eax, size MemNode
                cmp  eax, edx
                je   FoundLastNode
                ja   CorruptMB

                ;-- No, continue
                mov  ebx, eax
                jmp  short FindLastNode

;---------------

FoundLastNode:
; ebx -> last node
; ecx -> MEMBLOCK
; edx -> last byte of old MEMBLOCK + 1  (also new MemNode if needed)

                ;-- Get size to increase MEMBLOCK by
                mov  eax, [esp+pct+arg2]        ; New MEMBLOCK size
                sub  eax, [ecx+MEMBLOCK.size]   ; - Old MEMBLOCK size
                jle  Exit
                add  [ecx+MEMBLOCK.size], eax

; eax - size to increase MEMBLOCK by
; ebx -> last node

                ;-- Is last node already free
                mov  ecx, [ebx+MemNode.size]
                and  ecx, ecx
                jns  NoNewNode

                ;-- Enough room for a new free node?
                cmp  eax, size MemNode
                jbe  NoNewNode

                ;-- Create new MemNode
                sub  eax, size MemNode
                mov  [edx+MemNode.size], eax
If DebugMode
                xor  eax, NodeSigKey
                mov  [edx+MemNode.sig], eax
EndIf
                jmp  short Exit

;---------------

NoNewNode:      add  eax, [ebx+MemNode.size]    ; OK even if allocated
                mov  [ebx+MemNode.size], eax
If DebugMode
                xor  eax, NodeSigKey
                mov  [ebx+MemNode.sig], eax
EndIf

;---------------

Exit:           pop  ebx
                ret  8                          ; 2 args

;---------------

CorruptMB:
If DebugMode    ;-- Invalidate MEMBLOCK
                mov  ecx, [esp+pct+arg1]        ; -> MEMBLOCK
                mov  ecx, [ecx+MEMBLOCK.base]   ; linear adx of MEMBLOCK
                sub  ecx, [_database]           ; realtive ofs to DGROUP
                mov  [dword ecx], MBSigInvl
EndIf
                jmp  short Exit

;
EndS            _TEXT
End
