/*===========================================================================*\
| PULLDATA.C - User Statistics for data-entry windows.      ver 2.0, 04-15-89 |
|                                                                             |
| This file contains all the data to configure the data-entry fields in       |
| data windows or work windows.                                               |
|   Copyright (c) 1989 James H. LeMay, All rights reserved.                   |
|   Conversion to Turbo C by Jordan Gallagher / Wisdom Research               |
\*===========================================================================*/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include <ctype.h>

#include "pullc20.h"
#include "pullshel.h"

extern fptr addr_initpulldata=initpulldata;

/*================ Set up variables for data windows here: ==================*\
| Place your variables names here to interface with the menus.                |
| Be careful of string lengths that are too long.  They can be no longer than |
| DATA_STR_SIZE.                                                              |
\*---------------------------------------------------------------------------*/

unsigned char aubyte     = 100;
int           aint       = 200;

unsigned char dataentryoattr;       /* output attribute */
unsigned char dataentryiattr;       /* input  attribute */
unsigned char datawndwiattr;        /* input  attribute */
unsigned char datawndwoattr;        /* output attribute */
unsigned char datawndwbattr;        /* border attribute */
unsigned int  datawndwbrdr;

#ifdef USE_MSGLINE_CODE
/*=============================| geterrmsgs |===============================*\
\*==========================================================================*/
void geterrmsgs(void)
{
    autonumlock = 0;    /* if 1, turns NumLock on with data entry */
    capslockcol = 41;   /* first column for " CAPS NUM SCROLL " on msgline. */

    strcpy( errmsgline[INVALID_EM], " Invalid entry.             ESC-"
                                    "acknowledge" );
    strcpy( errmsgline[MY_EM],      " This indicates an error.   ESC-"
                                    "acknowledge" );
}
#endif

/*=============================| makeerrmsg |===============================*\
\*==========================================================================*/
void makeerrmsg( unsigned long low, unsigned long high, char sign )
{
    char tmp[34];
#ifdef USE_MSGLINE_CODE
    datapad.errmsg = USER_EM;
    strcpy( errmsgline[USER_EM], "Range: " );
    if(sign)
        strcat( errmsgline[USER_EM], ltoa(low,tmp,10) );
    else
        strcat( errmsgline[USER_EM], ultoa(low,tmp,10) );
    strcat( errmsgline[USER_EM], " to " );
    if(sign)
        strcat( errmsgline[USER_EM], ltoa(high,tmp,10) );
    else
        strcat( errmsgline[USER_EM], ultoa(high,tmp,10) );
    strcat( errmsgline[USER_EM], ".  Press ESC" );
#endif
}

/*====================== Data entry range checking ==========================*\
| These functions are completely defined by the user.  They may not even be   |
| necessary if the string entered is satisfactory as a valid number.          |
| "translate" can alter each key from the keyboard before it gets evaluated.  |
| "verify" will check the range or even completely alter the entire string.   |
\*---------------------------------------------------------------------------*/

/*-------------------- Data window data entry checking ----------------------*/

void checkaubyte(void)
{
    if(ubytedata(datapad)<20 || ubytedata(datapad)>50)
        makeerrmsg(20,50,0);
}

/*-------------------- Work window data entry checking ----------------------*/

void translatecase(void)
{
    if(!extkey)
        key = toupper(key);        /* simple upper case translation */
}

void verifyaint(void)
{
    if(intdata(datapad)<=0 || intdata(datapad)>200)
        makeerrmsg( 1, 200, 1 );
}

/*=========================| getdataentrystats |============================*\
| The major configurations for all menus go here.  The program first clears  |
| all record values to 0.  The values below will set new values.  Therefore, |
| clearing the values of variables is unnecessary.                           |
\*==========================================================================*/
void getdataentrystats(void)
{
    /*------------ Set up your pull-down data windows here: -----------------*\
      Justification will default with numbers right justified and string to
      the left if none is specified.
    */

    getdatawndw(AUBYTE_DW);                /* just gets cleared topdatawndw */
    topdatawndw.entry.varaddr       = &aubyte;
    topdatawndw.entry.typeofdata    = UNSIGNED_BYTES;
    topdatawndw.entry.field         = 3;
    topdatawndw.entry.setname       = NO_SET;
 /* topdatawndw.entry.justify_output = RIGHT; */     /* this is the default */
 /* topdatawndw.entry.msglinenum    = DE_ML; */      /* this is the default */
    topdatawndw.entry.helpwndwnum   = DATAWNDW_HW;
    savedatawndw();                                 /* saves it in the heap */

    /*----------------------- Work window data entry ------------------------*/
    autotab = 1;       /* after entry, tabs to next one in sequence */

    if(qvideo_mode==MONO)
         datapad.hattr = LIGHTGRAY_BG;
    else datapad.hattr = WHITE+CYAN_BG; /* optional attribute of data entry
                                           hilite - use SAMEATTR if not
                                           desired
                                        */
    getdataentry(AINT_DE);
    topentry.varaddr        = &aint;
    topentry.typeofdata     = INTS;
    topentry.row            = 2;
    topentry.col            = 11;
    topentry.field          = 4;
    topentry.maxfield       = 3;
    topentry.setname        = NO_SET;
    topentry.checkrangefunc = verifyaint;
    topentry.msglinenum     = DE_ML;
    topentry.helpwndwnum    = DATAWNDW_HW;
    savedataentry();
}

/*=================== Data entry initialization code ========================*\
| The following code initializes all of the stats for the data entry windows  |
| and the work window data entry fields.  There is no need to edit this       |
| except for the default colors in setdefaultcolors.                          |
\*---------------------------------------------------------------------------*/

/*============================| allocateheap |==============================*\
\*==========================================================================*/
void allocateheap(void)
{
    if(heapok(NUM_OF_DATA_WNDWS*sizeof(datawndw_t)))
        datawndw=calloc( NUM_OF_DATA_WNDWS, sizeof(datawndw_t) );
    if(heapok(NUM_OF_DATA_ENTRIES*sizeof(dataentry_t)))
        dataentry=calloc( NUM_OF_DATA_ENTRIES, sizeof(dataentry_t) );
}

/*==========================| setdefaultcolors |============================*\
\*==========================================================================*/
void setdefaultcolors(void)
{
    /*------------------ set up your colors and borders here: ---------------*/
    if(qvideo_mode==MONO) {
        dataentryiattr = LIGHTGRAY;        /* input  attribute */
        dataentryoattr = WHITE;            /* output attribute */
        datawndwiattr  = WHITE;            /* input  attribute */
        datawndwoattr  = LIGHTGRAY_BG;     /* output attribute */
    } else {
        dataentryiattr = YELLOW+MAGENTA_BG;  /* input  attribute */
        dataentryoattr = BLACK+LIGHTGRAY_BG; /* output attribute */
        datawndwiattr  = BLACK+BROWN_BG;     /* input  attribute */
        datawndwoattr  = YELLOW+BLACK_BG;    /* output attribute */
    }
    datawndwbattr  = BLACK+BROWN_BG;     /* border attribute */
    datawndwbrdr   = HDOUBLE_BORDER;
}

/*===========================| initdatacolors |=============================*\
\*==========================================================================*/
void initdatacolors(void)
{
    int i;

    for(i=0; i<NUM_OF_DATA_WNDWS; i++) {
        getdatawndw( i );
        topdatawndw.entry.iattr = datawndwiattr;   /* input  attribute */
        topdatawndw.entry.oattr = datawndwoattr;   /* output attribute */
        topdatawndw.battr       = datawndwbattr;   /* border attribute */
        savedatawndw();
    }

    for(i=0; i<NUM_OF_DATA_ENTRIES; i++) {
          getdataentry( i );
          topentry.iattr = dataentryiattr;  /* input  attribute */
          topentry.oattr = dataentryoattr;  /* output attribute */
          savedataentry();
    }
}

/*=============================| getjustify |===============================*\
\*==========================================================================*/
int getjustify( int justify, int tod )
{
    if(justify==NO_DIR) {
        if(tod<=USERNUMS)
             return(RIGHT);        /* for nums */
        else return(LEFT);         /* for chars and strings */
    } else
        return(justify);
}

/*=============================| getsetname |===============================*\
\*==========================================================================*/
int getsetname( int sn, int tod )
{
    if(sn==NO_SET)
        switch(tod) {
            case UNSIGNED_BYTES:
            case UNSIGNED_INTS:  
            case UNSIGNED_LONGS: return(UNSIGNED_SET);
            case BYTES:
            case INTS:
            case LONGS:          return(SIGNED_SET);
            case FLOATS:
            case DOUBLES:        return(FLOAT_SET);
            default:             return(CHAR_SET);
        }
    else
        return(sn);
}

/*==========================| initdatadefaults |============================*\
\*==========================================================================*/
void initdatadefaults(void)
{
    int i;

    for(i=0; i<NUM_OF_DATA_WNDWS; i++) {
        getdatawndw(i);
        topdatawndw.border = datawndwbrdr;
        topdatawndw.entry.setname = getsetname( topdatawndw.entry.setname,
                                                topdatawndw.entry.typeofdata );
        topdatawndw.entry.row = 1;
        topdatawndw.entry.col = 2;
        if(topdatawndw.entry.maxfield==0)
            topdatawndw.entry.maxfield = topdatawndw.entry.field;
        topdatawndw.entry.justify_output = getjustify(
                                           topdatawndw.entry.justify_output,
                                           topdatawndw.entry.typeofdata );
        if(topdatawndw.entry.msglinenum==0)
            topdatawndw.entry.msglinenum = DW_ML;
        if(topdatawndw.entry.helpwndwnum==0)
            topdatawndw.entry.helpwndwnum = DATAWNDW_HW;
        savedatawndw();
    }

    for(i=0; i<NUM_OF_DATA_ENTRIES; i++) {
        getdataentry(i);
        topentry.setname = getsetname( topentry.setname, topentry.typeofdata );
        if(topentry.maxfield==0)
            topentry.maxfield = topentry.field;
        topentry.justify_output = getjustify( topentry.justify_output,
                                              topentry.typeofdata );
        if(topentry.msglinenum==0)
            topentry.msglinenum = DE_ML;
         if(topentry.helpwndwnum==0)
            topentry.helpwndwnum = DATAWNDW_HW;
       savedataentry();
    }
}

/*============================| initpulldata |==============================*\
\*==========================================================================*/
void initpulldata(void)
{
    allocateheap();
    setdefaultcolors();
    initdatacolors();
#ifdef USE_MSGLINE_CODE
    geterrmsgs();
#endif
    getdataentrystats();
    initdatadefaults();
}
