/*===========================================================================*\
| PULLSTAT.C - User Statistics for pull-down menus.         ver 2.0, 04-15-89 |
|                                                                             |
| This file contains all the data for getuserpullstats, getoverridestats and  |
| checkglobalkeys to configure the menus.                                     |
|   Copyright (c) 1989 James H. LeMay, All rights reserved.                   |
|   Conversion to Turbo C by Jordan Gallagher / Wisdom Research               |
\*===========================================================================*/

#include <conio.h>
#include <dos.h>
#include <string.h>

#include "pullc20.h"
#include "pullshel.h"

char filename[13]="pulldemo.exe";

/*============================| getmainmenu |===============================*\
\*==========================================================================*/
void getmainmenu( int name )
{
    topmenu = mainmenu[(mri=name)];
}

/*============================| savemainmenu |==============================*\
\*==========================================================================*/
void savemainmenu(void)
{
    mainmenu[mri]=topmenu;
}

#ifdef USE_SUBMENU_CODE
/*=============================| getsubmenu |===============================*\
\*==========================================================================*/
void getsubmenu( int name )
{
    topmenu = submenu[(mri=name)];
}

/*============================| savesubmenu |===============================*\
\*==========================================================================*/
void savesubmenu(void)
{
    submenu[mri] = topmenu;
}
#endif

#ifdef USE_HELPWNDW_CODE
/*============================| sethelplines |==============================*\
\*==========================================================================*/
void sethelplines( int name, int first, int last )
{
    helpwndw[name].firstline = first;
    helpwndw[name].lastline  = last;
}
#endif 

/*============================ EXEC FUNCTIONS ===============================*\
| Place functions for execution by menu pointers (funcptr) here.              |
\*---------------------------------------------------------------------------*/

/*=============================| dummyfunc |================================*\
\*==========================================================================*/
void dummyfunc(void)
{
#ifdef USE_MSGLINE_CODE
    showmsg(FUNC_ML);
#endif 
    delay(1000);
}

/*==============================| setquit |=================================*\
\*==========================================================================*/
void setquit(void)
{
    poptoworkwndw = 1;
    quit = 1;
}

/*=========================| getuserpullstats |==============================*\
| The major configurations for all menus go here.  The program first clears   |
| all record values to 0.  The values below will set new values.  Therefore,  |
| clearing the values of variables is unnecessary.                            |
\*---------------------------------------------------------------------------*/
void getuserpullstats(void)
{
    location_warning=1;   /* if 1 and a submenu won't fit, a message is
                             displayed.  if 0, you can override the
                             location without the message.
                          */

    /*------------------ set up your colors and borders here: ---------------*/
    toplineattr   = BLACK+LIGHTGRAY_BG;
    toplinehattr  = WHITE+BLACK_BG;

    mainmenubattr = LIGHTGRAY+BLACK_BG;
    mainmenuhattr = BLACK+LIGHTGRAY_BG;
    mainmenulattr = YELLOW+BLACK_BG;
    mainmenucattr = LIGHTGRAY+BLACK_BG;
    strcpy( brdr[USER_BORDER_1], "͸͵ѳ" );
    mainmenubrdr  = USER_BORDER_1;

#ifdef USE_SUBMENU_CODE
    submenuwattr  = BLACK+CYAN_BG;
    submenubattr  = BLACK+CYAN_BG;
    submenubrdr   = SINGLE_BORDER;
#endif

    if(videomode==7) {
        toplinelattr  = toplineattr;
        mainmenuwattr = LIGHTGRAY + BLACK_BG;
#ifdef USE_SUBMENU_CODE
        submenuhattr  = BLACK     + LIGHTGRAY_BG;
        submenulattr  = WHITE     + BLACK_BG;
        submenucattr  = LIGHTGRAY + BLACK_BG;
#endif
    } else {
        toplinelattr  = RED       + LIGHTGRAY_BG;
        mainmenuwattr = WHITE     + BLACK_BG;
#ifdef USE_SUBMENU_CODE
        submenuhattr  = WHITE     + BLUE_BG;
        submenulattr  = WHITE     + CYAN_BG;
        submenucattr  = BLUE      + CYAN_BG;
#endif
    }

#ifdef USE_HELPWNDW_CODE
    helpwndwwattr = BLACK+GREEN_BG;
    helpwndwbattr = BLACK+LIGHTGRAY_BG;
    helpwndwbrdr  = HDOUBLE_BORDER;
    helpwndwmodes = ZOOMMODE+SHADOWRIGHT+CURSOROFFMODE;
    helpbottomrow = crt_rows-4;
#endif

#ifdef USE_MSGLINE_CODE
    msglineattr   = GREEN+BLACK_BG;
    keystatusattr = BLACK+GREEN_BG;
    errmsgattr    = YELLOW+RED_BG;
    msglinerow    = crt_rows;
#endif


    /*------------------------- TOP menu defaults ---------------------------*/
    toplinerow = 2;          /* top line menu to appear on row 2 */
    mpulled    = FIRST_MENU; /* main menu title to be hilited when f10 is
                                pressed. */
    strcpy( morecmdseq, /* Sequence of command letter(s) as if keyed in. */
            "F" );      /* This will be the default menu(s) pulled. */
    pulldown   = 0;     /* set this to 1 if you want the command sequence
                           to pull down the menus at startup. */

    /*----------------- set up your mainmenu structures here: ----------------*/
    mainmenurow = 3;    /* first row of main menus to appear on screen row 3 */

    getmainmenu(FIRST_MENU);
    topmenu.menumode = SINGLE_CHOICE;
    topmenu.singleflagline = 2;
    strcpy( topmenu.title, "First" );
    strcpy( topmenu.line[0], "A line" );
    strcpy( topmenu.line[1], "B line" );
    strcpy( topmenu.line[2], "C line" );
    strcpy( topmenu.line[3], "D line" );
    topmenu.defaultline = 1;
    topmenu.msglinenum  = MAIN_ML;
    topmenu.helpwndwnum = MAINMENU_HW;
    savemainmenu();

    getmainmenu( QUIT_MENU );
 /* topmenu.menumode=EXEC_CHOICE; */    /* this is the default */
    strcpy( topmenu.title, "Quit" );
    strcpy( topmenu.line[0], "Stay" );
    strcpy( topmenu.line[1], "Quit" );      topmenu.funcptr[1] = setquit;
    topmenu.backtodefault = 1;
    topmenu.msglinenum  = MAIN_ML;
    topmenu.helpwndwnum = MAINMENU_HW;
    savemainmenu();

    /*---------------------- set up your submenus here: --------------------*\
       Careful! -- indexes to submenus must be numbered in order of level;
       i.e., all submenus first, all subsubmenus second, all
       subsubsubmenus, ... etc.
    */

#ifdef USE_SUBMENU_CODE

    getsubmenu( MY_SUB_MENU );
    topmenu.menumode=SINGLE_CHOICE;
    topmenu.singleflagline=3;
    strcpy( topmenu.line[0], "1 line" );
    strcpy( topmenu.line[1], "2 line" );
    strcpy( topmenu.line[2], "3 line" );
    strcpy( topmenu.line[3], "4 line" );
    topmenu.msglinenum  = SUB_ML;
    topmenu.helpwndwnum = SUBMENU_HW;
    savesubmenu();

#endif

    /*------------------ set up your message lines here: --------------------*\
      Concatenations here allow source to print on 80 col printer.
      All messages up to HELP_ML are reserved.
    */

#ifdef USE_MSGLINE_CODE
    strcpy(msgline[WORK_ML]," F1-help  F2-pull  F10-TOP");
    strcpy(msgline[TOP_ML], " F1-help  F2-pop   LTR-cmd  ESC-return  "
                            "        \x1B\x1A hilight            CR-select" );
    strcpy(msgline[ALT_ML], " Alt: F-First                           "
                            "                                 X-Exit");
    strcpy(msgline[MAIN_ML]," F1-help  F2-pop   LTR-cmd  ESC-return  "
                            "        \x1B\x1A menus  \x18\x19-hilight  "
                            "CR-select");
    strcpy(msgline[SUB_ML], " F1-help  F2-pop   LTR-cmd  ESC-return  "
                            "                  \x18\x19-hilight  CR-select" );
    strcpy(msgline[DW_ML],  " F1-help  F2-pop   F10-TOP  ESC-restore "
                            "                              CR-enter");
    strcpy(msgline[DE_ML],  " F1-help  F2-pull  F10-TOP  ESC-restore "
                            "                              CR-enter");
    strcpy(msgline[SEQ_ML], " F1-help  F2-pull  F10-TOP              "
                            "                              CR-edit");
    strcpy(msgline[HELP_ML]," F1-return         LTR-cmd  ESC-return");
    strcpy(msgline[FUNC_ML]," Processing ...");
#endif

    /*------------------ set up your help lines here: -----------------------*/
#ifdef USE_HELPWNDW_CODE

    strcpy(helpline[HL_W1],"Work window help message");
    strcpy(helpline[HL_WL],"");

    strcpy(helpline[HL_T1],"Move cursor and press return OR type a command");
    strcpy(helpline[HL_TL],"letter.  ESC to return to the Work window.");

    strcpy(helpline[HL_M1],"Main menu help message");
    strcpy(helpline[HL_ML],"");

    strcpy(helpline[HL_S1],"Submenu help message");
    strcpy(helpline[HL_SL],"");

    strcpy(helpline[HL_D1],"This is a data entry field.  Only valid alpha-");
    strcpy(helpline[HL_D2],"numeric characters can be typed.  Full editing");
    strcpy(helpline[HL_D3],"capability:");
    strcpy(helpline[HL_D4],"  1. WordStar keys: ^A,^S,^D,^F,^G,^H,^R,^Y,^U");
    strcpy(helpline[HL_D5],"  2. Cursor keys:   Home/End, Left/Right Arrow,");
    strcpy(helpline[HL_D6],"     Ctrl-Left/Right Arrow, and Ins/Del.");
    strcpy(helpline[HL_DL],"  3. Use ^R or ^U to restore original data.");

    /*---------------------- set up your help windows here: -----------------*/
    /* helpwndw[WORKWNDW_HW] is reserved for the work window. */
    /* helpwndw[TOPLINE_HW] is reserved for the top menu. */

    helpmsglinenum = HELP_ML;      /* standard message for a help window */
    sethelplines( WORKWNDW_HW, HL_W1, HL_WL );
    sethelplines( TOPLINE_HW,  HL_T1, HL_TL );
    sethelplines( MAINMENU_HW, HL_M1, HL_ML );
    sethelplines( SUBMENU_HW,  HL_S1, HL_SL );
    sethelplines( DATAWNDW_HW, HL_D1, HL_DL );

#endif
}

/*=========================== getoverridestats ==============================*\
You can override the automatic colors, sizes, and locations here.
\*---------------------------------------------------------------------------*/
void getoverridestats(void)
{
    /* No overrides included. */
}

void setworkwndw( int wn )
{
    pulldown        = 0;
    poptoworkwndw   = 1;
    topworkwndwname = wn;
}

/*==========================| checkglobalkeys |==============================*\
| This function gives you the option to add global keys similar to the ones   |
| in the TC environment, such as alt-r or alt-f3.  This is for extended keys  |
| only.                                                                       |
\*---------------------------------------------------------------------------*/
void checkglobalkeys(void)
{
    pulldown = 1;

    switch(key) {
        case POPKEY:  pulldown=0; poptoworkwndw=1;    break;        /* f2 */
        case TOPKEY1: poptotop=1;                     break;        /* f10 */
        case ALTF:    setcmdseq ("F");                break;
        case ALTQ:    setcmdseq ("Q");                break;
        case ALTX:    setquit();                      break;
        default:      pulldown=0;                     break;
    }
}

