/*===========================================================================*\
| PULLSTAT.C - User Statistics for pull-down menus.         ver 2.0, 04-15-89 |
|                                                                             |
| This file contains all the data for getuserpullstats, getoverridestats and  |
| checkglobalkeys to configure the menus.                                     |
|   Copyright (c) 1989 James H. LeMay, All rights reserved.                   |
|   Conversion to Turbo C by Jordan Gallagher / Wisdom Research               |
\*===========================================================================*/

#include <conio.h>
#include <dos.h>
#include <string.h>

#include "pullc20.h"
#include "pulldemo.h"

char filename[13]="pulldemo.exe";

/*============================| getmainmenu |===============================*\
\*==========================================================================*/
void getmainmenu( int name )
{
    topmenu = mainmenu[(mri=name)];
}

/*============================| savemainmenu |==============================*\
\*==========================================================================*/
void savemainmenu(void)
{
    mainmenu[mri]=topmenu;
}

#ifdef USE_SUBMENU_CODE
/*=============================| getsubmenu |===============================*\
\*==========================================================================*/
void getsubmenu( int name )
{
    topmenu = submenu[(mri=name)];
}

/*============================| savesubmenu |===============================*\
\*==========================================================================*/
void savesubmenu(void)
{
    submenu[mri] = topmenu;
}
#endif

#ifdef USE_HELPWNDW_CODE
/*============================| sethelplines |==============================*\
\*==========================================================================*/
void sethelplines( int name, int first, int last )
{
    helpwndw[name].firstline = first;
    helpwndw[name].lastline  = last;
}
#endif 

/*============================ EXEC FUNCTIONS ===============================*\
| Place functions for execution by menu pointers (funcptr) here.              |
\*---------------------------------------------------------------------------*/

/*=============================| dummyfunc |================================*\
\*==========================================================================*/
void dummyfunc(void)
{
#ifdef USE_MSGLINE_CODE
    showmsg(FUNC_ML);
#endif 
    delay(1000);
}

/*==============================| gotodir |=================================*\
\*==========================================================================*/
void gotodir(void)
{
    pulldown=1;
    strcpy(morecmdseq,"D");
}

/*===============================| dodir |==================================*\
\*==========================================================================*/
void dodir(void)
{
    /* Use (filename,filename) to initially hilite a close match. */
    /* Use (filename,'') to start at default. */
    pulldirectory( filename, filename );
}

/*==============================| setquit |=================================*\
\*==========================================================================*/
void setquit(void)
{
    poptoworkwndw = 1;
    quit = 1;
}

/*===========================| processthenpop |=============================*\
\*==========================================================================*/
void processthenpop(void)
{
    /* Here's how to process and then pop the menus. */
    dummyfunc();
    poptoworkwndw = 1;
}

/*===========================| popthenprocess |=============================*\
\*==========================================================================*/
void popthenprocess(void)
{
    /* Here's how to pop first and then process. */
    if(popped()) dummyfunc();
}

/*=========================| popprocessandpull |============================*\
\*==========================================================================*/
void popprocessandpull(void)
{
    /* Here's how to pop the menus first, process and then pull the same
       menus back again.  This is good for updating the work window.
    */
    if(popped()) dummyfunc();
    pulldown = 1;
}

/*===========================| popnumoflevels |=============================*\
\*==========================================================================*/
void popnumoflevels(void)
{
    /* Here's how to pop by a number of levels so that part of the menus 
       will remain displayed while going to another submenu.
    */
    poplevels  = 1;
    pulldown   = 1;
    strcpy( morecmdseq, "Y" );
}

/*============================| poptonewmenu |==============================*\
\*==========================================================================*/
void poptonewmenu(void)
{
    /* Here's how to go to a completely different menu. */
    poptotop   = 1;
    pulldown   = 1;
    strcpy( morecmdseq, "AR" );
}

/*=============================| datemenu1 |================================*\
\*==========================================================================*/
void datemenu1(void)
{
    pulldown   = 1;
    strcpy( morecmdseq, "D" );
}

/*=============================| datemenu2 |================================*\
\*==========================================================================*/
void datemenu2(void)
{
    pulldown   = 1;
    strcpy( morecmdseq, "Y" );
}

/*=============================| datemenu3 |================================*\
\*==========================================================================*/
void datemenu3(void)
{
    poplevels = 1;
}

/*==========================| getuserpullstats |=============================*\
| The major configurations for all menus go here.  The program first clears   |
| all values to 0.  The code below will set new values.  Therefore, clearing  |
| the values of variables is unnecessary.                                     |
\*---------------------------------------------------------------------------*/
void getuserpullstats(void)
{
    location_warning=1;   /* if 1 and a submenu won't fit, a message is
                             displayed.  if 0, you can override the
                             location without the message.
                          */

    /*------------------ set up your colors and borders here: ---------------*/
    toplineattr   = BLACK+LIGHTGRAY_BG;
    toplinehattr  = WHITE+BLACK_BG;

    mainmenubattr = LIGHTGRAY+BLACK_BG;
    mainmenuhattr = BLACK+LIGHTGRAY_BG;
    mainmenulattr = YELLOW+BLACK_BG;
    mainmenucattr = LIGHTGRAY+BLACK_BG;
    strcpy( brdr[USER_BORDER_1], "͸͵ѳ" );
    mainmenubrdr  = USER_BORDER_1;

#ifdef USE_SUBMENU_CODE
    submenuwattr  = BLACK+CYAN_BG;
    submenubattr  = BLACK+CYAN_BG;
    submenubrdr   = SINGLE_BORDER;
#endif

    if(videomode==7) {
        toplinelattr  = toplineattr;
        mainmenuwattr = LIGHTGRAY + BLACK_BG;
#ifdef USE_SUBMENU_CODE
        submenuhattr  = BLACK     + LIGHTGRAY_BG;
        submenulattr  = WHITE     + BLACK_BG;
        submenucattr  = LIGHTGRAY + BLACK_BG;
#endif
    } else {
        toplinelattr  = RED       + LIGHTGRAY_BG;
        mainmenuwattr = WHITE     + BLACK_BG;
#ifdef USE_SUBMENU_CODE
        submenuhattr  = WHITE     + BLUE_BG;
        submenulattr  = WHITE     + CYAN_BG;
        submenucattr  = BLUE      + CYAN_BG;
#endif
    }

#ifdef USE_HELPWNDW_CODE
    helpwndwwattr = BLACK+GREEN_BG;
    helpwndwbattr = BLACK+LIGHTGRAY_BG;
    helpwndwbrdr  = HDOUBLE_BORDER;
    helpwndwmodes = ZOOMMODE+SHADOWRIGHT+CURSOROFFMODE;
    helpbottomrow = crt_rows-4;
#endif

#ifdef USE_MSGLINE_CODE
    msglineattr   = GREEN+BLACK_BG;
    if(qvideo_mode==MONO)
         keystatusattr = LIGHTGRAY_BG;
    else keystatusattr = BLACK+GREEN_BG;
    errmsgattr    = YELLOW+RED_BG;
    msglinerow    = crt_rows;
#endif


    /*------------------------- TOP menu defaults ---------------------------*/
    toplinerow = 2;     /* top line menu to appear on row 2 */
    mpulled    = 3;     /* main menu title to be hilited when f10 is
                           pressed. */
    strcpy( morecmdseq, /* Sequence of command letter(s) as if keyed in. */
            "ATB" );    /* This will be the default menu(s) pulled. */
    pulldown   = 0;     /* set this to 1 if you want the command sequence
                           to pull down the menus at startup. */

    /*------------------- set up your mainmenu records here: ----------------*/
    mainmenurow = 3;    /* first row of main menus to appear on screen row 3 */

    getmainmenu(FILES_MENU);
    topmenu.menumode=SINGLE_CHOICE;        topmenu.singleflagline=4;
    strcpy( topmenu.title, "Files" );
    strcpy( topmenu.line[0], "Path" );     topmenu.linemode[0]=TO_DATA_WNDW;
                                           topmenu.linknum [0]=PATH_DW;
    strcpy( topmenu.line[1], "Mask for Directory" );
                                           topmenu.linemode[1]=TO_DATA_WNDW;
                                           topmenu.linknum [1]=FILEMASK_DW;
                                           topmenu.funcptr [1]=gotodir;
    strcpy( topmenu.line[2], "Directory" );
                                           topmenu.linemode[2]=TO_USER_WNDW;
                                           topmenu.funcptr [2]=dodir;
    strcpy( topmenu.line[3], "" );
                                           topmenu.linemode[3]=COMMENT;
    strcpy( topmenu.line[4], "Split" );
    strcpy( topmenu.line[5], "make Backup" );
    strcpy( topmenu.line[6], "text Out" );
    strcpy( topmenu.line[7], "" );         topmenu.linemode[7]=PARTITION;
    strcpy( topmenu.line[8], "Help comment" );
                                           topmenu.linemode[8]=COMMENT;
    topmenu.defaultline = 2;
    topmenu.msglinenum  = MAIN_ML;
    topmenu.helpwndwnum = FILESMENU_HW;
    savemainmenu();

    getmainmenu(COLOR_MENU);
    topmenu.menumode=SINGLE_CHOICE;        topmenu.singleflagline=1;
    strcpy( topmenu.title, "Color" );
    strcpy( topmenu.line[0], "Blue" );
    strcpy( topmenu.line[1], "Green" );
    strcpy( topmenu.line[2], "Orange" );   topmenu.linemode[2]=NO_CHOICE;
    strcpy( topmenu.line[3], "Yellow" );
    strcpy( topmenu.line[4], "Red" );
    strcpy( topmenu.line[5], "Cyan" );
    strcpy( topmenu.line[6], "Ultraviolet" );
    topmenu.defaultline = 4;
    topmenu.msglinenum  = MAIN_ML;
    topmenu.helpwndwnum = SINGLECHOICE_HW;
    savemainmenu();

    getmainmenu(AUTO_PARTS_MENU);
    topmenu.menumode=MULTIPLE_CHOICE;
    strcpy( topmenu.title, "AutoParts" );
    strcpy( topmenu.line[0], "Tires" );    topmenu.linemode[0]=TO_SUB_MENU;
                                           topmenu.linknum [0]=TIRES_MENU;
    strcpy( topmenu.line[1], "Radio" );    topmenu.linemode[1]=TO_SUB_MENU;
                                           topmenu.linknum [1]=RADIO_MENU;
    strcpy( topmenu.line[2], "Seats" );    topmenu.linemode[2]=TO_DATA_WNDW;
                                           topmenu.linknum [2]=SEATS_DW;
    strcpy( topmenu.line[3], "Mirrors" );  topmenu.flagged [3]=1;
    strcpy( topmenu.line[4], "Locks" );
    strcpy( topmenu.line[5], "HiBeams" );  topmenu.flagged [5]=1;
    strcpy( topmenu.line[6], "Wheels" );
 /* topmenu.defaultline = 0; */     /* this is the default */
    topmenu.msglinenum  = MAIN_ML;

    topmenu.helpwndwnum = MULTIPLECHOICE_HW;
    savemainmenu();

    getmainmenu( ENTER_DATA_MENU );
    topmenu.menumode=MULTIPLE_CHOICE;
    strcpy( topmenu.title, "EnterData" );
    strcpy( topmenu.line[0],
            "unsigned Byte" );             topmenu.linemode[0]=TO_DATA_WNDW;
                                           topmenu.linknum [0]=UBYTES_DW;
    strcpy( topmenu.line[1],
            "Unsigned int" );              topmenu.linemode[1]=TO_DATA_WNDW;
                                           topmenu.linknum [1]=UINTS_DW;
    strcpy( topmenu.line[2], "Int" );      topmenu.linemode[2]=TO_DATA_WNDW;
                                           topmenu.linknum [2]=INTS_DW;
    strcpy( topmenu.line[3], "Long" );     topmenu.linemode[3]=TO_DATA_WNDW;
                                           topmenu.linknum [3]=LONGS_DW;
    strcpy( topmenu.line[4], "Double" );   topmenu.linemode[4]=TO_DATA_WNDW;
                                           topmenu.linknum [4]=DOUBLES_DW;
    strcpy( topmenu.line[5], "Hex" );      topmenu.linemode[5]=TO_DATA_WNDW;
                                           topmenu.linknum [5]=HEX_DW;
    strcpy( topmenu.line[6], "Character"); topmenu.linemode[6]=TO_DATA_WNDW;
                                           topmenu.linknum [6]=CHARS_DW;
    strcpy( topmenu.line[7], "String" );   topmenu.linemode[7]=TO_DATA_WNDW;
                                           topmenu.linknum [7]=STRINGS_DW;
    topmenu.defaultline = 1;
    topmenu.msglinenum  = MAIN_ML;
    topmenu.helpwndwnum = ENTERDATAMENU_HW;
    savemainmenu();

    getmainmenu( OPTIONS_MENU );
    topmenu.menumode=MULTIPLE_CHOICE;
    strcpy(topmenu.title,  "Options" );
    strcpy(topmenu.line[0],"Dual drive");
    strcpy(topmenu.line[1],"Hard disk");   topmenu.flagged[1]=1;
    strcpy(topmenu.line[2],"Extended Mem");
    strcpy(topmenu.line[3],"CGA" );        topmenu.flagged[3]=1;
    strcpy(topmenu.line[4],"VGA" );
    strcpy(topmenu.line[5],"KeyBoard" );
    strcpy(topmenu.line[6],"Price limit"); topmenu.linemode[6]=TO_DATA_WNDW;
                                           topmenu.linknum [6]=PRICE_DW;
    topmenu.msglinenum  = MAIN_ML;
    topmenu.helpwndwnum = MULTIPLECHOICE_HW;
    savemainmenu();

    getmainmenu( UTILITIES_MENU );
 /* topmenu.menumode=EXEC_CHOICE; */   /* this is the default */
    strcpy(topmenu.title,"Utilities");
    strcpy(topmenu.line[0],"Copy   files"); topmenu.funcptr[0] = dummyfunc;
    strcpy(topmenu.line[1],"Delete files"); topmenu.funcptr[1] = dummyfunc;
    strcpy(topmenu.line[2],"List   file");  topmenu.funcptr[2] = dummyfunc;
    strcpy(topmenu.line[3],"Edit   file");  topmenu.funcptr[3] = dummyfunc;
    strcpy(topmenu.line[4],"Find   file");  topmenu.funcptr[4] = dummyfunc;
    strcpy(topmenu.line[5],"Rename file");  topmenu.funcptr[5] = dummyfunc;
    strcpy(topmenu.line[6],"Sort   files"); topmenu.funcptr[6] = dummyfunc;
    topmenu.defaultline = 1;
    topmenu.msglinenum  = MAIN_ML;
    topmenu.helpwndwnum = EXECCHOICE_HW;
    savemainmenu();

    getmainmenu( IRS_MENU );
 /* topmenu.menumode=EXEC_CHOICE; */   /* this is the default */
    strcpy(topmenu.title,"IRSaccounting");
    strcpy(topmenu.line[0],"Date");         topmenu.linemode[0] = TO_SUB_MENU;
                                            topmenu.linknum [0] = DATE_MENU;
    strcpy(topmenu.line[1],"Cost");         topmenu.funcptr [1] = dummyfunc;
    strcpy(topmenu.line[2],"Revenue");      topmenu.funcptr [2] = dummyfunc;
    strcpy(topmenu.line[3],"Taxes");        topmenu.funcptr [3] = dummyfunc;
    strcpy(topmenu.line[4],"Insurance");    topmenu.funcptr [4] = dummyfunc;
    strcpy(topmenu.line[5],"Update");       topmenu.linemode[5] = TO_SUB_MENU;
                                            topmenu.linknum [5] = UPDATE_MENU;
    strcpy(topmenu.line[6],"Years");        topmenu.linemode[6] = TO_DATA_WNDW;
                                            topmenu.linknum [6] = UBYTES_DW;
                                            topmenu.funcptr [6] = dummyfunc;
    topmenu.msglinenum  = MAIN_ML;
    topmenu.helpwndwnum = IRSMENU_HW;
    savemainmenu();

    getmainmenu( QUIT_MENU );
 /* topmenu.menumode=EXEC_CHOICE; */    /* this is the default */
    strcpy( topmenu.title, "Quit" );
    strcpy( topmenu.line[0], "Stay" );
    strcpy( topmenu.line[1], "Quit" );      topmenu.funcptr[1] = setquit;
    topmenu.backtodefault = 1;
    topmenu.msglinenum  = MAIN_ML;
    topmenu.helpwndwnum = EXECCHOICE_HW;
    savemainmenu();

    /*---------------------- set up your submenus here: --------------------*\
       Careful! -- indexes to submenus must be numbered in order of level;
       i.e., all submenus first, all subsubmenus second, all
       subsubsubmenus, ... etc.
    */

#ifdef USE_SUBMENU_CODE

    getsubmenu( TIRES_MENU );
    topmenu.menumode=SINGLE_CHOICE;         topmenu.singleflagline=4;
    strcpy( topmenu.line[0], "Brands" );    topmenu.linemode[0]=TO_SUB_MENU;
                                            topmenu.linknum [0]=BRANDS_MENU;
    strcpy( topmenu.line[1], "Radials" );
    strcpy( topmenu.line[2], "Knobbies" );
    strcpy( topmenu.line[3], "Track" );
    strcpy( topmenu.line[4], "Snow" );
    strcpy( topmenu.line[5], "All-Weather" );
    strcpy( topmenu.line[6], "4-ply" );
    topmenu.msglinenum  = SUB_ML;
    topmenu.helpwndwnum = SINGLECHOICE_HW;
    savesubmenu();

    getsubmenu( RADIO_MENU );
    topmenu.menumode=MULTIPLE_CHOICE;
    strcpy( topmenu.line[0], "FM Stereo" ); topmenu.flagged[0]=1;
    strcpy( topmenu.line[1], "AM Radio" );  topmenu.flagged[1]=1;
    strcpy( topmenu.line[2], "Tape player" );
    strcpy( topmenu.line[3], "Compact Disc" );
    topmenu.defaultline = 3;
    topmenu.msglinenum  = SUB_ML;
    topmenu.helpwndwnum = MULTIPLECHOICE_HW;
    savesubmenu();

    getsubmenu( DATE_MENU );
 /* topmenu.menumode=EXEC_CHOICE; */  /* this is the default */
    strcpy( topmenu.line[0], "Month" );     topmenu.linemode[0]=TO_DATA_WNDW;
                                            topmenu.linknum [0]=MONTH_DW;
                                            topmenu.funcptr [0]=datemenu1;
    strcpy( topmenu.line[1], "Day" );       topmenu.linemode[1]=TO_DATA_WNDW;
                                            topmenu.linknum [1]=DAY_DW;
                                            topmenu.funcptr [1]=datemenu2;
    strcpy( topmenu.line[2], "Year" );      topmenu.linemode[2]=TO_DATA_WNDW;
                                            topmenu.linknum [2]=YEAR_DW;
                                            topmenu.funcptr [2]=datemenu3;
    topmenu.backtodefault = 1;
    topmenu.msglinenum  = SUB_ML;
    topmenu.helpwndwnum = DATEMENU_HW;
    savesubmenu();

    getsubmenu( UPDATE_MENU );
 /* topmenu.menumode=EXEC_CHOICE; */   /* this is the default */
    strcpy(topmenu.line[0],"1 process");  topmenu.funcptr[0]=dummyfunc;
    strcpy(topmenu.line[1],"2 process and pop");
                                          topmenu.funcptr[1]=processthenpop;
    strcpy(topmenu.line[2],"3 pop and process");
                                          topmenu.funcptr[2]=popthenprocess;
    strcpy(topmenu.line[3],"4 pop, process, pull");
                                          topmenu.funcptr[3]=popprocessandpull;
    strcpy(topmenu.line[4],"5 pop, pull to Years");
                                          topmenu.funcptr[4]=popnumoflevels;
    strcpy(topmenu.line[5],"6 pop, pull Radio");
                                          topmenu.funcptr[5]=poptonewmenu;
    topmenu.defaultline = 3;
    topmenu.msglinenum  = SUB_ML;
    topmenu.helpwndwnum = UPDATEMENU_HW;
    savesubmenu();

    /* here's a subsubmenu: */
    getsubmenu( BRANDS_MENU );
    topmenu.menumode=SINGLE_CHOICE;        topmenu.singleflagline=1;
    strcpy( topmenu.line[0], "Michelin" );
    strcpy( topmenu.line[1], "General" );
    strcpy( topmenu.line[2], "Firestone" );
    strcpy( topmenu.line[3], "Bridgestone" );
    strcpy( topmenu.line[4], "WeatherGuard" );
    topmenu.defaultline = 2;
    topmenu.msglinenum  = SUB_ML;
    topmenu.helpwndwnum = BRANDSMENU_HW;
    savesubmenu();

#endif

    /*---------------------- set up your help windows here: -----------------*/
    /* helpwndw[0] is reserved for the work window. */
    /* helpwndw[1] is reserved for the top menu. */

#ifdef USE_HELPWNDW_CODE
    helpmsglinenum = HELP_ML;      /* standard message for a help window */
    sethelplines( WORKWNDW_HW,       HL_W1,   HL_WL   );
    sethelplines( TOPLINE_HW,        HL_T1,   HL_TL   );
    sethelplines( FILESMENU_HW,      HL_F1,   HL_FL   );
    sethelplines( DIRMENU_HW,        HL_DIR1, HL_DIRL );
    sethelplines( ENTERDATAMENU_HW,  HL_E1,   HL_EL   );
    sethelplines( BRANDSMENU_HW,     HL_B1,   HL_BL   );
    sethelplines( IRSMENU_HW,        HL_I1,   HL_IL   );
    sethelplines( DATEMENU_HW,       HL_D1,   HL_DL   );
    sethelplines( UPDATEMENU_HW,     HL_U1,   HL_UL   );
    sethelplines( EXECCHOICE_HW,     HL_X1,   HL_XL   );
    sethelplines( SINGLECHOICE_HW,   HL_S1,   HL_SL   );
    sethelplines( MULTIPLECHOICE_HW, HL_M1,   HL_ML   );
    sethelplines( NUMERIC_HW,        HL_N1,   HL_NL   );
    sethelplines( TEXT_HW,           HL_TX1,  HL_TXL  );

    /*------------------- set up your help lines here: ----------------------*/
    strcpy(helpline[HL_W1],"              WELCOME TO PULLC20.ARC");
    strcpy(helpline[HL_W2],"To move the data entry highlight to the desired");
    strcpy(helpline[HL_W3],"field, use the following keys:");
    strcpy(helpline[HL_W4],"  \x1B/\x1A            - LEFT/RIGHT");
    strcpy(helpline[HL_W5],"  \x18/\x19            - UP/DOWN nearest cursor");
    strcpy(helpline[HL_W6],"  Home/Ctrl \x1B    - First one on the row.");
    strcpy(helpline[HL_W7],"  End /Ctrl \x1A    - Last one on the row");
    strcpy(helpline[HL_W8],"  PgUp/Ctrl-Home - First in sequence");
    strcpy(helpline[HL_W9],"  PgDn/Ctrl-End  - Last  in sequence");
    strcpy(helpline[HL_W10],"  Tab/Shift Tab  - next in sequence");
    strcpy(helpline[HL_WL],"Any non-extended key will begin editing the "
                           "field.");

    strcpy(helpline[HL_T1],"Move cursor and press return OR type a command");
    strcpy(helpline[HL_TL],"letter.  ESC to return to the Work window.");

    strcpy(helpline[HL_B1],"Notice the number of levels for the menus.  This");
    strcpy(helpline[HL_B2],"menu is a \"Single Choice\" menu, but you can "
                           "choose");
    strcpy(helpline[HL_B3],"from 1 of 3 menu modes:");
    strcpy(helpline[HL_B4],"  1. EXEC_CHOICE     - process only");
    strcpy(helpline[HL_B5],"  2. SINGLE_CHOICE   - flag and process");
    strcpy(helpline[HL_BL],"  3. MULTIPLE_CHOICE - toggle flag and process");

    strcpy(helpline[HL_F1],"This is a \"Single Choice\" menu, but there are ");
    strcpy(helpline[HL_F2],"5 of the 8 possible line modes used here:");
    strcpy(helpline[HL_F3],"* 1. CHOICE       - interact with other menu "
                           "choices");
    strcpy(helpline[HL_F4],"  2. EXEC_ONLY    - process but do not flag");
    strcpy(helpline[HL_F5],"  3. NO_CHOICE    - temporarily disabled");
    strcpy(helpline[HL_F6],"* 4. COMMENT      - bypassed by highlight");
    strcpy(helpline[HL_F7],"* 5. PARTITION    - mid-menu border");
    strcpy(helpline[HL_F8],"* 6. TO_DATA_WNDW - pulls data entry window");
    strcpy(helpline[HL_F9],"  7. TO_SUB_MENU  - pulls next submenu level");
    strcpy(helpline[HL_F10],"* 8. TO_USER_WNDW - like EXEC_ONLY plus menu "
                            "symbol");
    strcpy(helpline[HL_FL],"Any combination of the eight works!");

    strcpy(helpline[HL_E1],"Each data entry window can be tailored to any of");
    strcpy(helpline[HL_E2],"the following types of data:");
    strcpy(helpline[HL_E3],"  1. Byte          - -128..127");
    strcpy(helpline[HL_E4],"  2. Unsigned byte - 0..255");
    strcpy(helpline[HL_E5],"  3. Int           - -32768..32767");
    strcpy(helpline[HL_E6],"  4. Unsigned int  - 0..65535");
    strcpy(helpline[HL_E7],"  5. Long          - -2147483648..2147483647");
    strcpy(helpline[HL_E8],"  5. Unsigned long - 0..4294967295");
    strcpy(helpline[HL_E9],"  6. Float         - any format");
    strcpy(helpline[HL_E10],"  7. Double        - any format" );
    strcpy(helpline[HL_E11],"  8. UserNums - user defined numbers, like hex");
    strcpy(helpline[HL_E12],"  9. Char     - one character");
    strcpy(helpline[HL_E13]," 10. String   - any length");
    strcpy(helpline[HL_E14],"Data entry will check validity, range, and "
                            "user-");
    strcpy(helpline[HL_E15],"defined limits.   You can limit data entry to");
    strcpy(helpline[HL_E16],"valid characters only.  Field length and labels");
    strcpy(helpline[HL_EL],"are also user-defined.");

    strcpy(helpline[HL_I1],"This is an \"Execute Choice\" menu.  Be sure to "
                           "see");
    strcpy(helpline[HL_I2],"the example of sequential data entry on \"Date\" "
                           "and");
    strcpy(helpline[HL_IL],"menu control on \"Update\".");

    strcpy(helpline[HL_D1],"This is an \"Execute Choice\" menu, but there are "
                           "no");
    strcpy(helpline[HL_D2],"\"choice\" lines.  Instead, the lines are all "
                           "data");
    strcpy(helpline[HL_D3],"entry lines that have been made to allow either");
    strcpy(helpline[HL_DL],"random or sequential access.  Start with "
                           "\"Month\".");

    strcpy(helpline[HL_U1],"This is an \"Execute Choice\" menu.  This one "
                           "will");
    strcpy(helpline[HL_U2],"show you a few of the possibilities of actually");
    strcpy(helpline[HL_UL],"controlling the menus themselves.");

    strcpy(helpline[HL_X1],"        This is an \"Execute Choice\" menu.");
    strcpy(helpline[HL_X2],"         Notice that there are no flags.");
    strcpy(helpline[HL_XL],"   \"\xF0\" means linked submenu; \""
                           "\xFA\" - datawndw.");

    strcpy(helpline[HL_S1],"         This is a \"Single Choice\" menu.");
    strcpy(helpline[HL_S2],"          Notice there's only one flag.");
    strcpy(helpline[HL_SL],"   \"\xF0\" means linked submenu; \""
                           "\xFA\" - datawndw.");

    strcpy(helpline[HL_M1],"        This is a \"Multiple Choice\" menu.");
    strcpy(helpline[HL_M2],"              Notice several flags.");
    strcpy(helpline[HL_ML],"   \"\xF0\" means linked submenu; \""
                           "\xFA\" - datawndw.");

    strcpy(helpline[HL_DIR1],"Directory can optionally default to a closely");
    strcpy(helpline[HL_DIR2],"matching name, if any, in the file name entry");
    strcpy(helpline[HL_DIR3],"field.  Pressing CR replaces the name.  Cursor "
                             "and");
    strcpy(helpline[HL_DIR4],"letter keys move the highlight:");
    strcpy(helpline[HL_DIR5],"  Letter key  - find name with same first "
                             "letter");
    strcpy(helpline[HL_DIR6],"  \x18/\x19         - move UP/DOWN");
    strcpy(helpline[HL_DIR7],"  Home/End    - move to upper/lower file name");
    strcpy(helpline[HL_DIR8],"  PgUp/PgDn   - move UP/DOWN a page");
    strcpy(helpline[HL_DIR9],"  ^Home/^End  - move to TOP/BOTTOM file name");
    strcpy(helpline[HL_DIRL],"  ^PgUp/^PgDn - move to TOP/BOTTOM page");

    strcpy(helpline[HL_N1],"This is a data entry field for numbers. Only "
                           "valid");
    strcpy(helpline[HL_N2],"numbers and symbols can be typed.  Full editing");
    strcpy(helpline[HL_N3],"capability:");
    strcpy(helpline[HL_N4],"  1. WordStar keys: ^A,^S,^D,^F,^G,^H,^R,^Y,^U");
    strcpy(helpline[HL_N5],"  2. Cursor keys:   Home/End, LEFT/RIGHT Arrow,");
    strcpy(helpline[HL_N6],"     Ctrl-LEFT/RIGHT Arrow, and Ins/Del.");
    strcpy(helpline[HL_NL],"  3. Use ^R or ^U to restore original data.");

    strcpy(helpline[HL_TX1],"This is a data entry field for text.  Only "
                            "valid");
    strcpy(helpline[HL_TX2],"letters can be typed.  Full editing capability:");
    strcpy(helpline[HL_TX3],"  1. WordStar keys: ^A,^S,^D,^F,^G,^H,^R,^Y,^U");
    strcpy(helpline[HL_TX4],"  2. Cursor keys:   Home/End, LEFT/RIGHT Arrow,");
    strcpy(helpline[HL_TX5],"     Ctrl-LEFT/RIGHT Arrow, and Ins/Del.");
    strcpy(helpline[HL_TXL],"  3. Use ^R or ^U to restore original data.");
#endif

    /*------------------ set up your message lines here: --------------------*\
      Concatenations here allow source to print on 80 col printer.
      All messages up to HELP_ML are reserved.
    */

#ifdef USE_MSGLINE_CODE
    strcpy(msgline[WORK_ML]," F1-help  F2-pull  F10-TOP");
    strcpy(msgline[TOP_ML], " F1-help  F2-pop   LTR-cmd  ESC-return  "
                            "        \x1B\x1A hilight            CR-select" );
    strcpy(msgline[ALT_ML], " Alt: F-Files  D-Directory  P-Path      "
                            "                                 X-Exit");
    strcpy(msgline[MAIN_ML]," F1-help  F2-pop   LTR-cmd  ESC-return  "
                            "        \x1B\x1A menus  \x18\x19-hilight  "
                            "CR-select");
    strcpy(msgline[SUB_ML], " F1-help  F2-pop   LTR-cmd  ESC-return  "
                            "                  \x18\x19-hilight  CR-select" );
    strcpy(msgline[DW_ML],  " F1-help  F2-pop   F10-TOP  ESC-restore "
                            "                              CR-enter");
    strcpy(msgline[DE_ML],  " F1-help  F2-pull  F10-TOP  ESC-restore "
                            "                              CR-enter");
    strcpy(msgline[SEQ_ML], " F1-help  F2-pull  F10-TOP              "
                            "                              CR-edit");
    strcpy(msgline[HELP_ML]," F1-return         LTR-cmd  ESC-return");
    strcpy(msgline[FUNC_ML]," Processing ...");
    strcpy(msgline[DIR_ML], " F1-help  F2-pop   F10-TOP  ESC-return  "
                            "              LTR/\x18\x19-hilight  CR-select" );
#endif
}

/*=========================== getoverridestats ==============================*\
You can override the automatic colors, sizes, and locations here.
\*---------------------------------------------------------------------------*/
void getoverridestats(void)
{
    strcpy( dirmenu.title, "Directory" );
    dirmenu.menulines = crt_rows-7;
    dirmenu.row   = 4;
    dirmenu.rows  = crt_rows-5;
    dirmenu.col   = mainmenu[FILES_MENU].col+mainmenu[FILES_MENU].cols-2;
    dirmenu.cols  = 16;
    dirmenu.battr = BROWN_BG;
    dirmenu.wattr = BROWN_BG;
    if(qvideo_mode==MONO)
         dirmenu.hattr  = LIGHTGRAY_BG;
    else dirmenu.hattr  = YELLOW;
    dirmenu.border = submenubrdr;
    dirmenu.msglinenum  = DIR_ML;
    dirmenu.helpwndwnum = DIRMENU_HW;

#ifdef USE_SUBMENU_CODE
    submenu[BRANDS_MENU].wattr = BLACK+BROWN_BG;
    submenu[BRANDS_MENU].battr = BLACK+BROWN_BG;
    if(qvideo_mode!=MONO) {
        submenu[BRANDS_MENU].hattr = YELLOW+BLACK_BG;
        submenu[BRANDS_MENU].lattr = YELLOW+BROWN_BG;
    }
#endif

#ifdef USE_HELPWNDW_CODE
    helpwndw[ENTERDATAMENU_HW].row+=1;    /* move large window down one */
#endif

    /* the next lines change the command letters on main menus "File" and
       "EnterData" to other than 1st letters.  "\xFF" is for inaccessible
       lines.
    */
    strcpy( mainmenu[FILES_MENU].cmdltrs, "PMD\xFFSBO" );
    strcpy( mainmenu[ENTER_DATA_MENU].cmdltrs, "BUILDHCS" );
}

void setworkwndw( int wn )
{
    pulldown        = 0;
    poptoworkwndw   = 1;
    topworkwndwname = wn;
}

/*==========================| checkglobalkeys |==============================*\
| This function gives you the option to add global keys similar to the ones   |
| in the TC environment, such as alt-r or alt-f3.  This is for extended keys  |
| only.                                                                       |
\*---------------------------------------------------------------------------*/
void checkglobalkeys(void)
{
    pulldown = 1;

    switch(key) {
        case POPKEY:  pulldown=0; poptoworkwndw=1;    break;        /* f2 */
        case TOPKEY1: poptotop=1;                     break;        /* f10 */
        case ALTF:    setcmdseq ("F");                break;
        case ALTC:    setcmdseq ("C");                break;
        case ALTA:    setcmdseq ("A");                break;
        case ALTE:    setcmdseq ("E");                break;
        case ALTO:    setcmdseq ("O");                break;
        case ALTU:    setcmdseq ("U");                break;
        case ALTI:    setcmdseq ("I");                break;
        case ALTQ:    setcmdseq ("Q");                break;
        case ALTD:    setcmdseq ("FD");               break;
        case ALTP:    setcmdseq ("FP");               break;
        case ALTX:    setquit();                      break;
        default:      pulldown=0;                     break;
    }
}
