// see video.txt for what is returned and what is needed in regs

#ifndef __VIDEO_H__
#define __VIDEO_H__

#include <stddef.h>

#include <vesa.h>

struct mouse_user {
  word x;
  word y;
  word but;
};

//FONT HEADER!!  Added in QLIB v1.1
struct fnthead {
  byte head[4];   //='FNT',27
  word x;
  word y;
  byte bpp;   //bits / pixel  (ignored)
  byte bypp;  //bytes / pixel
  byte flg;   //(bit 1=mono-colored font - g_setfntcolor())
};

#define G_TEXT 1
#define G_VGA 2
#define G_VESA 3
#define G_MODEX 4

#ifdef __cplusplus
  extern "C" {
#endif

//video sub-system
extern sdword g_getmode (word,word,byte);
extern void g_setmode (void);
extern sdword t_setmode (byte,byte);
extern void *t_savestate (void);
extern void t_restorestate (void *);

extern void g_copy (void);      //copies buffer to VRAM
extern void g_setbuf (void *);
extern void g_setpal (void *);  //768 bytes expected
extern void g_setcol (byte n,byte r,byte g,byte b);
extern void g_get (void *a,dword x1,dword y1,dword x2,dword y2);
extern void g_put (void *a,dword x1,dword y1,dword x2,dword y2);
extern void g_put0 (void *a,dword x1,dword y1,dword x2,dword y2);
extern void g_waitvsync (void);      

extern sbyte mouse_init (void);
extern void mouse_uninit (void);
extern void mouse_setcursor (void *a,word x,word y,word hx,word hy);
extern void mouse_setcursor_text (byte);
extern void mouse_setspd (byte x,byte y);
extern void mouse_setwin (dword x1,dword y1,dword x2,dword y2);
extern void mouse_on (void);
extern void mouse_off (void);

extern void mouse_setuser (dword,struct mouse_user*);
extern void mouse_setpos (dword x,dword y);

extern byte * g_loadfnt (char *n);   //FIX v2.03 Beta #2
extern void g_setfnt (void *);       //FIX v2.03 Beta #2
extern void g_setfntcolor (dword);
extern void g_putch (dword x,dword y,char ch);
extern void g_printxy (dword x,dword y,char *s);
extern void g_printf (dword x,dword y,char * s,...);

extern void g_hline (dword x1,dword y,dword x2,dword col);
extern void g_vline (dword x1,dword y,dword x2,dword col);
extern void g_box   (dword x1,dword y1,dword x2,dword y2,dword col);
extern void g_boxfill (dword x1,dword y1,dword x2,dword y2,dword col);
extern void g_cls (void);

extern dword _v_buffer;   //buffer you have alloc (set by gsetbuf())
extern dword _v_linear;   //linear addr to VRAM (may not be 0a0000h under VESA 2.0)

//vesa
extern sbyte vesa_init(void);
extern void vesa_func06(void);
extern void vesa_setstart(dword,dword);
extern sbyte vesa_firstmode(void);
extern sbyte vesa_nextmode(void);

extern struct vesa_infoblock vesa_info;
extern struct vesa_modeinfoblock vesa_modeinfo;

#ifdef __cplusplus
  }
#endif

#endif
