// I stole this from PMODE/W v1.22
// just to show you that sin() and WATCOM works

/*****************************************************************************

  This is a simple example of some graphics functions in C. I got a bit bored
one day so I decided to make this little plasma. The original idea came from
Jare/VangeliSTeam's VTIRIS and was converted to C just for fun. This program
also makes use of floating point and inline ASM just to show that they do
indeed work under PMODE/W.

NOTE: There is a bug in wcc386.  You must be very careful when using ASM {}
  blocks inside funcs when the ASM instruction use parameters given to
  the function.  Hopefully Watcom V11 will fix this.  This program has
  been rewritten to avoid the Watcom Bug. (this bug of course only occurs
  when using iASM - a utility to allow ASM {} blocks to be inserted in
  Watcom C files.)

*****************************************************************************/

#include <qlib.h>
#include <string.h>
#include <math.h>
#include <video.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

double pi=3.141592654;
dword scale=2;
dword speed=1;
dword clr1=0;
dword clr2=2;
dword rx=320;
dword ry=200;
dword wait=0;

dword spd1=1;
dword spd2=2;
dword spd3=1;
dword spd4=3;

dword idx1=1;
dword idx2=2;
dword idx3=1;
dword idx4=3;

void editnum(dword * n,dword min,dword max) {
  printf("Enter new #:");
  scanf("%d",n);
  if (*n < min) *n=min;
  if (*n > max) *n=max;
}

void editfloat(double * n) {
  printf("Enter new #:");
  scanf("%f",n);
}

void main ()
{
  static byte wavetable[256], pal[768];

  dword  v, x, y;

  byte z,ch;
  byte *vidmem;

  byte pos1 = 0, pos2 = 0, pos3 = 0, pos4 = 0;
  byte tpos1, tpos2, tpos3, tpos4;
 
  if (!_fpu)
  {
    printf("No 80387 detected!\n");
    exit(0);
  }

  do
  {
    do
    {
      t_setmode(80,25);
      printf("                 Plasma Grafix Demo v1.1\n\n\n");
      printf(" Variables:     Note: Possibly video modes (320x200,640x480,etc.)\n");
      printf("  a) Speed Scale = %d\n",speed);
      printf("  b) Grafix Scale = %d\n",scale);
      printf("  c) Colour #1 (0-2) (RGB)= %d\n",clr1); 
      printf("  d) Colour #2 (0-2) (RGB)= %d\n",clr2); 
      printf("  x) X = %u\n",rx);
      printf("  y) Y = %u\n",ry);
      printf("  1) Speed1 = %d\n",spd1);
      printf("  2) Speed2 = %d\n",spd2);
      printf("  3) Speed3 = %d\n",spd3);
      printf("  4) Speed4 = %d\n",spd4);
      printf("  5) Index1 = %d\n",idx1);
      printf("  6) Index2 = %d\n",idx2);
      printf("  7) Index3 = %d\n",idx3);
      printf("  8) Index4 = %d\n",idx4);
      printf("  p) PI = %.10f\n",pi);
      printf("  v) Vsync checks = ");
      (wait) ? printf("ON\n\n") : printf("OFF\n\n");
      printf("  G) Go Display Plasma\n");
      printf("  Q) Quit\n\n:>");
      ch=toupper(getch());
      switch (ch)
      {
        case 'A':
          editnum(&speed,1,100);
          break;
        case 'B':
          editnum(&scale,1,100);
          break;
        case 'C':
          editnum(&clr1,0,2);
          break;
        case 'D':
          editnum(&clr2,0,2);
          break;
        case 'X':
          editnum(&rx,80,2048);
          break;
        case 'Y':
          editnum(&ry,50,2048);
          break;
        case 'V':
          wait^=1;
          break;
        case '1':
          editnum(&spd1,1,100);
          break;
        case '2':
          editnum(&spd2,1,100);
          break;
        case '3':
          editnum(&spd3,1,100);
          break;
        case '4':
          editnum(&spd4,1,100);
          break;
        case '5':
          editnum(&idx1,1,100);
          break;
        case '6':
          editnum(&idx2,1,100);
          break;
        case '7':
          editnum(&idx3,1,100);
          break;
        case '8':
          editnum(&idx4,1,100);
          break;
        case 'P':
          editfloat(&pi);
          break;
        case 'Q':
          clrscr();
          return;
      }
    } while (ch!='G');
    if (g_getmode (rx,ry,8)==ERROR)
    {
      printf("Video mode not available!\nPress a key...");
      getch();
      continue;
    }
    g_setmode();
    vidmem=malloc(rx*ry);
    if (vidmem==NULL) {
      t_setmode(80,25);
      printf("Out of memory!");
      getch();
      continue;
    }
    g_setbuf(vidmem);

    pos1 = pos2 = pos3 = pos4 = 0;

    for (x=0;x<768;x++) pal[x]=0;

    for (x=0, y=0; x<64*3; x+=3, y++)
      pal[x+clr1] = y;

    for (x=64*3, y=63; x<128*3; x+=3, y--)
      pal[x+clr1] = y;

    for (x=128*3, y=0; x<192*3; x+=3, y++)
      pal[x+clr2] = y;

    for (x=192*3, y=63; x<256*3; x+=3, y--)
      pal[x+clr2] = y;

    _int3_();
    for (x=0; x<256; x++)
      wavetable[x] = (int)(30.0f * (1.0f + sin(x * 2.0f * pi / 256.0f)));

    g_setpal (&pal);

    while (!kbhit ())
    {
      v = 0;
      tpos1 = pos1;
      tpos2 = pos2;

      for (y=0; y<ry; y++)
      {
        tpos3 = pos3;
        tpos4 = pos4;

        for(x=0; x<rx; x++)
        {
          z = wavetable[tpos1] + wavetable[tpos2] +
              wavetable[tpos3] + wavetable[tpos4];

          vidmem[v ++] = z;
 
          tpos3 += idx3*scale;
          tpos4 += idx4*scale;
        }

        tpos1 += idx1*scale;
        tpos2 += idx2*scale;
      }

      if (wait) g_waitvsync();
      g_copy();

      pos1 += spd1*speed;
      pos2 -= spd2*speed;
      pos3 += spd3*speed;
      pos4 -= spd4*speed;
    }
    getch();
    free(vidmem);
  } while (1);
}

