// Creates a simple font file (8*8)

// FIX : 32bit created properly now
// NEW : mono-colored fonts 

#include <qlib.h>
#include <string.h>
#include <mem.h>
#include <dos.h>
#include <io.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <fCNTL.H>

int f;
word a,x,y;
dword p=0;
byte buf[8*8*256*4];
byte * vga=(byte *)0xa0000;
byte flg=0;
byte t;
byte bypp,bpp;

struct
{
  byte head[4];
  word x;
  word y;
  byte bpp;
  byte bypp;
  byte flg;
} fnthead;

void usage(void)
{
  printf("Usage : FONT bypp outfile [/M] \n",a);
  printf("  bypp = target bytes/pixel (8,15,16,24 or 32)\n");
  printf("  /M = create mono-coloured font\n");
  exit(0);
}  

void main (byte _argc,byte **_args)
{
  if ((_argc<3)||(_argc>4)) usage();
  bpp=atoi(_args[1]);
//  printf("bpp=%d",bpp);
  f=open(_args[2],O_BINARY|O_CREAT|O_TRUNC|O_WRONLY);
  if (f==-1)
  {
    printf("file io error\n");
    exit(0);
  }

  switch (bpp) {
    case 8:bypp=1;break;
    case 15:
    case 16:
    case 24:bypp=2;break;
    case 32:bypp=4;flg=1;break;
    default:usage();
  }

  strcpy(fnthead.head,"FNT");
  fnthead.head[3]=0x1a;
  fnthead.x=8;
  fnthead.y=8;
  fnthead.bpp=bpp;
  fnthead.bypp=bypp;
  fnthead.flg=0;
  if (_argc==4)
  {
    if ( (!memcmp(_argv[3],"/M",2)) || (!memcmp(_argv[3],"/m",2)))
    {
      fnthead.flg=1;
//      printf("Mono Font");
//      getch();
    }
  }
  write(f,&fnthead,sizeof(fnthead));
  asm
  {
    mov ax,13h
    int 10h
  }

  if (flg) bypp--;

  for (a=0;a<256;a++)
  {
    gotoxy(1,1);
    if (a!=7) printf("%c",a); else printf(" ");
    for(y=0;y<8;y++)
    {
      for(x=0;x<8;x++)
      {
        if (*(vga+y*320+x))
        {
          if (bypp==1) for(t=0;t<bypp;t++) buf[p++]=31;
            else for(t=0;t<bypp;t++) buf[p++]=255;
          if (flg) buf[p-1]=0;  //last byte in 32bit fonts
        } else
        {
          for(t=0;t<bypp;t++) buf[p++]=0;
        }
      }
    }
  }
  if (flg) bypp++;
  asm
  {
    mov ax,3
    int 16     //set text mode
  }
  write(f,buf,8*8*256*bypp);
  close(f);
  printf("done\n");
}



