// Creates some sample mouse pointer files (8*8)

#include <qlib.h>
#include <string.h>
#include <mem.h>
#include <dos.h>
#include <io.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <fCNTL.H>
#include <video.h>

word a,b;
sword f;
byte bypp;

byte Buf[8*8*4];

byte buf1[8*8]={
 01,01,01,01,01,01,01,01,
 01,01,01,01,01,01,01,00,
 01,01,01,01,01,00,00,00,
 01,01,01,01,01,00,00,00,
 01,01,01,01,01,01,00,00,
 01,01,00,00,01,01,01,00,
 01,00,00,00,00,01,01,01,
 01,00,00,00,00,00,01,00 };

byte buf2[8*8]={
 01,01,01,01,01,01,01,01,
 00,01,01,01,01,01,01,00,
 00,00,00,01,01,00,00,00,
 00,00,00,01,01,00,00,00,
 00,00,00,01,01,00,00,00,
 00,00,00,01,01,00,00,00,
 00,01,01,01,01,01,01,00,
 01,01,01,01,01,01,01,01 };

struct g_mousehead mh;

void writeptr(char *fn,byte bpp,byte *buf);

void main (void)
{
  writeptr("8-PTR.PTR",8,buf1);        //basic pointer
  writeptr("15-PTR.PTR",15,buf1);
  writeptr("16-PTR.PTR",16,buf1);
  writeptr("24-PTR.PTR",24,buf1);
  writeptr("32-PTR.PTR",32,buf1);

  writeptr("8-HG.PTR",8,buf2);         //hour glass
  writeptr("15-HG.PTR",15,buf2);
  writeptr("16-HG.PTR",16,buf2);
  writeptr("24-HG.PTR",24,buf2);
  writeptr("32-HG.PTR",32,buf2);

  printf("Done!\n");
}

void writeptr(char *fn,byte bpp,byte *buf) {
  byte flg=0;
  word p;

  f=open(fn,O_BINARY|O_CREAT|O_TRUNC|O_WRONLY);
  if (f==-1)
  {
    printf("file io error\n");
    exit(0);
  }

  switch (bpp) {
    case 8:bypp=1;break;
    case 15:
    case 16:bypp=2;break;
    case 24:bypp=3;break;
    case 32:bypp=4;flg=1;break;
  }

  strcpy(mh.head,"PTR");
  mh.head[3]=0x1a;
  mh.x=8;
  mh.y=8;
  mh.bpp=bpp;
  mh.bypp=bypp;
  mh.flg=0;
  mh.hx=0;
  mh.hy=0;

  write(f,&mh,sizeof(mh));

  if (flg) bypp--;

  p=0;
  for (a=0;a<8*8;a++) {
    for (b=0;b<bypp;b++) {
      if (bypp==1)
        *(Buf+p++)=*(buf+a);
      else
        *(Buf+p++)=*(buf+a) ? 0xff : 0;
    }
    if (flg) *(Buf+p++)=0;  //for last byte in 32bit PTRs
  }

  if (flg) bypp++;

  write(f,Buf,8*8*bypp);
  close(f);
}



