/* ------------------------------------------------------------------------ */
/*                                                                          */
/*      Some basic things.                                                  */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#define upcase(ch) ((in(ch,'a','z'))?(ch-32):(ch))

void memset16(USHORT * dest, SHORT val, INT len)  // fills short-array with 
{                                                 // value 
   while (len--)
      *(dest++) = val;
}

INT  cancel(void)               // checks whether to interrupt the program
{
#if DOS
   while (kbhit())
   {
      if (getch() == 27)
         f_err = ERR_USER;
   }
#endif
   return (f_err);
}

INT  wrask(CHAR * s)            // prompt-routine
{
   INT  ch;

   printf("\n %s (Yes,Always,No,Cancel) ", s);
   flush;
   do
   {
      ch = getch();
      ch = upcase(ch);
   }
   while (ch != 'Y' && ch != 'A' && ch != 'N' && ch != 'C' && ch != 27);
   printf("%s", ch == 'Y' ? "Yes" : (ch == 'A' ? "Always" : (ch == 'N' ? "No" : "Cancel")));
   flush;
   return (ch == 'Y' ? 0 : (ch == 'A' ? 1 : (ch == 'N' ? 2 : 3)));
}

void beep(void)                 // makes some noise
{
#if DOS
   sound(800);
   delay(250);
   nosound();
#endif
#if AMIGA
   putchar(0x07);
#endif
}

void my_signalhandler(INT sig_number)  	// sets f_err if ctrl+c or ctrl+brk
{
   f_err = ERR_USER;
   printf("\nUser break\n");
}

#if DOS
                            		// handles hardware errors
INT __far harderrhandler(UINT deverr, UINT errc, UINT __far * devhdr)
{
   f_criterr = 'A' + deverr & 0xff;
   f_err = ERR_OTHER;
   return (0x3);
}
#endif

void set_handler(void)          	// initializes handlers
{
#if DOS
#ifndef __BORLANDC__
   signal(SIGBREAK, my_signalhandler);  // set ctrl-break/-c handlers
#endif
#endif
   signal(SIGINT, my_signalhandler);
#if DOS
   _harderr(harderrhandler);    	// set hardware error handler
#endif
}

