/**************************************************************************
                        VARMINT'S AUDIO TOOLS

  Header file: SOUND.H

  Written by: Peter Sprenger

  Modifications by:  Eric Jorgensen (Feb, 1995)
                    smeagol@rt66.com


 Peter Sprenger's Original Copywrite is as follows:


 * Copyright 1993 by Peter Sprenger   Pete@amber.dinoco.de
 *                   5014 Kerpen 3
 *                   Germany
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The author Peter Sprenger
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.

 In the spirit of Peter's effort, I am offering my modification of his
 library as FREEWARE.  You are free to use it and distribute it as long
 as no fee is charged.

                           **** WARNING ****

 Use Varmint's Audio tools at your own risk.  This code has not undergone
 any sort of rigourous testing and has been found to cause cancer in
 laboratory rats.

**************************************************************************/

#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <alloc.h>
#include <sys\stat.h>
#include <string.h>
#include <values.h>
#include <ctype.h>
                               // More definitions than you can
                               // shake a stick at.
#define VAT_VERSION "0.41"
                               // Pointer type definition for samples.
                               // This definition should be far or
                               // huge.  If you use near, you will have
                               // to change the code to use malloc()
                               // instead of farmalloc()
#define SAMPLE signed char far

#define MAXSOUNDS 16

#define WORD unsigned int
#define DWORD unsigned long int
#define BYTE unsigned char
#define FALSE 0
#define TRUE 1

#define DSP_RESET 6
#define DSP_READ 0x0a
#define DSP_WRITE 0x0c
#define DSP_WSTATUS 0x0c
#define DSP_RSTATUS 0x0e

#define FM_DETECT 1
#define DSP_DETECT 2

#define DSP_DMA_8BIT 0x14
#define DSP_DMA_ADC 0x24
#define DSP_SAMPLE_RATE 0x40

#define DSP_MIDI_WRITE 0x38
#define DSP_MIDI_READI 0x31
#define DSP_MIDI_UART 0x35
#define DSP_SILENCE 0x80
#define DSP_SPKR_ON 0xd1
#define DSP_SPKR_OFF 0xd3
#define DSP_GET_VERS 0xe1

#define DSP_INVOKE_INTR 0xf2

#define FM_BOTH_OFF  0x168
#define FM_LEFT_OFF  0
#define FM_RIGHT_OFF 2

#define FM_HIHAT     1
#define FM_TOPCYM    2
#define FM_TOMTOM    4
#define FM_SNARE     8
#define FM_BASS   0x10

typedef enum {bit8=0,bit4=1,bit26=2,bit2=3,high} playmode;
typedef enum {none,nodsp,adlib,sb20,sbpro} cardtype;
typedef enum {both,left,right} fm_chan;
typedef enum {midi,sample} vect;
typedef enum {fmerr=0,nodsperr,irqerr,dmacherr,nomem} SBERROR;


typedef struct {                      // MIDI Voice data structure
  int owner_track;
  int owner_channel;
  int active;
  int note;
  int volume;
} VOICE;


typedef struct {                      // MIDI data structure
  int format;                         // 0 or 1
  int num_tracks;                     // 1 - 16
  int divisions;                       // number ticks per quarter note
  BYTE *track[16];                    // Track data pointers
} MIDI;

void FM_Write(WORD data);
void FM_Reset(void);
BYTE FM_Status(void);
void FM_SetChan(fm_chan channel);
void FM_SetVoice(BYTE voice,BYTE *ins);
void FM_SetNote(BYTE voice,BYTE note);
void FM_SetFreq(BYTE voice,WORD freq);
void FM_KeyOn(BYTE voice);
void FM_KeyOff(BYTE voice);
void FM_SetVol(BYTE voice,BYTE vol);
void FM_RythmMode(BYTE bool);
void FM_RythmOn(BYTE inst);
void FM_RythmOff(BYTE inst);

void SetRate(WORD rate);

int SB_Setup(void);
                                   // These functions Are not really needed
                                   // outside of sound.c

//int DSP_Reset();
//BYTE DSP_Read();
//void DSP_Write(BYTE output);
//WORD DSP_Get_Version();
//void SB_SetVect();
//void SB_RemoveVect();
//int get_sb_env();
//int CardCheck();
//cardtype WhichCard();
//BYTE int2vect(BYTE intnr);
//void enable_int(BYTE nr);
//void disable_int(BYTE nr);
//void InitT2();
//void measure();
//void dma_set(BYTE far *sound_address,WORD len,BYTE channel);
//WORD polldma(BYTE channel);
//int ReadVarLen(BYTE *data,long int *value);
//long int ReadLong(FILE *infile);
//int ReadShort(FILE *infile);
//void MidiPlayer(void);


/* timerx prototypes */

void timer_on(void);
WORD timer_off(void);
WORD to_micro(WORD clk);
void clkdelay(WORD clicks);
void mdelay(WORD delay);
WORD mcalc(WORD micro);
void Install_Timer0(WORD period,void far (*func)(void));
void Remove_Timer0();
void _saveregs msdelay(WORD delay);


/*  Stuff added by Eric Jorgensen */
                                          // function prototypes
int ReadMidi(char *filename, MIDI **midipoint, char *errstring);
void playsound(SAMPLE *data,DWORD length);
SAMPLE *loadwave(char *wavefile,unsigned long int *length);
void Go_Varmint(void);
void Dropdead_Varmint(void);
int load_instruments(char *filename,BYTE inst[128][11]);
void freemidi(MIDI *m);

                                          // Globals
                                          // The variables athat are
                                          // commented out should
                                          // probably stay that way since
                                          // They are only used internally.
extern MIDI *midi_data;
extern int midi_reset;
extern int midi_on;
extern float midi_tempoadjust;
extern float midi_usertempo;
extern BYTE music_volume;
extern char *errname[];
extern DWORD vclock;
extern SBERROR sberr;
extern WORD DSP_overhead;
extern int sounds_in_queue;
//extern PLAY_SAMPLE *soundlist;
extern WORD dma_bufferlen;
//extern WORD dma_bytesahead;
//extern BYTE far *dma_buffer;
//extern WORD intnr,dma_ch;
extern int debugnum;
//extern float midi_callfreq;
//extern WORD io_addr;


