/* ***********************************************************************
   *									 *
   *	   The Continuous Potential Method for the Mandelbrot Set	 *
   *									 *
   *				Program by				 *
   *			   Christopher D. Watkins			 *
   *									 *
   *			     'C' conversion by				 *
   *                            Larry Sharp				 *
   *									 *
   ***********************************************************************
*/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "math.h"
#include "string.h"
#include "math.inc"
#include "graph.inc"
#include "render.inc"

/*
   125 iterations maximum
*/

#define XMin -2.50
#define XMax  1.35
#define YMin -1.80
#define YMax  1.80
#define Iter  32
#define Scal  32767

char ObjF[]="CPM1";

/*
#define XMin -0.19
#define XMax -0.13
#define YMin  1.01
#define YMax  1.06
#define Iter  125
#define Scal  3276700

char ObjF[]="CPM2";
*/

float MSetPot(float cx, float cy, int MaxIter, int *Iters)
{
  float x, y;
  float x2, y2;
  float temp;

  x=cx;
  x2=SqrFP(x);
  y=cy;
  y2=SqrFP(y);
  *Iters=0;
  while((*Iters<MaxIter) && (x2+y2<20000.0))
  {
    temp=cx+x2-y2;
    y=cy+2*x*y;
    y2=SqrFP(y);
    x=temp;
    x2=SqrFP(x);
    ++*Iters;
  }
  if(*Iters<MaxIter)
    return(0.5*log10(x2+y2)/pow(2, *Iters));
  else
    return(0.0);
}

void MSetCPM(int nx, int ny, int MaxIter, float Xmin, float Xmax, float Ymin, float Ymax)
{
  int ix, iy;
  int Iters;
  float cx, cy;
  float dx, dy;

  dx=(Xmax-Xmin)/(nx-1);
  dy=(Ymax-Ymin)/(ny-1);
  for(iy=0; iy<ny; iy++)
  {
    cy=Ymin+iy*dy;
    for(ix=0; ix<nx; ix++)
    {
      cx=Xmin+ix*dx;
      Height[ix][iy]=Round(MSetPot(cx, cy, MaxIter, &Iters)*Scal);
      PutPixel(ix, iy, (Iters/7), (Iters%35));
    }
  }
}

void InverseHeightBuffer()
{
  int i, j;
  int Max;

  Max=0;
  for(i=0; i<=MaxRes; i++)
  {
    for(j=0; j<=MaxRes; j++)
    {
      if(Height[i][j]>Max)
	Max=Height[i][j];
    }
  }
  for(i=0; i<=MaxRes; i++)
  {
    for(j=0; j<=MaxRes; j++)
    {
      Height[i][j]=Max-Height[i][j];
    }
  }
}

/* ***********************************************************************
   *									 *
   *				Main Program				 *
   *									 *
   ***********************************************************************
*/

void main()
{
  clrscr();
  Scaling=32767;
  Res=MaxRes;
  InitGraphics();
  ClearHeightBuffer();
  MSetCPM(Res, Res, Iter, XMin, XMax, YMin, YMax);
  InverseHeightBuffer();
  strcpy(ObjectFile, ObjF);
  SaveHeightBuffer(ObjectFile);
  ExitGraphics();
}
