
/* ***********************************************************************
   *									 *
   *	  Program for Generation of Description Files for RENDER.C	 *
   *									 *
   *				Program by				 *
   *			   Christopher D. Watkins			 *
   *									 *
   *			     'C' conversion by				 *
   *                            Larry Sharp				 *
   *									 *
   ***********************************************************************

*/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "math.h"
#include "string.h"
#include "math.inc"
#include "graph.inc"
#include "render.inc"

/* ***********************************************************************
   *									 *
   *	  		  Keyboard Response Routines			 *
   *									 *
   ***********************************************************************

   Response       - returns true or flase to a Y or N keyboard stroke
   NumberResponse - returns a 0 to 9 based on keyboard stroke

*/

char NumbResp[6];

void Response()
{
  char c;

  strcpy(NumbResp, "\n");
  while((!(c=='Y')) && (!(c=='N')))
  {
    while(!(kbhit()));
    c=toupper(getch());
  }
  putch(c);
  if(c=='Y')
    strcpy(NumbResp, "true");
  else
    strcpy(NumbResp, "false");
}

void NumberResponse()
{
  char c;

  strcpy(NumbResp, "\n");
  while(!(isdigit(c)))
  {
    c=getch();
  }
  putch(c);
  NumbResp[0]=c;
}

/* ***********************************************************************
   *									 *
   *			   Save Description Data			 *
   *									 *
   ***********************************************************************

   SaveDescription - saves description of object
*/

void SaveDescription(Name FileName)
{
  int NDiv, i;

  strcat(FileName, ".DES");
  TextDiskFile=fopen(FileName, "w+t");
  printf("Display in Half Scale? ");
  Response();
  fprintf(TextDiskFile, "%s\n", NumbResp);
  printf("\nDisplay the Ground? ");
  Response();
  fprintf(TextDiskFile, "%s\n", NumbResp);
  for(i=0; i<8; i++)
  {
    printf("\nColor #%d is ", i);
    GetObjectColor(i);
  }
  puts("");
  if(strcmp(NumbResp, "Y"))
  {
    printf("Ground Color (1-7) = ");
    NumberResponse();
    fprintf(TextDiskFile, "%s\n", NumbResp);
  }
  else
    fprintf(TextDiskFile, "%s\n", "0");
  printf("\nNumber of Height Divisions = ");
  NumberResponse();
  fprintf(TextDiskFile, "%s\n", NumbResp);
  printf("\nEnter Color for each Division : \n");
  NDiv=atoi(NumbResp);
  for(i=1; i<=NDiv; i++)
  {
    printf("Color for %d / %d (1-7) = ", i, NDiv);
    NumberResponse();
    fprintf(TextDiskFile, "%s\n", NumbResp);
    puts("");
  }
  printf("Top Color (1-7) = ");
  NumberResponse();
  fprintf(TextDiskFile, "%s\n", NumbResp);
  printf("\nSpread of Normal Calculation = ");
  NumberResponse();
  fprintf(TextDiskFile, "%s\n", NumbResp);
  printf("\nDirecton of Light\nAround the z-Axis = ");
  gets(NumbResp);
  fprintf(TextDiskFile, "%s\n", NumbResp);
  printf("\n   off the z-Axis = ");
  gets(NumbResp);
  fprintf(TextDiskFile, "%s\n", NumbResp);
  printf("Tilt of the xy-Plane = ");
  gets(NumbResp);
  fprintf(TextDiskFile, "%s\n", NumbResp);
  printf("\nY Offset = ");
  gets(NumbResp);
  fprintf(TextDiskFile, "%s\n", NumbResp);
  fclose(TextDiskFile);
}

void main()
{
  clrscr();
  printf("Program to Generate a Description File for an Object\n\n");
  GetObjectFile();
  SaveDescription(ObjectFile);
}
