/* ***********************************************************************
   *									 *
   *	        	Generate Hemisphere Database			 *
   *									 *
   *				Program by				 *
   *			   Christopher D. Watkins			 *
   *									 *
   *			     'C' conversion by				 *
   *                            Larry Sharp				 *
   *									 *
   ***********************************************************************

*/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "math.h"
#include "string.h"
#include "math.inc"
#include "graph.inc"
#include "render.inc"

void CreatHemiSphereHeightBuffer()
{
  int x, y, r, Offset, z;
  int PhiR, ThetaR;
  float Phi, Theta;
  float RSinPhi1, RCosPhi1;
  float RSinPhi2, RCosPhi2;
  float RSinPhi3, RCosPhi3;
  float RSinPhi4, RCosPhi4;
  float SinTheta, CosTheta;

  Offset=Res/2;
  r=Offset-1;
  MaxHeight=r;
  HeightBufferScalingFactor();
  for(PhiR=0; PhiR<=89; PhiR++)
  {
    Phi=Radians(PhiR);
    RCosPhi1=r*cos(Phi);
    RSinPhi1=r*sin(Phi);
    Phi=Radians(PhiR+90);
    RCosPhi2=r*cos(Phi);
    RSinPhi2=r*sin(Phi);
    Phi=Radians(PhiR+180);
    RCosPhi3=r*cos(Phi);
    RSinPhi3=r*sin(Phi);
    Phi=Radians(PhiR+270);
    RCosPhi4=r*cos(Phi);
    RSinPhi4=r*sin(Phi);
    for(ThetaR=0; ThetaR<=90; ThetaR++)
    {
      Theta=Radians(ThetaR);
      CosTheta=cos(Theta);
      SinTheta=sin(Theta);
      z=Round(CosTheta*Scaling)/2;
      x=Round(SinTheta*RCosPhi1)+Offset;
      y=Round(SinTheta*RSinPhi1)+Offset;
      Height[x][y]=z;
      x=Round(SinTheta*RCosPhi2)+Offset;
      y=Round(SinTheta*RSinPhi2)+Offset;
      Height[x][y]=z;
      x=Round(SinTheta*RCosPhi3)+Offset;
      y=Round(SinTheta*RSinPhi3)+Offset;
      Height[x][y]=z;
      x=Round(SinTheta*RCosPhi4)+Offset;
      y=Round(SinTheta*RSinPhi4)+Offset;
      Height[x][y]=z;
    }
  }
}

/* ***********************************************************************
   *									 *
   *				Main Program				 *
   *									 *
   ***********************************************************************
*/

void main()
{
  clrscr();
  printf("Creating Hemisphere Height Buffer\n");
  ClearHeightBuffer();
  Res=MaxRes;
  CreatHemiSphereHeightBuffer();
  strcpy(ObjectFile, "HMSPHERE");
  SaveHeightBuffer(ObjectFile);
}
