/* ***********************************************************************
   *									 *
   *	        	Generate HemiToroid Database			 *
   *									 *
   *				Program by				 *
   *			   Christopher D. Watkins			 *
   *									 *
   *			     'C' conversion by				 *
   *                            Larry Sharp				 *
   *									 *
   ***********************************************************************

*/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "math.h"
#include "string.h"
#include "math.inc"
#include "graph.inc"
#include "render.inc"

#define ZScale 1.0

char ObjF[]="HMTOROID";

/*
#define ZScale 2.0

char ObjF[]="BOWL";
*/

void CreatHemiToroidHeightBuffer(float Rho, float r)
{
  int ThetaR, PhiR;
  int x, y, z, Offset;
  float Theta, Phi;
  float CosTheta1, SinTheta1;
  float RhoCosTheta1, RhoSinTheta1;
  float CosTheta2, SinTheta2;
  float RhoCosTheta2, RhoSinTheta2;
  float CosTheta3, SinTheta3;
  float RhoCosTheta3, RhoSinTheta3;
  float CosTheta4, SinTheta4;
  float RhoCosTheta4, RhoSinTheta4;
  float RCosPhi, RSinPhi;
  float Zfactor;

  Rho=Rho * (float) Res/2;
  r=r * (float) Res/2;
  Offset=Res/2;
  MaxHeight=Round(r*2);
  HeightBufferScalingFactor();
  Zfactor=ZScale*MaxHeight/4;
  for(ThetaR=0; ThetaR<=89; ThetaR++)
  {
    Theta=Radians(ThetaR);
    CosTheta1=cos(Theta);
    SinTheta1=sin(Theta);
    RhoCosTheta1=Rho*CosTheta1;
    RhoSinTheta1=Rho*SinTheta1;
    Theta=Radians(ThetaR+90);
    CosTheta2=cos(Theta);
    SinTheta2=sin(Theta);
    RhoCosTheta2=Rho*CosTheta2;
    RhoSinTheta2=Rho*SinTheta2;
    Theta=Radians(ThetaR+180);
    CosTheta3=cos(Theta);
    SinTheta3=sin(Theta);
    RhoCosTheta3=Rho*CosTheta3;
    RhoSinTheta3=Rho*SinTheta3;
    Theta=Radians(ThetaR+270);
    CosTheta4=cos(Theta);
    SinTheta4=sin(Theta);
    RhoCosTheta4=Rho*CosTheta4;
    RhoSinTheta4=Rho*SinTheta4;
    for(PhiR=0; PhiR<=180; PhiR++)
    {
      Phi=Radians(PhiR);
      RCosPhi=r*cos(Phi);
      RSinPhi=r*sin(Phi);
      z=Round(RSinPhi*Zfactor);
      x=Round(RCosPhi*CosTheta1+RhoCosTheta1)+Offset;
      y=Round(RCosPhi*SinTheta1+RhoSinTheta1)+Offset;
      Height[x][y]=z;
      x=Round(RCosPhi*CosTheta2+RhoCosTheta2)+Offset;
      y=Round(RCosPhi*SinTheta2+RhoSinTheta2)+Offset;
      Height[x][y]=z;
      x=Round(RCosPhi*CosTheta3+RhoCosTheta3)+Offset;
      y=Round(RCosPhi*SinTheta3+RhoSinTheta3)+Offset;
      Height[x][y]=z;
      x=Round(RCosPhi*CosTheta4+RhoCosTheta4)+Offset;
      y=Round(RCosPhi*SinTheta4+RhoSinTheta4)+Offset;
      Height[x][y]=z;
    }
  }
}
/* ***********************************************************************
   *									 *
   *				Main Program				 *
   *									 *
   ***********************************************************************
*/

void main()
{
  clrscr();
  printf("Creating HemiToroid Height Buffer\n");
  ClearHeightBuffer();
  Res=MaxRes;
  CreatHemiToroidHeightBuffer(0.75, 0.25);
  strcpy(ObjectFile, ObjF);
  SaveHeightBuffer(ObjectFile);
}
