/* ***********************************************************************
   *									 *
   *		Three Dimensional Lorenz Attractor Generator		 *
   *									 *
   *				Program by				 *
   *			   Christopher D. Watkins			 *
   *									 *
   *			     'C' conversion by				 *
   *				Larry Sharp				 *
   *									 *
   ***********************************************************************
*/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "math.h"
#include "math.inc"
#include "graph.inc"

#define Sc          2.2
#define EightThirds 2.6666667

float X, Y, Z;
float T, T9;
float d1, d2, d3;
float Step, Stp;
int   Xo, Yo, Zo;
int   Xn, Yn, Zn;
int   Col=10;
int oldT9=0;
TDA   Pt, Tmp;

void DrawLine()
{
  Byte i;

  Xn=Round(Sc*X);
  Yn=Round(Sc*Y);
  Zn=Round(Sc*Z);
  if(T9==0)
  {
    Xo=Xn;
    Yo=Yn;
    Zo=Zn;
    Vec(Xo, Yo, Zo, Tmp);
  }
  if (oldT9 != (int) T9)
  Col++;
  if (Col >= 245)
	Col = 10;
  if ((Col % 35) < 10)
	Col += 10;
//  Col = (Round(T9) / 25) % 7;
//  Col = Col * 35 + (Round(T9) % 25) + 10;

  Vec(Xn, Yn, Zn, Pt);
  DrawLine3D(Tmp, Pt, Col);
  Xo=Xn;
  Yo=Yn;
  Zo=Zn;
  for(i=0; i<3; i++)
    Tmp[i]=Pt[i];
}

void main()
{
  InitPerspective(false, 0, 0, 500, 500);
  InitPlotting(-45, 35);
  InitGraphics();
  PutAxisAndPalette(true);
  AxisAndPalette();
  X=5.0;
  Y=5.0;
  Z=5.0;
  Col=0;
  Stp=0.01;
  Step=Stp/25;
  T9=0;
  do
  {
    T=T9;
    do
    {
      d1=10*(Y-X);
      d2=28*X-Y-X*Z;
      d3=X*Y-EightThirds*Z;
      X+=d1*Step;
      Y+=d2*Step;
      Z+=d3*Step;
      T+=Step;
    }
    while(T<T9+Step);
    DrawLine();
	oldT9 = T9;
    T9+=Stp;
  }
  while(T9<500);
  ExitGraphics();
}



