/* ***********************************************************************
   *									 *
   *	              	Fractal Landscape Generator			 *
   *									 *
   *				Program by				 *
   *			   Christopher D. Watkins			 *
   *									 *
   *			     'C' conversion by				 *
   *                            Larry Sharp				 *
   *									 *
   ***********************************************************************

*/

#include "stdio.h"
#include "stdlib.h"
#include "dos.h"
#include "conio.h"
#include "math.h"
#include "string.h"
#include "math.inc"
#include "graph.inc"
#include "render.inc"

#define NumberLevels 7
#define MaximumLevel 7
#define Roughness  100

int Points, Space;

void Initialization()
{
  int i;

  randomize();
  Points=1;
  for(i=1; i<=NumberLevels; i++)
    Points*=2;
  Space=1;
  for(i=1; i<=(MaximumLevel-NumberLevels); i++)
    Space*=2;
  MaxHeight=Roughness;
  HeightBufferScalingFactor();
}

int Hgt(int i, int j)
{
  return(Height[i*Space][j*Space]);
}

int ii, jj, kk;
int Deviation;
int HalfDeviation;
int Skip, Offset;

void InterpolateHeight(int i, int j, int i0, int j0, int i1, int j1)
{
  float r;

  r=(float)(random(32766))/32767;
  Height[i*Space][j*Space]=(Hgt(i0, j0)+Hgt(i1, j1))/2+Round(r*Deviation-HalfDeviation);
}

void AssignHeightsAlongX()
{
  int x, y;

  jj=0;
  do
  {
    ii=Offset;
    do
    {
      InterpolateHeight(ii, jj, ii-Offset, jj, ii+Offset, jj);
      x=Points-ii;
      y=Points-jj;
      InterpolateHeight(x, y, x+Offset, y, x-Offset, y);
      ii+=Skip;
    }
    while(ii<=Points);
    jj+=Skip;
  }
  while(jj<=Points);
}

void AssignHeightsAlongY()
{
  int x, y;

  ii=Points;
  do
  {
    jj=Offset;
    do
    {
      InterpolateHeight(ii, jj, ii, jj+Offset, ii, jj-Offset);
      x=Points-ii;
      y=Points-jj;
      InterpolateHeight(x, y, x, y-Offset, x, y+Offset);
      jj+=Skip;
    }
    while(jj<=ii);
    ii-=Skip;
  }
  while(ii>0);
}

void AssignHeightsAlongDiagonal()
{
  int x, y;
  int l;

  ii=0;
  do
  {
    jj=Offset;
    kk=Points-ii;
    do
    {
      l=ii+jj;
      InterpolateHeight(l, jj, l-Offset, jj-Offset, l+Offset, jj+Offset);
      x=Points-l;
      y=Points-jj;
      InterpolateHeight(x, y, x+Offset, y+Offset, x-Offset, y-Offset);
      jj+=Skip;
    }
    while(jj<=kk);
    ii+=Skip;
  }
  while(ii<Points);
}

void CalculateFractalHeights()
{
  int n;

  HalfDeviation=Roughness;
  Offset=Points;
  for(n=1; n<=NumberLevels; n++)
  {
    Deviation=HalfDeviation;
    HalfDeviation=Deviation/2;
    Skip=Offset;
    Offset=Skip/2;
    printf("\nPass Level %d --> ", n);
    AssignHeightsAlongX();
    printf(" X");
    AssignHeightsAlongY();
    printf(" Y");
    AssignHeightsAlongDiagonal();
    printf(" Diag\n");
  }
  puts("");
}

void ZeroHeightBufferBelowWaterLevel()
{
  int i, j;

  for(i=0 ; i<=Res; i++)
  {
    for(j=0 ; j<=Res; j++)
    {
      if(Height[i][j]<0)
	Height[i][j]=0;
    }
  }
}

/* ***********************************************************************
   *									 *
   *				Main Program				 *
   *									 *
   ***********************************************************************
*/

void main()
{
  Title();
  printf("Mountain Scene Generator\n\nBy Chris Watkins\n\n");
  ClearHeightBuffer();
  Initialization();
  Res=Points;
  CalculateFractalHeights();
  ZeroHeightBufferBelowWaterLevel();
  strcpy(ObjectFile, "MOUNTAIN");
  SaveHeightBuffer(ObjectFile);
  ExitGraphics();
}
