/* ***********************************************************************
   *									 *
   *		      Two Particle Orbit Simulator			 *
   *									 *
   *									 *
   *				Program by				 *
   *			   Christopher D. Watkins			 *
   *									 *
   *		  	     'C' conversion by				 *
   *			        Larry Sharp				 *
   *									 *
   ***********************************************************************

   increase "dt" for speed
*/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "math.h"
#include "math.inc"
#include "graph.inc"

int MSize;
int x, y;
int oVx1, oVy1;
int oAx1, oAy1;
int oVx2, oVy2;
int oAx2, oAy2;

void InitMeters()
{
  MSize=30;
  Circle(MSize, MSize, MSize-4, 35);
  oVx1=MSize;
  oVy1=MSize;
  oAx1=MSize;
  oAy1=MSize;
  oVx2=MSize;
  oVy2=MSize;
  oAx2=MSize;
  oAy2=MSize;
}

void Meter(float dx, float dy, int *xt, int *yt, int Radius, int Color)
{
  float r;

  Draw(MSize, MSize, *xt, *yt, 0);
  r=Radius/sqrt(SqrFP(dx)+SqrFP(dy))-5;
  x=Round(dx*r)+MSize;
  y=-Round(dy*r)+MSize;
  *xt=x;
  *yt=y;
  Draw(MSize, MSize, x, y, Color);
}

float X1, Y1, Vx1, Vy1, Ax1, Ay1;
float X2, Y2, Vx2, Vy2, Ax2, Ay2;
float OneOverDistSqr, dt;
float Dx, Dy, Tx, Ty;
int   M1, M2, Xp1, Yp1, Xp2, Yp2;

void main()
{
  M1=6;
  M2=6;

  X1= -40;     Y1= 00.0;
  X2=  40;     Y2= 00.0;

  Vx1= 0.000;  Vy1= 1.000;
  Vx2= 0.000;  Vy2=-1.000;

  dt=0.1;

  InitGraphics();
  InitMeters();
  do
  {
    Xp1=160+Trunc(X1);
    Yp1=100-Trunc(Y1);
    Xp2=160+Trunc(X2);
    Yp2=100-Trunc(Y2);
    Draw(Xp1, Yp1, Xp2, Yp2,0);
    Circle(Xp1, Yp1, M1, 71);
    Circle(Xp2, Yp2, M2, 143);
    X1+=Vx1*dt;
    Y1+=Vy1*dt;
    X2+=Vx2*dt;
    Y2+=Vy2*dt;
    Dx=X2-X1;
    Dy=Y2-Y1;
    OneOverDistSqr=1.0/(Sqr(Dx)+Sqr(Dy));
    Tx=Dx*OneOverDistSqr;
    Ty=Dy*OneOverDistSqr;
    Ax1=M2*Tx;
    Ay1=M2*Ty;
    Ax2=-M1*Tx;
    Ay2=-M1*Ty;
    Vx1+=Ax1*dt;
    Vy1+=Ay1*dt;
    Vx2+=Ax2*dt;
    Vy2+=Ay2*dt;
    Meter(Vx1, Vy1, &oVx1, &oVy1, 25, 51);
    Meter(Ax1, Ay1, &oAx1, &oAy1, 12, 71);
    Meter(Vx2, Vy2, &oVx2, &oVy2, 25, 123);
    Meter(Ax2, Ay2, &oAx2, &oAy2, 12, 143);
    Draw(Xp1, Yp1, Xp2, Yp2, 0);
    Circle(Xp1, Yp1, M1, 0);
    Circle(Xp2, Yp2, M2, 0);
  }
  while(!(kbhit()));
  ExitGraphics();
}


