/* ***********************************************************************
   *									 *
   *	               Generate Equation Plot Database			 *
   *									 *
   *				Program by				 *
   *			   Christopher D. Watkins			 *
   *									 *
   *			     'C' conversion by				 *
   *                            Larry Sharp				 *
   *									 *
   ***********************************************************************
*/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "math.h"
#include "string.h"
#include "math.inc"
#include "graph.inc"
#include "render.inc"

/* ***********************************************************************
   *									 *
   *				 Equations				 *
   *									 *
   ***********************************************************************
*/

/*
#define Span 5

char ObjF[]="PLOTEQN1";

float zf(float x, float y)
{
  float c;

  c=SqrFP(x)+SqrFP(y);
  return(75.0/(c+1.0));
}
*/

/*
#define Span 5

char ObjF[]="PLOTEQN2";

float zf(float x, float y)
{
  return(6.0*(cos(x*y)+1.0));
}
*/

/*
#define Span 5

char ObjF[]="PLOTEQN3";

float zf(float x, float y)
{
  float c;

  c=SqrFP(x)+SqrFP(y);
  return(20.0*(sin(sqrt(c))+1.0));
}
*/


#define Span 2.75

char ObjF[]="PLOTEQN4";

float zf(float x, float y)
{
  float c;

  c=SqrFP(x)+SqrFP(y);
  return(10.0*(1.0+sqrt(c)+sin(SqrFP(c)*0.1)+sin(x*y)));
}


/* ******************************************************************** */

void CreatEquationPlotHeightBuffer(float Xlft, float Xrgt,
				   float Ybot, float Ytop)
{
  int ix, iy, iz;
  float x, y;
  float dx, dy;

  MaxHeight=Res;
  HeightBufferScalingFactor();
  dx=(Xrgt-Xlft)/(Res-1);
  dy=(Ytop-Ybot)/(Res-1);
  for(ix=0; ix<Res; ix++)
  {
    x=Xlft+ix*dx;
    for(iy=0; iy<Res; iy++)
    {
      y=Ybot+iy*dy;
      iz=Round(zf(x, y));
      if(iz<0)
      {
	ExitGraphics();
	printf("Adjust the equation : z value less than zero\n");
	delay(2000);
	exit(1);
      }
      Height[ix][iy]=iz;
      CartesianPlot3D(ix-Res/2, iy-Res/2, iz, (iz*MaxCol)%255);
    }
  }
}

/* ***********************************************************************
   *									 *
   *				Main Program				 *
   *									 *
   ***********************************************************************
*/

void main()
{
  clrscr();
  printf("Creating Equation Plot Height Buffer\n\n");
  ClearHeightBuffer();
  Res=MaxRes;
  InitPerspective(false, 0, 0, 500, 500);
  InitPlotting(240, 18);
  InitGraphics();
  CreatEquationPlotHeightBuffer(-Span, Span, -Span, Span);
  strcpy(ObjectFile, ObjF);
  SaveHeightBuffer(ObjectFile);
  ExitGraphics();
}
