/* ***********************************************************************
   *									 *
   *		   Equation Plot and Grid Database Generator		 *
   *									 *
   *				Program by				 *
   *			   Christopher D. Watkins			 *
   *									 *
   *			     'C' conversion by				 *
   *                            Larry Sharp				 *
   *									 *
   ***********************************************************************
*/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "math.h"
#include "string.h"
#include "alloc.h"
#include "math.inc"
#include "graph.inc"
#include "model.inc"
#include "shpmk.inc"

/* ***********************************************************************
   *									 *
   *				Equations				 *
   *									 *
   ***********************************************************************
*/


char ObjF[]="GRID.DAT";

#define Span 5
#define Contour 13
#define Offset 0.5

float zf()
{
  return(0.0);
}


/*
char ObjF[]="PLOTEQN1.DAT";

#define Span 5.0
#define Contour 58.0
#define Offset 0.0

float zf(float x, float y)
{
  float c;

  c=SqrFP(x)+SqrFP(y);
  return(75.0/(c+1.0));
}
*/

/*
char ObjF[]="PLOTEQN2.DAT";

#define Span 5.0
#define Contour 58.0
#define Offset 0.0

float zf(float x, float y)
{
  return(6.0*(cos(x*y*0.7)+1.0));
}
*/

/*
char ObjF[]="PLOTEQN3.DAT";

#define Span 5.0
#define Contour 58.0
#define Offset 0.0

float zf(float x, float y)
{
  float c;

  c=SqrFP(x)+SqrFP(y);
  return(20.0*(sin(sqrt(c)))+1.0);
}
*/

/*
char ObjF[]="PLOTEQN4.DAT";

#define Span 2.75
#define Contour 50.0
#define Offset 0.0

float zf(float x, float y)
{
  float c;

  c=SqrFP(x)+SqrFP(y)*0.65;
  return(10.0*(1.0+sqrt(c*0.5)+sin(SqrFP(c)*0.1)+sin(x*y)));
}
*/

/* *********************************************************************** */

float Dx, HalfDx;
float Dy, HalfDy;
float x, y, z;
float sx, sy, sz;
float ix, iy;
float ex, ey;

void SetupPlotEqn(float Xlft, float Xrgt,
		  float Ybot, float Ytop,
		  int HorzContours, int VertContours,
		  float offset)
{
  VertexNum=1;
  VertexNumInFacet=1;
  LastFacet=HorzContours*VertContours;
  LastVertexNumInFacet=MaxVertexNumInFacet;
  LastVertex=LastFacet*LastVertexNumInFacet;
  sx=200.0/100.0/(Xrgt-Xlft)*10.0/11.0;
  sy=200.0/100.0/(Ytop-Ybot)*10.0/11.0;
  sz=1.0/100.0;
  Dx=(Xrgt-Xlft)/(float)(HorzContours-1);
  Dy=(Ybot-Ytop)/(float)(VertContours-1);
  HalfDx=Dx/2.0/(offset+1.0);
  HalfDy=Dy/2.0/(offset+1.0);
  ix=Xlft;
  iy=Ytop;
  ex=Xrgt;
  ey=Ybot;
}

void MakePlotEqnDatabase()
{
  FacetNum=0;
  x=ix;
  do
  {
    y=iy;
    do
    {
      ++FacetNum;
      z=zf((x-HalfDx), (y+HalfDy));
      AddVertex(sx*(x-HalfDx), sy*(y+HalfDy), sz*z);
      z=zf((x+HalfDx), (y+HalfDy));
      AddVertex(sx*(x+HalfDx), sy*(y+HalfDy), sz*z);
      z=zf((x+HalfDx), (y-HalfDy));
      AddVertex(sx*(x+HalfDx), sy*(y-HalfDy), sz*z);
      z=zf((x-HalfDx), (y-HalfDy));
      AddVertex(sx*(x-HalfDx), sy*(y-HalfDy), sz*z);
      VertexNumInFacet=1;
      y+=Dy;
    }
    while(y>=ey);
    x+=Dx;
  }
  while(x<=ex);
}

/* ***********************************************************************
   *									 *
   *				Main Program				 *
   *									 *
   ***********************************************************************
*/

void main()
{
  Facet=farcalloc(((MaxFacet+1)*(MaxVertexNumInFacet+1)), sizeof(int));
  InitVertexMaker();
  SetupPlotEqn(-Span, Span, -Span, Span, Contour, Contour, Offset);
  MakePlotEqnDatabase();
  SaveData(ObjF);
  ExitGraphics();
  farfree(Facet);
}
