/* ***********************************************************************
   *									 *
   *	      Program for Generation of Scene Files for MODEL.C          *
   *									 *
   *				Program by				 *
   *			   Christopher D. Watkins			 *
   *									 *
   *			     'C' conversion by				 *
   *                            Larry Sharp				 *
   *									 *
   ***********************************************************************
*/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "string.h"
#include "math.inc"
#include "graph.inc"

/* ***********************************************************************
   *									 *
   *	                  Keyboard Response Routines		         *
   *									 *
   ***********************************************************************

   Response       - returns true or false to a Y or N keyboard stroke
*/

#define MaxObjects 30

typedef char Name[20];

char Resp[6];

void Response()
{
  char c;

  strcpy(Resp, "\n");
  while((!(c=='Y')) && (!(c=='N')))
  {
    while(!(kbhit()));
    c=toupper(getch());
  }
  putch(c);
  if(c=='Y')
    strcpy(Resp, "true");
  else
    strcpy(Resp, "false");
  puts("");
}

void NumberResponse()
{
  char c;

  strcpy(Resp, "\n");
  while(!(isdigit(c)))
  {
    c=getch();
  }
  putch(c);
  Resp[0]=c;
}


/* ***********************************************************************
   *									 *
   *	                       Save Scene Data		                 *
   *									 *
   ***********************************************************************

   GetSceneFile - get name of scene file
   SaveScene    - save description of scene
*/

FILE *TextDiskFile;
Name SceneFile;

void GetSceneFile()
{
  int i;
  Byte x, y;

  printf("\nEnter File Name -> ");
  x=wherex();
  y=wherey();
  gets(SceneFile);
  if(!(strcmp(SceneFile, "")))
  {
    strcpy(SceneFile, "TEST");
    gotoxy(x, y);
    puts(SceneFile);
  }
  puts("");
  for(i=0; i<strlen(SceneFile); i++)
    SceneFile[i]=toupper(SceneFile[i]);
  strcat(SceneFile, ".SCN");
}

void SaveDescription(Name FileName)
{
  char Descrip[81];
  int NumbResp;
  Boolean BoolResp;
  float R1, R2, R3, R4;
  int I1, I2, I3, I4;
  Name ObjectsName;
  int T, L1;

  TextDiskFile=fopen(FileName, "w+t");
  printf("Description of the Scene => ");
  gets(Descrip);
  fprintf(TextDiskFile, "%s\n\n", Descrip);
  printf("Perspective Display? ");
  Response();
  fprintf(TextDiskFile, "%s ", Resp);
  if(!(strcmp(Resp, "true")))
  {
    printf("(Mx, My, Mz, D) = ");
    scanf("%d %d %d %d", &I1, &I2, &I3, &I4);
    fprintf(TextDiskFile, "%3d %3d %3d %3d\n", I1, I2, I3, I4);
  }
  else
    fprintf(TextDiskFile, "0.0  0.0  0.0  0.0\n");
  printf("Direction for Viewing\n  Around the z-Axis = ");
  scanf("%d", &NumbResp);
  fprintf(TextDiskFile, "%d\n", NumbResp);
  printf("  Off the z-Axis = ");
  scanf("%d", &NumbResp);
  fprintf(TextDiskFile, "%d\n", NumbResp);
  printf("\nDirection for Light\n  Around the z-Axis = ");
  scanf("%d", &NumbResp);
  fprintf(TextDiskFile, "%d\n", NumbResp);
  printf("  Off the z-Axis = ");
  scanf("%d", &NumbResp);
  fprintf(TextDiskFile, "%d\n", NumbResp);
  printf("Vertical Sort of Objects? ");
  Response();
  fprintf(TextDiskFile, "%s\n", Resp);
  printf("Place Edge Reflectors at (x=-100, y=-100 and z=-100)? ");
  Response();
  fprintf(TextDiskFile, "%s\n", Resp);
  printf("Place Edge Reflectors at (x=-100, y=-100 and z=0)? ");
  Response();
  fprintf(TextDiskFile, "%s\n", Resp);
  printf("\nNow add objects to the scene ->\n");
  for(T=1; T<=MaxObjects; T++)
  {
    printf("Enter the Objects Name => ");
    scanf("%s", &ObjectsName);
    strcat(ObjectsName, ".DAT");
    fprintf(TextDiskFile, "\n%s\n", ObjectsName);
    printf("Color of the Object => ");
    NumberResponse();
    fprintf(TextDiskFile, "%s\n", Resp);
    puts("");
    printf("Scale Factors (Sx Sy Sz) => ");
    scanf("%f %f %f", &R1, &R2, &R3);
    fprintf(TextDiskFile, "%4f %4f %4f\n", R1, R2, R3);
    printf("Rotate Factors (Rx Ry Rz) => ");
    scanf("%f %f %f", &R1, &R2, &R3);
    fprintf(TextDiskFile, "%4f %4f %4f\n", R1, R2, R3);
    printf("Translate Factors (Tx Ty Tz) =>" );
    scanf("%f %f %f", &R1, &R2, &R3);
    fprintf(TextDiskFile, "%4f %4f %4f\n", R1, R2, R3);
    printf("Reflect this Object in Mirrored Objects? ");
    Response();
    fprintf(TextDiskFile, "%s\n", Resp);
    printf("Allow this Object to be Sorted for Placement? ");
    Response();
    fprintf(TextDiskFile, "%s\n", Resp);
    printf("This Object is a Mirror? ");
    Response();
    fprintf(TextDiskFile, "%s\n", Resp);
    printf("Add another Object to Scene? ");
    Response();
    if(strcmp(Resp, "true"))
      goto L1;
    puts("");
  }
L1:
  fclose(TextDiskFile);
}

void main()
{
  clrscr();
  printf("Program to Generate a Scene File for Model\n\n");
  GetSceneFile();
  SaveDescription(SceneFile);
}
